﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ServiceConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace EC2
{
namespace Model
{
  class CreateVpcEndpointServiceConfigurationResponse
  {
  public:
    AWS_EC2_API CreateVpcEndpointServiceConfigurationResponse();
    AWS_EC2_API CreateVpcEndpointServiceConfigurationResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    AWS_EC2_API CreateVpcEndpointServiceConfigurationResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    ///@{
    /**
     * <p>Information about the service configuration.</p>
     */
    inline const ServiceConfiguration& GetServiceConfiguration() const{ return m_serviceConfiguration; }
    inline void SetServiceConfiguration(const ServiceConfiguration& value) { m_serviceConfiguration = value; }
    inline void SetServiceConfiguration(ServiceConfiguration&& value) { m_serviceConfiguration = std::move(value); }
    inline CreateVpcEndpointServiceConfigurationResponse& WithServiceConfiguration(const ServiceConfiguration& value) { SetServiceConfiguration(value); return *this;}
    inline CreateVpcEndpointServiceConfigurationResponse& WithServiceConfiguration(ServiceConfiguration&& value) { SetServiceConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency
     * of the request.</p>
     */
    inline const Aws::String& GetClientToken() const{ return m_clientToken; }
    inline void SetClientToken(const Aws::String& value) { m_clientToken = value; }
    inline void SetClientToken(Aws::String&& value) { m_clientToken = std::move(value); }
    inline void SetClientToken(const char* value) { m_clientToken.assign(value); }
    inline CreateVpcEndpointServiceConfigurationResponse& WithClientToken(const Aws::String& value) { SetClientToken(value); return *this;}
    inline CreateVpcEndpointServiceConfigurationResponse& WithClientToken(Aws::String&& value) { SetClientToken(std::move(value)); return *this;}
    inline CreateVpcEndpointServiceConfigurationResponse& WithClientToken(const char* value) { SetClientToken(value); return *this;}
    ///@}

    ///@{
    
    inline const ResponseMetadata& GetResponseMetadata() const{ return m_responseMetadata; }
    inline void SetResponseMetadata(const ResponseMetadata& value) { m_responseMetadata = value; }
    inline void SetResponseMetadata(ResponseMetadata&& value) { m_responseMetadata = std::move(value); }
    inline CreateVpcEndpointServiceConfigurationResponse& WithResponseMetadata(const ResponseMetadata& value) { SetResponseMetadata(value); return *this;}
    inline CreateVpcEndpointServiceConfigurationResponse& WithResponseMetadata(ResponseMetadata&& value) { SetResponseMetadata(std::move(value)); return *this;}
    ///@}
  private:

    ServiceConfiguration m_serviceConfiguration;

    Aws::String m_clientToken;

    ResponseMetadata m_responseMetadata;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
