﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/frauddetector/model/EventType.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace FraudDetector
{
namespace Model
{
  class GetEventTypesResult
  {
  public:
    AWS_FRAUDDETECTOR_API GetEventTypesResult();
    AWS_FRAUDDETECTOR_API GetEventTypesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_FRAUDDETECTOR_API GetEventTypesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An array of event types.</p>
     */
    inline const Aws::Vector<EventType>& GetEventTypes() const{ return m_eventTypes; }
    inline void SetEventTypes(const Aws::Vector<EventType>& value) { m_eventTypes = value; }
    inline void SetEventTypes(Aws::Vector<EventType>&& value) { m_eventTypes = std::move(value); }
    inline GetEventTypesResult& WithEventTypes(const Aws::Vector<EventType>& value) { SetEventTypes(value); return *this;}
    inline GetEventTypesResult& WithEventTypes(Aws::Vector<EventType>&& value) { SetEventTypes(std::move(value)); return *this;}
    inline GetEventTypesResult& AddEventTypes(const EventType& value) { m_eventTypes.push_back(value); return *this; }
    inline GetEventTypesResult& AddEventTypes(EventType&& value) { m_eventTypes.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The next page token.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline GetEventTypesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline GetEventTypesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline GetEventTypesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetEventTypesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetEventTypesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetEventTypesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<EventType> m_eventTypes;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace FraudDetector
} // namespace Aws
