﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/frauddetector/model/Outcome.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace FraudDetector
{
namespace Model
{
  class GetOutcomesResult
  {
  public:
    AWS_FRAUDDETECTOR_API GetOutcomesResult();
    AWS_FRAUDDETECTOR_API GetOutcomesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_FRAUDDETECTOR_API GetOutcomesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The outcomes. </p>
     */
    inline const Aws::Vector<Outcome>& GetOutcomes() const{ return m_outcomes; }
    inline void SetOutcomes(const Aws::Vector<Outcome>& value) { m_outcomes = value; }
    inline void SetOutcomes(Aws::Vector<Outcome>&& value) { m_outcomes = std::move(value); }
    inline GetOutcomesResult& WithOutcomes(const Aws::Vector<Outcome>& value) { SetOutcomes(value); return *this;}
    inline GetOutcomesResult& WithOutcomes(Aws::Vector<Outcome>&& value) { SetOutcomes(std::move(value)); return *this;}
    inline GetOutcomesResult& AddOutcomes(const Outcome& value) { m_outcomes.push_back(value); return *this; }
    inline GetOutcomesResult& AddOutcomes(Outcome&& value) { m_outcomes.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The next page token for subsequent requests.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline GetOutcomesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline GetOutcomesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline GetOutcomesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetOutcomesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetOutcomesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetOutcomesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<Outcome> m_outcomes;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace FraudDetector
} // namespace Aws
