﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

  /**
   */
  class DeleteMalwareProtectionPlanRequest : public GuardDutyRequest
  {
  public:
    AWS_GUARDDUTY_API DeleteMalwareProtectionPlanRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DeleteMalwareProtectionPlan"; }

    AWS_GUARDDUTY_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier associated with Malware Protection plan resource.</p>
     */
    inline const Aws::String& GetMalwareProtectionPlanId() const{ return m_malwareProtectionPlanId; }
    inline bool MalwareProtectionPlanIdHasBeenSet() const { return m_malwareProtectionPlanIdHasBeenSet; }
    inline void SetMalwareProtectionPlanId(const Aws::String& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = value; }
    inline void SetMalwareProtectionPlanId(Aws::String&& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = std::move(value); }
    inline void SetMalwareProtectionPlanId(const char* value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId.assign(value); }
    inline DeleteMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(const Aws::String& value) { SetMalwareProtectionPlanId(value); return *this;}
    inline DeleteMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(Aws::String&& value) { SetMalwareProtectionPlanId(std::move(value)); return *this;}
    inline DeleteMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(const char* value) { SetMalwareProtectionPlanId(value); return *this;}
    ///@}
  private:

    Aws::String m_malwareProtectionPlanId;
    bool m_malwareProtectionPlanIdHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
