﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/guardduty/model/Threat.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Information about the malware scan that generated a GuardDuty
   * finding.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareScanDetails">AWS
   * API Reference</a></p>
   */
  class MalwareScanDetails
  {
  public:
    AWS_GUARDDUTY_API MalwareScanDetails();
    AWS_GUARDDUTY_API MalwareScanDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API MalwareScanDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Information about the detected threats associated with the generated
     * GuardDuty finding.</p>
     */
    inline const Aws::Vector<Threat>& GetThreats() const{ return m_threats; }
    inline bool ThreatsHasBeenSet() const { return m_threatsHasBeenSet; }
    inline void SetThreats(const Aws::Vector<Threat>& value) { m_threatsHasBeenSet = true; m_threats = value; }
    inline void SetThreats(Aws::Vector<Threat>&& value) { m_threatsHasBeenSet = true; m_threats = std::move(value); }
    inline MalwareScanDetails& WithThreats(const Aws::Vector<Threat>& value) { SetThreats(value); return *this;}
    inline MalwareScanDetails& WithThreats(Aws::Vector<Threat>&& value) { SetThreats(std::move(value)); return *this;}
    inline MalwareScanDetails& AddThreats(const Threat& value) { m_threatsHasBeenSet = true; m_threats.push_back(value); return *this; }
    inline MalwareScanDetails& AddThreats(Threat&& value) { m_threatsHasBeenSet = true; m_threats.push_back(std::move(value)); return *this; }
    ///@}
  private:

    Aws::Vector<Threat> m_threats;
    bool m_threatsHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
