﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Represents the <code>key:value</code> pair to be matched against given
   * resource property.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ScanConditionPair">AWS
   * API Reference</a></p>
   */
  class ScanConditionPair
  {
  public:
    AWS_GUARDDUTY_API ScanConditionPair();
    AWS_GUARDDUTY_API ScanConditionPair(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API ScanConditionPair& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Represents the <b>key</b> in the map condition.</p>
     */
    inline const Aws::String& GetKey() const{ return m_key; }
    inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
    inline void SetKey(const Aws::String& value) { m_keyHasBeenSet = true; m_key = value; }
    inline void SetKey(Aws::String&& value) { m_keyHasBeenSet = true; m_key = std::move(value); }
    inline void SetKey(const char* value) { m_keyHasBeenSet = true; m_key.assign(value); }
    inline ScanConditionPair& WithKey(const Aws::String& value) { SetKey(value); return *this;}
    inline ScanConditionPair& WithKey(Aws::String&& value) { SetKey(std::move(value)); return *this;}
    inline ScanConditionPair& WithKey(const char* value) { SetKey(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents optional <b>value</b> in the map condition. If not specified, only
     * the <b>key</b> will be matched.</p>
     */
    inline const Aws::String& GetValue() const{ return m_value; }
    inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
    inline void SetValue(const Aws::String& value) { m_valueHasBeenSet = true; m_value = value; }
    inline void SetValue(Aws::String&& value) { m_valueHasBeenSet = true; m_value = std::move(value); }
    inline void SetValue(const char* value) { m_valueHasBeenSet = true; m_value.assign(value); }
    inline ScanConditionPair& WithValue(const Aws::String& value) { SetValue(value); return *this;}
    inline ScanConditionPair& WithValue(Aws::String&& value) { SetValue(std::move(value)); return *this;}
    inline ScanConditionPair& WithValue(const char* value) { SetValue(value); return *this;}
    ///@}
  private:

    Aws::String m_key;
    bool m_keyHasBeenSet = false;

    Aws::String m_value;
    bool m_valueHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
