﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/guardduty/model/UpdateProtectedResource.h>
#include <utility>

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

  /**
   */
  class UpdateMalwareProtectionPlanRequest : public GuardDutyRequest
  {
  public:
    AWS_GUARDDUTY_API UpdateMalwareProtectionPlanRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateMalwareProtectionPlan"; }

    AWS_GUARDDUTY_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier associated with the Malware Protection plan.</p>
     */
    inline const Aws::String& GetMalwareProtectionPlanId() const{ return m_malwareProtectionPlanId; }
    inline bool MalwareProtectionPlanIdHasBeenSet() const { return m_malwareProtectionPlanIdHasBeenSet; }
    inline void SetMalwareProtectionPlanId(const Aws::String& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = value; }
    inline void SetMalwareProtectionPlanId(Aws::String&& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = std::move(value); }
    inline void SetMalwareProtectionPlanId(const char* value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId.assign(value); }
    inline UpdateMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(const Aws::String& value) { SetMalwareProtectionPlanId(value); return *this;}
    inline UpdateMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(Aws::String&& value) { SetMalwareProtectionPlanId(std::move(value)); return *this;}
    inline UpdateMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(const char* value) { SetMalwareProtectionPlanId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the IAM role with permissions to scan and add
     * tags to the associated protected resource.</p>
     */
    inline const Aws::String& GetRole() const{ return m_role; }
    inline bool RoleHasBeenSet() const { return m_roleHasBeenSet; }
    inline void SetRole(const Aws::String& value) { m_roleHasBeenSet = true; m_role = value; }
    inline void SetRole(Aws::String&& value) { m_roleHasBeenSet = true; m_role = std::move(value); }
    inline void SetRole(const char* value) { m_roleHasBeenSet = true; m_role.assign(value); }
    inline UpdateMalwareProtectionPlanRequest& WithRole(const Aws::String& value) { SetRole(value); return *this;}
    inline UpdateMalwareProtectionPlanRequest& WithRole(Aws::String&& value) { SetRole(std::move(value)); return *this;}
    inline UpdateMalwareProtectionPlanRequest& WithRole(const char* value) { SetRole(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about whether the tags will be added to the S3 object after
     * scanning.</p>
     */
    inline const MalwareProtectionPlanActions& GetActions() const{ return m_actions; }
    inline bool ActionsHasBeenSet() const { return m_actionsHasBeenSet; }
    inline void SetActions(const MalwareProtectionPlanActions& value) { m_actionsHasBeenSet = true; m_actions = value; }
    inline void SetActions(MalwareProtectionPlanActions&& value) { m_actionsHasBeenSet = true; m_actions = std::move(value); }
    inline UpdateMalwareProtectionPlanRequest& WithActions(const MalwareProtectionPlanActions& value) { SetActions(value); return *this;}
    inline UpdateMalwareProtectionPlanRequest& WithActions(MalwareProtectionPlanActions&& value) { SetActions(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the protected resource that is associated with the created
     * Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported
     * protected resource.</p>
     */
    inline const UpdateProtectedResource& GetProtectedResource() const{ return m_protectedResource; }
    inline bool ProtectedResourceHasBeenSet() const { return m_protectedResourceHasBeenSet; }
    inline void SetProtectedResource(const UpdateProtectedResource& value) { m_protectedResourceHasBeenSet = true; m_protectedResource = value; }
    inline void SetProtectedResource(UpdateProtectedResource&& value) { m_protectedResourceHasBeenSet = true; m_protectedResource = std::move(value); }
    inline UpdateMalwareProtectionPlanRequest& WithProtectedResource(const UpdateProtectedResource& value) { SetProtectedResource(value); return *this;}
    inline UpdateMalwareProtectionPlanRequest& WithProtectedResource(UpdateProtectedResource&& value) { SetProtectedResource(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_malwareProtectionPlanId;
    bool m_malwareProtectionPlanIdHasBeenSet = false;

    Aws::String m_role;
    bool m_roleHasBeenSet = false;

    MalwareProtectionPlanActions m_actions;
    bool m_actionsHasBeenSet = false;

    UpdateProtectedResource m_protectedResource;
    bool m_protectedResourceHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
