﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/IoTTwinMakerRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iottwinmaker/model/PropertyDefinitionRequest.h>
#include <aws/iottwinmaker/model/FunctionRequest.h>
#include <aws/iottwinmaker/model/PropertyGroupRequest.h>
#include <aws/iottwinmaker/model/CompositeComponentTypeRequest.h>
#include <utility>

namespace Aws
{
namespace IoTTwinMaker
{
namespace Model
{

  /**
   */
  class UpdateComponentTypeRequest : public IoTTwinMakerRequest
  {
  public:
    AWS_IOTTWINMAKER_API UpdateComponentTypeRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateComponentType"; }

    AWS_IOTTWINMAKER_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The ID of the workspace.</p>
     */
    inline const Aws::String& GetWorkspaceId() const{ return m_workspaceId; }
    inline bool WorkspaceIdHasBeenSet() const { return m_workspaceIdHasBeenSet; }
    inline void SetWorkspaceId(const Aws::String& value) { m_workspaceIdHasBeenSet = true; m_workspaceId = value; }
    inline void SetWorkspaceId(Aws::String&& value) { m_workspaceIdHasBeenSet = true; m_workspaceId = std::move(value); }
    inline void SetWorkspaceId(const char* value) { m_workspaceIdHasBeenSet = true; m_workspaceId.assign(value); }
    inline UpdateComponentTypeRequest& WithWorkspaceId(const Aws::String& value) { SetWorkspaceId(value); return *this;}
    inline UpdateComponentTypeRequest& WithWorkspaceId(Aws::String&& value) { SetWorkspaceId(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& WithWorkspaceId(const char* value) { SetWorkspaceId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A Boolean value that specifies whether an entity can have more than one
     * component of this type.</p>
     */
    inline bool GetIsSingleton() const{ return m_isSingleton; }
    inline bool IsSingletonHasBeenSet() const { return m_isSingletonHasBeenSet; }
    inline void SetIsSingleton(bool value) { m_isSingletonHasBeenSet = true; m_isSingleton = value; }
    inline UpdateComponentTypeRequest& WithIsSingleton(bool value) { SetIsSingleton(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the component type.</p>
     */
    inline const Aws::String& GetComponentTypeId() const{ return m_componentTypeId; }
    inline bool ComponentTypeIdHasBeenSet() const { return m_componentTypeIdHasBeenSet; }
    inline void SetComponentTypeId(const Aws::String& value) { m_componentTypeIdHasBeenSet = true; m_componentTypeId = value; }
    inline void SetComponentTypeId(Aws::String&& value) { m_componentTypeIdHasBeenSet = true; m_componentTypeId = std::move(value); }
    inline void SetComponentTypeId(const char* value) { m_componentTypeIdHasBeenSet = true; m_componentTypeId.assign(value); }
    inline UpdateComponentTypeRequest& WithComponentTypeId(const Aws::String& value) { SetComponentTypeId(value); return *this;}
    inline UpdateComponentTypeRequest& WithComponentTypeId(Aws::String&& value) { SetComponentTypeId(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& WithComponentTypeId(const char* value) { SetComponentTypeId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The description of the component type.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }
    inline UpdateComponentTypeRequest& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline UpdateComponentTypeRequest& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>An object that maps strings to the property definitions in the component
     * type. Each string in the mapping must be unique to this object.</p>
     */
    inline const Aws::Map<Aws::String, PropertyDefinitionRequest>& GetPropertyDefinitions() const{ return m_propertyDefinitions; }
    inline bool PropertyDefinitionsHasBeenSet() const { return m_propertyDefinitionsHasBeenSet; }
    inline void SetPropertyDefinitions(const Aws::Map<Aws::String, PropertyDefinitionRequest>& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions = value; }
    inline void SetPropertyDefinitions(Aws::Map<Aws::String, PropertyDefinitionRequest>&& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions = std::move(value); }
    inline UpdateComponentTypeRequest& WithPropertyDefinitions(const Aws::Map<Aws::String, PropertyDefinitionRequest>& value) { SetPropertyDefinitions(value); return *this;}
    inline UpdateComponentTypeRequest& WithPropertyDefinitions(Aws::Map<Aws::String, PropertyDefinitionRequest>&& value) { SetPropertyDefinitions(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& AddPropertyDefinitions(const Aws::String& key, const PropertyDefinitionRequest& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions.emplace(key, value); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyDefinitions(Aws::String&& key, const PropertyDefinitionRequest& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions.emplace(std::move(key), value); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyDefinitions(const Aws::String& key, PropertyDefinitionRequest&& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyDefinitions(Aws::String&& key, PropertyDefinitionRequest&& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions.emplace(std::move(key), std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyDefinitions(const char* key, PropertyDefinitionRequest&& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyDefinitions(const char* key, const PropertyDefinitionRequest& value) { m_propertyDefinitionsHasBeenSet = true; m_propertyDefinitions.emplace(key, value); return *this; }
    ///@}

    ///@{
    /**
     * <p>Specifies the component type that this component type extends.</p>
     */
    inline const Aws::Vector<Aws::String>& GetExtendsFrom() const{ return m_extendsFrom; }
    inline bool ExtendsFromHasBeenSet() const { return m_extendsFromHasBeenSet; }
    inline void SetExtendsFrom(const Aws::Vector<Aws::String>& value) { m_extendsFromHasBeenSet = true; m_extendsFrom = value; }
    inline void SetExtendsFrom(Aws::Vector<Aws::String>&& value) { m_extendsFromHasBeenSet = true; m_extendsFrom = std::move(value); }
    inline UpdateComponentTypeRequest& WithExtendsFrom(const Aws::Vector<Aws::String>& value) { SetExtendsFrom(value); return *this;}
    inline UpdateComponentTypeRequest& WithExtendsFrom(Aws::Vector<Aws::String>&& value) { SetExtendsFrom(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& AddExtendsFrom(const Aws::String& value) { m_extendsFromHasBeenSet = true; m_extendsFrom.push_back(value); return *this; }
    inline UpdateComponentTypeRequest& AddExtendsFrom(Aws::String&& value) { m_extendsFromHasBeenSet = true; m_extendsFrom.push_back(std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddExtendsFrom(const char* value) { m_extendsFromHasBeenSet = true; m_extendsFrom.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>An object that maps strings to the functions in the component type. Each
     * string in the mapping must be unique to this object.</p>
     */
    inline const Aws::Map<Aws::String, FunctionRequest>& GetFunctions() const{ return m_functions; }
    inline bool FunctionsHasBeenSet() const { return m_functionsHasBeenSet; }
    inline void SetFunctions(const Aws::Map<Aws::String, FunctionRequest>& value) { m_functionsHasBeenSet = true; m_functions = value; }
    inline void SetFunctions(Aws::Map<Aws::String, FunctionRequest>&& value) { m_functionsHasBeenSet = true; m_functions = std::move(value); }
    inline UpdateComponentTypeRequest& WithFunctions(const Aws::Map<Aws::String, FunctionRequest>& value) { SetFunctions(value); return *this;}
    inline UpdateComponentTypeRequest& WithFunctions(Aws::Map<Aws::String, FunctionRequest>&& value) { SetFunctions(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& AddFunctions(const Aws::String& key, const FunctionRequest& value) { m_functionsHasBeenSet = true; m_functions.emplace(key, value); return *this; }
    inline UpdateComponentTypeRequest& AddFunctions(Aws::String&& key, const FunctionRequest& value) { m_functionsHasBeenSet = true; m_functions.emplace(std::move(key), value); return *this; }
    inline UpdateComponentTypeRequest& AddFunctions(const Aws::String& key, FunctionRequest&& value) { m_functionsHasBeenSet = true; m_functions.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddFunctions(Aws::String&& key, FunctionRequest&& value) { m_functionsHasBeenSet = true; m_functions.emplace(std::move(key), std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddFunctions(const char* key, FunctionRequest&& value) { m_functionsHasBeenSet = true; m_functions.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddFunctions(const char* key, const FunctionRequest& value) { m_functionsHasBeenSet = true; m_functions.emplace(key, value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The property groups.</p>
     */
    inline const Aws::Map<Aws::String, PropertyGroupRequest>& GetPropertyGroups() const{ return m_propertyGroups; }
    inline bool PropertyGroupsHasBeenSet() const { return m_propertyGroupsHasBeenSet; }
    inline void SetPropertyGroups(const Aws::Map<Aws::String, PropertyGroupRequest>& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups = value; }
    inline void SetPropertyGroups(Aws::Map<Aws::String, PropertyGroupRequest>&& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups = std::move(value); }
    inline UpdateComponentTypeRequest& WithPropertyGroups(const Aws::Map<Aws::String, PropertyGroupRequest>& value) { SetPropertyGroups(value); return *this;}
    inline UpdateComponentTypeRequest& WithPropertyGroups(Aws::Map<Aws::String, PropertyGroupRequest>&& value) { SetPropertyGroups(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& AddPropertyGroups(const Aws::String& key, const PropertyGroupRequest& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups.emplace(key, value); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyGroups(Aws::String&& key, const PropertyGroupRequest& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups.emplace(std::move(key), value); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyGroups(const Aws::String& key, PropertyGroupRequest&& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyGroups(Aws::String&& key, PropertyGroupRequest&& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups.emplace(std::move(key), std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyGroups(const char* key, PropertyGroupRequest&& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddPropertyGroups(const char* key, const PropertyGroupRequest& value) { m_propertyGroupsHasBeenSet = true; m_propertyGroups.emplace(key, value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The component type name.</p>
     */
    inline const Aws::String& GetComponentTypeName() const{ return m_componentTypeName; }
    inline bool ComponentTypeNameHasBeenSet() const { return m_componentTypeNameHasBeenSet; }
    inline void SetComponentTypeName(const Aws::String& value) { m_componentTypeNameHasBeenSet = true; m_componentTypeName = value; }
    inline void SetComponentTypeName(Aws::String&& value) { m_componentTypeNameHasBeenSet = true; m_componentTypeName = std::move(value); }
    inline void SetComponentTypeName(const char* value) { m_componentTypeNameHasBeenSet = true; m_componentTypeName.assign(value); }
    inline UpdateComponentTypeRequest& WithComponentTypeName(const Aws::String& value) { SetComponentTypeName(value); return *this;}
    inline UpdateComponentTypeRequest& WithComponentTypeName(Aws::String&& value) { SetComponentTypeName(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& WithComponentTypeName(const char* value) { SetComponentTypeName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>This is an object that maps strings to <code>compositeComponentTypes</code>
     * of the <code>componentType</code>. <code>CompositeComponentType</code> is
     * referenced by <code>componentTypeId</code>.</p>
     */
    inline const Aws::Map<Aws::String, CompositeComponentTypeRequest>& GetCompositeComponentTypes() const{ return m_compositeComponentTypes; }
    inline bool CompositeComponentTypesHasBeenSet() const { return m_compositeComponentTypesHasBeenSet; }
    inline void SetCompositeComponentTypes(const Aws::Map<Aws::String, CompositeComponentTypeRequest>& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes = value; }
    inline void SetCompositeComponentTypes(Aws::Map<Aws::String, CompositeComponentTypeRequest>&& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes = std::move(value); }
    inline UpdateComponentTypeRequest& WithCompositeComponentTypes(const Aws::Map<Aws::String, CompositeComponentTypeRequest>& value) { SetCompositeComponentTypes(value); return *this;}
    inline UpdateComponentTypeRequest& WithCompositeComponentTypes(Aws::Map<Aws::String, CompositeComponentTypeRequest>&& value) { SetCompositeComponentTypes(std::move(value)); return *this;}
    inline UpdateComponentTypeRequest& AddCompositeComponentTypes(const Aws::String& key, const CompositeComponentTypeRequest& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes.emplace(key, value); return *this; }
    inline UpdateComponentTypeRequest& AddCompositeComponentTypes(Aws::String&& key, const CompositeComponentTypeRequest& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes.emplace(std::move(key), value); return *this; }
    inline UpdateComponentTypeRequest& AddCompositeComponentTypes(const Aws::String& key, CompositeComponentTypeRequest&& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddCompositeComponentTypes(Aws::String&& key, CompositeComponentTypeRequest&& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes.emplace(std::move(key), std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddCompositeComponentTypes(const char* key, CompositeComponentTypeRequest&& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes.emplace(key, std::move(value)); return *this; }
    inline UpdateComponentTypeRequest& AddCompositeComponentTypes(const char* key, const CompositeComponentTypeRequest& value) { m_compositeComponentTypesHasBeenSet = true; m_compositeComponentTypes.emplace(key, value); return *this; }
    ///@}
  private:

    Aws::String m_workspaceId;
    bool m_workspaceIdHasBeenSet = false;

    bool m_isSingleton;
    bool m_isSingletonHasBeenSet = false;

    Aws::String m_componentTypeId;
    bool m_componentTypeIdHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    Aws::Map<Aws::String, PropertyDefinitionRequest> m_propertyDefinitions;
    bool m_propertyDefinitionsHasBeenSet = false;

    Aws::Vector<Aws::String> m_extendsFrom;
    bool m_extendsFromHasBeenSet = false;

    Aws::Map<Aws::String, FunctionRequest> m_functions;
    bool m_functionsHasBeenSet = false;

    Aws::Map<Aws::String, PropertyGroupRequest> m_propertyGroups;
    bool m_propertyGroupsHasBeenSet = false;

    Aws::String m_componentTypeName;
    bool m_componentTypeNameHasBeenSet = false;

    Aws::Map<Aws::String, CompositeComponentTypeRequest> m_compositeComponentTypes;
    bool m_compositeComponentTypesHasBeenSet = false;
  };

} // namespace Model
} // namespace IoTTwinMaker
} // namespace Aws
