﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/model/BedrockKnowledgeStoreExactResponseFields.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace LexModelsV2
{
namespace Model
{

  /**
   * <p>Contains details about the configuration of a Amazon Bedrock knowledge
   * base.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BedrockKnowledgeStoreConfiguration">AWS
   * API Reference</a></p>
   */
  class BedrockKnowledgeStoreConfiguration
  {
  public:
    AWS_LEXMODELSV2_API BedrockKnowledgeStoreConfiguration();
    AWS_LEXMODELSV2_API BedrockKnowledgeStoreConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXMODELSV2_API BedrockKnowledgeStoreConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The base ARN of the knowledge base used.</p>
     */
    inline const Aws::String& GetBedrockKnowledgeBaseArn() const{ return m_bedrockKnowledgeBaseArn; }
    inline bool BedrockKnowledgeBaseArnHasBeenSet() const { return m_bedrockKnowledgeBaseArnHasBeenSet; }
    inline void SetBedrockKnowledgeBaseArn(const Aws::String& value) { m_bedrockKnowledgeBaseArnHasBeenSet = true; m_bedrockKnowledgeBaseArn = value; }
    inline void SetBedrockKnowledgeBaseArn(Aws::String&& value) { m_bedrockKnowledgeBaseArnHasBeenSet = true; m_bedrockKnowledgeBaseArn = std::move(value); }
    inline void SetBedrockKnowledgeBaseArn(const char* value) { m_bedrockKnowledgeBaseArnHasBeenSet = true; m_bedrockKnowledgeBaseArn.assign(value); }
    inline BedrockKnowledgeStoreConfiguration& WithBedrockKnowledgeBaseArn(const Aws::String& value) { SetBedrockKnowledgeBaseArn(value); return *this;}
    inline BedrockKnowledgeStoreConfiguration& WithBedrockKnowledgeBaseArn(Aws::String&& value) { SetBedrockKnowledgeBaseArn(std::move(value)); return *this;}
    inline BedrockKnowledgeStoreConfiguration& WithBedrockKnowledgeBaseArn(const char* value) { SetBedrockKnowledgeBaseArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Specifies whether to return an exact response, or to return an answer
     * generated by the model, using the fields you specify from the database.</p>
     */
    inline bool GetExactResponse() const{ return m_exactResponse; }
    inline bool ExactResponseHasBeenSet() const { return m_exactResponseHasBeenSet; }
    inline void SetExactResponse(bool value) { m_exactResponseHasBeenSet = true; m_exactResponse = value; }
    inline BedrockKnowledgeStoreConfiguration& WithExactResponse(bool value) { SetExactResponse(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains the names of the fields used for an exact response to the user.</p>
     */
    inline const BedrockKnowledgeStoreExactResponseFields& GetExactResponseFields() const{ return m_exactResponseFields; }
    inline bool ExactResponseFieldsHasBeenSet() const { return m_exactResponseFieldsHasBeenSet; }
    inline void SetExactResponseFields(const BedrockKnowledgeStoreExactResponseFields& value) { m_exactResponseFieldsHasBeenSet = true; m_exactResponseFields = value; }
    inline void SetExactResponseFields(BedrockKnowledgeStoreExactResponseFields&& value) { m_exactResponseFieldsHasBeenSet = true; m_exactResponseFields = std::move(value); }
    inline BedrockKnowledgeStoreConfiguration& WithExactResponseFields(const BedrockKnowledgeStoreExactResponseFields& value) { SetExactResponseFields(value); return *this;}
    inline BedrockKnowledgeStoreConfiguration& WithExactResponseFields(BedrockKnowledgeStoreExactResponseFields&& value) { SetExactResponseFields(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_bedrockKnowledgeBaseArn;
    bool m_bedrockKnowledgeBaseArnHasBeenSet = false;

    bool m_exactResponse;
    bool m_exactResponseHasBeenSet = false;

    BedrockKnowledgeStoreExactResponseFields m_exactResponseFields;
    bool m_exactResponseFieldsHasBeenSet = false;
  };

} // namespace Model
} // namespace LexModelsV2
} // namespace Aws
