﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lookoutequipment/LookoutEquipment_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lookoutequipment/model/ModelSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace LookoutEquipment
{
namespace Model
{
  class ListModelsResult
  {
  public:
    AWS_LOOKOUTEQUIPMENT_API ListModelsResult();
    AWS_LOOKOUTEQUIPMENT_API ListModelsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_LOOKOUTEQUIPMENT_API ListModelsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p> An opaque pagination token indicating where to continue the listing of
     * machine learning models. </p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListModelsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListModelsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListModelsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Provides information on the specified model, including created time, model
     * and dataset ARNs, and status. </p>
     */
    inline const Aws::Vector<ModelSummary>& GetModelSummaries() const{ return m_modelSummaries; }
    inline void SetModelSummaries(const Aws::Vector<ModelSummary>& value) { m_modelSummaries = value; }
    inline void SetModelSummaries(Aws::Vector<ModelSummary>&& value) { m_modelSummaries = std::move(value); }
    inline ListModelsResult& WithModelSummaries(const Aws::Vector<ModelSummary>& value) { SetModelSummaries(value); return *this;}
    inline ListModelsResult& WithModelSummaries(Aws::Vector<ModelSummary>&& value) { SetModelSummaries(std::move(value)); return *this;}
    inline ListModelsResult& AddModelSummaries(const ModelSummary& value) { m_modelSummaries.push_back(value); return *this; }
    inline ListModelsResult& AddModelSummaries(ModelSummary&& value) { m_modelSummaries.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListModelsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListModelsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListModelsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<ModelSummary> m_modelSummaries;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace LookoutEquipment
} // namespace Aws
