﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/mediatailor/MediaTailor_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediatailor/model/SourceLocation.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace MediaTailor
{
namespace Model
{
  class ListSourceLocationsResult
  {
  public:
    AWS_MEDIATAILOR_API ListSourceLocationsResult();
    AWS_MEDIATAILOR_API ListSourceLocationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_MEDIATAILOR_API ListSourceLocationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of source locations.</p>
     */
    inline const Aws::Vector<SourceLocation>& GetItems() const{ return m_items; }
    inline void SetItems(const Aws::Vector<SourceLocation>& value) { m_items = value; }
    inline void SetItems(Aws::Vector<SourceLocation>&& value) { m_items = std::move(value); }
    inline ListSourceLocationsResult& WithItems(const Aws::Vector<SourceLocation>& value) { SetItems(value); return *this;}
    inline ListSourceLocationsResult& WithItems(Aws::Vector<SourceLocation>&& value) { SetItems(std::move(value)); return *this;}
    inline ListSourceLocationsResult& AddItems(const SourceLocation& value) { m_items.push_back(value); return *this; }
    inline ListSourceLocationsResult& AddItems(SourceLocation&& value) { m_items.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Pagination token returned by the list request when results exceed the maximum
     * allowed. Use the token to fetch the next page of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListSourceLocationsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListSourceLocationsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListSourceLocationsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListSourceLocationsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListSourceLocationsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListSourceLocationsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<SourceLocation> m_items;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace MediaTailor
} // namespace Aws
