﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/omics/Omics_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/omics/model/VariantStoreItem.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Omics
{
namespace Model
{
  class ListVariantStoresResult
  {
  public:
    AWS_OMICS_API ListVariantStoresResult();
    AWS_OMICS_API ListVariantStoresResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_OMICS_API ListVariantStoresResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of variant stores.</p>
     */
    inline const Aws::Vector<VariantStoreItem>& GetVariantStores() const{ return m_variantStores; }
    inline void SetVariantStores(const Aws::Vector<VariantStoreItem>& value) { m_variantStores = value; }
    inline void SetVariantStores(Aws::Vector<VariantStoreItem>&& value) { m_variantStores = std::move(value); }
    inline ListVariantStoresResult& WithVariantStores(const Aws::Vector<VariantStoreItem>& value) { SetVariantStores(value); return *this;}
    inline ListVariantStoresResult& WithVariantStores(Aws::Vector<VariantStoreItem>&& value) { SetVariantStores(std::move(value)); return *this;}
    inline ListVariantStoresResult& AddVariantStores(const VariantStoreItem& value) { m_variantStores.push_back(value); return *this; }
    inline ListVariantStoresResult& AddVariantStores(VariantStoreItem&& value) { m_variantStores.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A pagination token that's included if more results are available.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListVariantStoresResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListVariantStoresResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListVariantStoresResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListVariantStoresResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListVariantStoresResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListVariantStoresResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<VariantStoreItem> m_variantStores;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Omics
} // namespace Aws
