﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/opsworks/OpsWorks_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/opsworks/model/OperatingSystemConfigurationManager.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace OpsWorks
{
namespace Model
{

  /**
   * <p>Describes supported operating systems in OpsWorks Stacks.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/OperatingSystem">AWS
   * API Reference</a></p>
   */
  class OperatingSystem
  {
  public:
    AWS_OPSWORKS_API OperatingSystem();
    AWS_OPSWORKS_API OperatingSystem(Aws::Utils::Json::JsonView jsonValue);
    AWS_OPSWORKS_API OperatingSystem& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_OPSWORKS_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The name of the operating system, such as <code>Amazon Linux 2</code>.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline OperatingSystem& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline OperatingSystem& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline OperatingSystem& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of a supported operating system, such as <code>Amazon Linux
     * 2</code>.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }
    inline OperatingSystem& WithId(const Aws::String& value) { SetId(value); return *this;}
    inline OperatingSystem& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}
    inline OperatingSystem& WithId(const char* value) { SetId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of a supported operating system, either <code>Linux</code> or
     * <code>Windows</code>.</p>
     */
    inline const Aws::String& GetType() const{ return m_type; }
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
    inline void SetType(const Aws::String& value) { m_typeHasBeenSet = true; m_type = value; }
    inline void SetType(Aws::String&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }
    inline void SetType(const char* value) { m_typeHasBeenSet = true; m_type.assign(value); }
    inline OperatingSystem& WithType(const Aws::String& value) { SetType(value); return *this;}
    inline OperatingSystem& WithType(Aws::String&& value) { SetType(std::move(value)); return *this;}
    inline OperatingSystem& WithType(const char* value) { SetType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Supported configuration manager name and versions for an OpsWorks Stacks
     * operating system.</p>
     */
    inline const Aws::Vector<OperatingSystemConfigurationManager>& GetConfigurationManagers() const{ return m_configurationManagers; }
    inline bool ConfigurationManagersHasBeenSet() const { return m_configurationManagersHasBeenSet; }
    inline void SetConfigurationManagers(const Aws::Vector<OperatingSystemConfigurationManager>& value) { m_configurationManagersHasBeenSet = true; m_configurationManagers = value; }
    inline void SetConfigurationManagers(Aws::Vector<OperatingSystemConfigurationManager>&& value) { m_configurationManagersHasBeenSet = true; m_configurationManagers = std::move(value); }
    inline OperatingSystem& WithConfigurationManagers(const Aws::Vector<OperatingSystemConfigurationManager>& value) { SetConfigurationManagers(value); return *this;}
    inline OperatingSystem& WithConfigurationManagers(Aws::Vector<OperatingSystemConfigurationManager>&& value) { SetConfigurationManagers(std::move(value)); return *this;}
    inline OperatingSystem& AddConfigurationManagers(const OperatingSystemConfigurationManager& value) { m_configurationManagersHasBeenSet = true; m_configurationManagers.push_back(value); return *this; }
    inline OperatingSystem& AddConfigurationManagers(OperatingSystemConfigurationManager&& value) { m_configurationManagersHasBeenSet = true; m_configurationManagers.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A short name for the operating system manufacturer.</p>
     */
    inline const Aws::String& GetReportedName() const{ return m_reportedName; }
    inline bool ReportedNameHasBeenSet() const { return m_reportedNameHasBeenSet; }
    inline void SetReportedName(const Aws::String& value) { m_reportedNameHasBeenSet = true; m_reportedName = value; }
    inline void SetReportedName(Aws::String&& value) { m_reportedNameHasBeenSet = true; m_reportedName = std::move(value); }
    inline void SetReportedName(const char* value) { m_reportedNameHasBeenSet = true; m_reportedName.assign(value); }
    inline OperatingSystem& WithReportedName(const Aws::String& value) { SetReportedName(value); return *this;}
    inline OperatingSystem& WithReportedName(Aws::String&& value) { SetReportedName(std::move(value)); return *this;}
    inline OperatingSystem& WithReportedName(const char* value) { SetReportedName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The version of the operating system, including the release and edition, if
     * applicable.</p>
     */
    inline const Aws::String& GetReportedVersion() const{ return m_reportedVersion; }
    inline bool ReportedVersionHasBeenSet() const { return m_reportedVersionHasBeenSet; }
    inline void SetReportedVersion(const Aws::String& value) { m_reportedVersionHasBeenSet = true; m_reportedVersion = value; }
    inline void SetReportedVersion(Aws::String&& value) { m_reportedVersionHasBeenSet = true; m_reportedVersion = std::move(value); }
    inline void SetReportedVersion(const char* value) { m_reportedVersionHasBeenSet = true; m_reportedVersion.assign(value); }
    inline OperatingSystem& WithReportedVersion(const Aws::String& value) { SetReportedVersion(value); return *this;}
    inline OperatingSystem& WithReportedVersion(Aws::String&& value) { SetReportedVersion(std::move(value)); return *this;}
    inline OperatingSystem& WithReportedVersion(const char* value) { SetReportedVersion(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates that an operating system is not supported for new instances.</p>
     */
    inline bool GetSupported() const{ return m_supported; }
    inline bool SupportedHasBeenSet() const { return m_supportedHasBeenSet; }
    inline void SetSupported(bool value) { m_supportedHasBeenSet = true; m_supported = value; }
    inline OperatingSystem& WithSupported(bool value) { SetSupported(value); return *this;}
    ///@}
  private:

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::String m_type;
    bool m_typeHasBeenSet = false;

    Aws::Vector<OperatingSystemConfigurationManager> m_configurationManagers;
    bool m_configurationManagersHasBeenSet = false;

    Aws::String m_reportedName;
    bool m_reportedNameHasBeenSet = false;

    Aws::String m_reportedVersion;
    bool m_reportedVersionHasBeenSet = false;

    bool m_supported;
    bool m_supportedHasBeenSet = false;
  };

} // namespace Model
} // namespace OpsWorks
} // namespace Aws
