﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationTypeDefinition.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace PinpointSMSVoiceV2
{
namespace Model
{
  class DescribeRegistrationTypeDefinitionsResult
  {
  public:
    AWS_PINPOINTSMSVOICEV2_API DescribeRegistrationTypeDefinitionsResult();
    AWS_PINPOINTSMSVOICEV2_API DescribeRegistrationTypeDefinitionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_PINPOINTSMSVOICEV2_API DescribeRegistrationTypeDefinitionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The type of registration form. The list of <b>RegistrationTypes</b> can be
     * found using the <a>DescribeRegistrationTypeDefinitions</a> action.</p>
     */
    inline const Aws::Vector<RegistrationTypeDefinition>& GetRegistrationTypeDefinitions() const{ return m_registrationTypeDefinitions; }
    inline void SetRegistrationTypeDefinitions(const Aws::Vector<RegistrationTypeDefinition>& value) { m_registrationTypeDefinitions = value; }
    inline void SetRegistrationTypeDefinitions(Aws::Vector<RegistrationTypeDefinition>&& value) { m_registrationTypeDefinitions = std::move(value); }
    inline DescribeRegistrationTypeDefinitionsResult& WithRegistrationTypeDefinitions(const Aws::Vector<RegistrationTypeDefinition>& value) { SetRegistrationTypeDefinitions(value); return *this;}
    inline DescribeRegistrationTypeDefinitionsResult& WithRegistrationTypeDefinitions(Aws::Vector<RegistrationTypeDefinition>&& value) { SetRegistrationTypeDefinitions(std::move(value)); return *this;}
    inline DescribeRegistrationTypeDefinitionsResult& AddRegistrationTypeDefinitions(const RegistrationTypeDefinition& value) { m_registrationTypeDefinitions.push_back(value); return *this; }
    inline DescribeRegistrationTypeDefinitionsResult& AddRegistrationTypeDefinitions(RegistrationTypeDefinition&& value) { m_registrationTypeDefinitions.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token to be used for the next set of paginated results. You don't need to
     * supply a value for this field in the initial request.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline DescribeRegistrationTypeDefinitionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline DescribeRegistrationTypeDefinitionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline DescribeRegistrationTypeDefinitionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DescribeRegistrationTypeDefinitionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DescribeRegistrationTypeDefinitionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DescribeRegistrationTypeDefinitionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<RegistrationTypeDefinition> m_registrationTypeDefinitions;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace PinpointSMSVoiceV2
} // namespace Aws
