﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/PinpointRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/model/WriteJourneyRequest.h>
#include <utility>

namespace Aws
{
namespace Pinpoint
{
namespace Model
{

  /**
   */
  class UpdateJourneyRequest : public PinpointRequest
  {
  public:
    AWS_PINPOINT_API UpdateJourneyRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateJourney"; }

    AWS_PINPOINT_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The unique identifier for the application. This identifier is displayed as
     * the <b>Project ID</b> on the Amazon Pinpoint console.</p>
     */
    inline const Aws::String& GetApplicationId() const{ return m_applicationId; }
    inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
    inline void SetApplicationId(const Aws::String& value) { m_applicationIdHasBeenSet = true; m_applicationId = value; }
    inline void SetApplicationId(Aws::String&& value) { m_applicationIdHasBeenSet = true; m_applicationId = std::move(value); }
    inline void SetApplicationId(const char* value) { m_applicationIdHasBeenSet = true; m_applicationId.assign(value); }
    inline UpdateJourneyRequest& WithApplicationId(const Aws::String& value) { SetApplicationId(value); return *this;}
    inline UpdateJourneyRequest& WithApplicationId(Aws::String&& value) { SetApplicationId(std::move(value)); return *this;}
    inline UpdateJourneyRequest& WithApplicationId(const char* value) { SetApplicationId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The unique identifier for the journey.</p>
     */
    inline const Aws::String& GetJourneyId() const{ return m_journeyId; }
    inline bool JourneyIdHasBeenSet() const { return m_journeyIdHasBeenSet; }
    inline void SetJourneyId(const Aws::String& value) { m_journeyIdHasBeenSet = true; m_journeyId = value; }
    inline void SetJourneyId(Aws::String&& value) { m_journeyIdHasBeenSet = true; m_journeyId = std::move(value); }
    inline void SetJourneyId(const char* value) { m_journeyIdHasBeenSet = true; m_journeyId.assign(value); }
    inline UpdateJourneyRequest& WithJourneyId(const Aws::String& value) { SetJourneyId(value); return *this;}
    inline UpdateJourneyRequest& WithJourneyId(Aws::String&& value) { SetJourneyId(std::move(value)); return *this;}
    inline UpdateJourneyRequest& WithJourneyId(const char* value) { SetJourneyId(value); return *this;}
    ///@}

    ///@{
    
    inline const WriteJourneyRequest& GetWriteJourneyRequest() const{ return m_writeJourneyRequest; }
    inline bool WriteJourneyRequestHasBeenSet() const { return m_writeJourneyRequestHasBeenSet; }
    inline void SetWriteJourneyRequest(const WriteJourneyRequest& value) { m_writeJourneyRequestHasBeenSet = true; m_writeJourneyRequest = value; }
    inline void SetWriteJourneyRequest(WriteJourneyRequest&& value) { m_writeJourneyRequestHasBeenSet = true; m_writeJourneyRequest = std::move(value); }
    inline UpdateJourneyRequest& WithWriteJourneyRequest(const WriteJourneyRequest& value) { SetWriteJourneyRequest(value); return *this;}
    inline UpdateJourneyRequest& WithWriteJourneyRequest(WriteJourneyRequest&& value) { SetWriteJourneyRequest(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_applicationId;
    bool m_applicationIdHasBeenSet = false;

    Aws::String m_journeyId;
    bool m_journeyIdHasBeenSet = false;

    WriteJourneyRequest m_writeJourneyRequest;
    bool m_writeJourneyRequestHasBeenSet = false;
  };

} // namespace Model
} // namespace Pinpoint
} // namespace Aws
