﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rds/RDS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rds/model/OptionGroupOptionSetting.h>
#include <aws/rds/model/OptionVersion.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace RDS
{
namespace Model
{

  /**
   * <p>Available option.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroupOption">AWS
   * API Reference</a></p>
   */
  class OptionGroupOption
  {
  public:
    AWS_RDS_API OptionGroupOption();
    AWS_RDS_API OptionGroupOption(const Aws::Utils::Xml::XmlNode& xmlNode);
    AWS_RDS_API OptionGroupOption& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    AWS_RDS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    AWS_RDS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;


    ///@{
    /**
     * <p>The name of the option.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline OptionGroupOption& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline OptionGroupOption& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline OptionGroupOption& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The description of the option.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }
    inline OptionGroupOption& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline OptionGroupOption& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline OptionGroupOption& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the engine that this option can be applied to.</p>
     */
    inline const Aws::String& GetEngineName() const{ return m_engineName; }
    inline bool EngineNameHasBeenSet() const { return m_engineNameHasBeenSet; }
    inline void SetEngineName(const Aws::String& value) { m_engineNameHasBeenSet = true; m_engineName = value; }
    inline void SetEngineName(Aws::String&& value) { m_engineNameHasBeenSet = true; m_engineName = std::move(value); }
    inline void SetEngineName(const char* value) { m_engineNameHasBeenSet = true; m_engineName.assign(value); }
    inline OptionGroupOption& WithEngineName(const Aws::String& value) { SetEngineName(value); return *this;}
    inline OptionGroupOption& WithEngineName(Aws::String&& value) { SetEngineName(std::move(value)); return *this;}
    inline OptionGroupOption& WithEngineName(const char* value) { SetEngineName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates the major engine version that the option is available for.</p>
     */
    inline const Aws::String& GetMajorEngineVersion() const{ return m_majorEngineVersion; }
    inline bool MajorEngineVersionHasBeenSet() const { return m_majorEngineVersionHasBeenSet; }
    inline void SetMajorEngineVersion(const Aws::String& value) { m_majorEngineVersionHasBeenSet = true; m_majorEngineVersion = value; }
    inline void SetMajorEngineVersion(Aws::String&& value) { m_majorEngineVersionHasBeenSet = true; m_majorEngineVersion = std::move(value); }
    inline void SetMajorEngineVersion(const char* value) { m_majorEngineVersionHasBeenSet = true; m_majorEngineVersion.assign(value); }
    inline OptionGroupOption& WithMajorEngineVersion(const Aws::String& value) { SetMajorEngineVersion(value); return *this;}
    inline OptionGroupOption& WithMajorEngineVersion(Aws::String&& value) { SetMajorEngineVersion(std::move(value)); return *this;}
    inline OptionGroupOption& WithMajorEngineVersion(const char* value) { SetMajorEngineVersion(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The minimum required engine version for the option to be applied.</p>
     */
    inline const Aws::String& GetMinimumRequiredMinorEngineVersion() const{ return m_minimumRequiredMinorEngineVersion; }
    inline bool MinimumRequiredMinorEngineVersionHasBeenSet() const { return m_minimumRequiredMinorEngineVersionHasBeenSet; }
    inline void SetMinimumRequiredMinorEngineVersion(const Aws::String& value) { m_minimumRequiredMinorEngineVersionHasBeenSet = true; m_minimumRequiredMinorEngineVersion = value; }
    inline void SetMinimumRequiredMinorEngineVersion(Aws::String&& value) { m_minimumRequiredMinorEngineVersionHasBeenSet = true; m_minimumRequiredMinorEngineVersion = std::move(value); }
    inline void SetMinimumRequiredMinorEngineVersion(const char* value) { m_minimumRequiredMinorEngineVersionHasBeenSet = true; m_minimumRequiredMinorEngineVersion.assign(value); }
    inline OptionGroupOption& WithMinimumRequiredMinorEngineVersion(const Aws::String& value) { SetMinimumRequiredMinorEngineVersion(value); return *this;}
    inline OptionGroupOption& WithMinimumRequiredMinorEngineVersion(Aws::String&& value) { SetMinimumRequiredMinorEngineVersion(std::move(value)); return *this;}
    inline OptionGroupOption& WithMinimumRequiredMinorEngineVersion(const char* value) { SetMinimumRequiredMinorEngineVersion(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates whether the option requires a port.</p>
     */
    inline bool GetPortRequired() const{ return m_portRequired; }
    inline bool PortRequiredHasBeenSet() const { return m_portRequiredHasBeenSet; }
    inline void SetPortRequired(bool value) { m_portRequiredHasBeenSet = true; m_portRequired = value; }
    inline OptionGroupOption& WithPortRequired(bool value) { SetPortRequired(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>If the option requires a port, specifies the default port for the option.</p>
     */
    inline int GetDefaultPort() const{ return m_defaultPort; }
    inline bool DefaultPortHasBeenSet() const { return m_defaultPortHasBeenSet; }
    inline void SetDefaultPort(int value) { m_defaultPortHasBeenSet = true; m_defaultPort = value; }
    inline OptionGroupOption& WithDefaultPort(int value) { SetDefaultPort(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The options that are prerequisites for this option.</p>
     */
    inline const Aws::Vector<Aws::String>& GetOptionsDependedOn() const{ return m_optionsDependedOn; }
    inline bool OptionsDependedOnHasBeenSet() const { return m_optionsDependedOnHasBeenSet; }
    inline void SetOptionsDependedOn(const Aws::Vector<Aws::String>& value) { m_optionsDependedOnHasBeenSet = true; m_optionsDependedOn = value; }
    inline void SetOptionsDependedOn(Aws::Vector<Aws::String>&& value) { m_optionsDependedOnHasBeenSet = true; m_optionsDependedOn = std::move(value); }
    inline OptionGroupOption& WithOptionsDependedOn(const Aws::Vector<Aws::String>& value) { SetOptionsDependedOn(value); return *this;}
    inline OptionGroupOption& WithOptionsDependedOn(Aws::Vector<Aws::String>&& value) { SetOptionsDependedOn(std::move(value)); return *this;}
    inline OptionGroupOption& AddOptionsDependedOn(const Aws::String& value) { m_optionsDependedOnHasBeenSet = true; m_optionsDependedOn.push_back(value); return *this; }
    inline OptionGroupOption& AddOptionsDependedOn(Aws::String&& value) { m_optionsDependedOnHasBeenSet = true; m_optionsDependedOn.push_back(std::move(value)); return *this; }
    inline OptionGroupOption& AddOptionsDependedOn(const char* value) { m_optionsDependedOnHasBeenSet = true; m_optionsDependedOn.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The options that conflict with this option.</p>
     */
    inline const Aws::Vector<Aws::String>& GetOptionsConflictsWith() const{ return m_optionsConflictsWith; }
    inline bool OptionsConflictsWithHasBeenSet() const { return m_optionsConflictsWithHasBeenSet; }
    inline void SetOptionsConflictsWith(const Aws::Vector<Aws::String>& value) { m_optionsConflictsWithHasBeenSet = true; m_optionsConflictsWith = value; }
    inline void SetOptionsConflictsWith(Aws::Vector<Aws::String>&& value) { m_optionsConflictsWithHasBeenSet = true; m_optionsConflictsWith = std::move(value); }
    inline OptionGroupOption& WithOptionsConflictsWith(const Aws::Vector<Aws::String>& value) { SetOptionsConflictsWith(value); return *this;}
    inline OptionGroupOption& WithOptionsConflictsWith(Aws::Vector<Aws::String>&& value) { SetOptionsConflictsWith(std::move(value)); return *this;}
    inline OptionGroupOption& AddOptionsConflictsWith(const Aws::String& value) { m_optionsConflictsWithHasBeenSet = true; m_optionsConflictsWith.push_back(value); return *this; }
    inline OptionGroupOption& AddOptionsConflictsWith(Aws::String&& value) { m_optionsConflictsWithHasBeenSet = true; m_optionsConflictsWith.push_back(std::move(value)); return *this; }
    inline OptionGroupOption& AddOptionsConflictsWith(const char* value) { m_optionsConflictsWithHasBeenSet = true; m_optionsConflictsWith.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>Persistent options can't be removed from an option group while DB instances
     * are associated with the option group. If you disassociate all DB instances from
     * the option group, your can remove the persistent option from the option
     * group.</p>
     */
    inline bool GetPersistent() const{ return m_persistent; }
    inline bool PersistentHasBeenSet() const { return m_persistentHasBeenSet; }
    inline void SetPersistent(bool value) { m_persistentHasBeenSet = true; m_persistent = value; }
    inline OptionGroupOption& WithPersistent(bool value) { SetPersistent(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Permanent options can never be removed from an option group. An option group
     * containing a permanent option can't be removed from a DB instance.</p>
     */
    inline bool GetPermanent() const{ return m_permanent; }
    inline bool PermanentHasBeenSet() const { return m_permanentHasBeenSet; }
    inline void SetPermanent(bool value) { m_permanentHasBeenSet = true; m_permanent = value; }
    inline OptionGroupOption& WithPermanent(bool value) { SetPermanent(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>If true, you must enable the Auto Minor Version Upgrade setting for your DB
     * instance before you can use this option. You can enable Auto Minor Version
     * Upgrade when you first create your DB instance, or by modifying your DB instance
     * later.</p>
     */
    inline bool GetRequiresAutoMinorEngineVersionUpgrade() const{ return m_requiresAutoMinorEngineVersionUpgrade; }
    inline bool RequiresAutoMinorEngineVersionUpgradeHasBeenSet() const { return m_requiresAutoMinorEngineVersionUpgradeHasBeenSet; }
    inline void SetRequiresAutoMinorEngineVersionUpgrade(bool value) { m_requiresAutoMinorEngineVersionUpgradeHasBeenSet = true; m_requiresAutoMinorEngineVersionUpgrade = value; }
    inline OptionGroupOption& WithRequiresAutoMinorEngineVersionUpgrade(bool value) { SetRequiresAutoMinorEngineVersionUpgrade(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>If true, you can only use this option with a DB instance that is in a
     * VPC.</p>
     */
    inline bool GetVpcOnly() const{ return m_vpcOnly; }
    inline bool VpcOnlyHasBeenSet() const { return m_vpcOnlyHasBeenSet; }
    inline void SetVpcOnly(bool value) { m_vpcOnlyHasBeenSet = true; m_vpcOnly = value; }
    inline OptionGroupOption& WithVpcOnly(bool value) { SetVpcOnly(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>If true, you can change the option to an earlier version of the option. This
     * only applies to options that have different versions available.</p>
     */
    inline bool GetSupportsOptionVersionDowngrade() const{ return m_supportsOptionVersionDowngrade; }
    inline bool SupportsOptionVersionDowngradeHasBeenSet() const { return m_supportsOptionVersionDowngradeHasBeenSet; }
    inline void SetSupportsOptionVersionDowngrade(bool value) { m_supportsOptionVersionDowngradeHasBeenSet = true; m_supportsOptionVersionDowngrade = value; }
    inline OptionGroupOption& WithSupportsOptionVersionDowngrade(bool value) { SetSupportsOptionVersionDowngrade(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The option settings that are available (and the default value) for each
     * option in an option group.</p>
     */
    inline const Aws::Vector<OptionGroupOptionSetting>& GetOptionGroupOptionSettings() const{ return m_optionGroupOptionSettings; }
    inline bool OptionGroupOptionSettingsHasBeenSet() const { return m_optionGroupOptionSettingsHasBeenSet; }
    inline void SetOptionGroupOptionSettings(const Aws::Vector<OptionGroupOptionSetting>& value) { m_optionGroupOptionSettingsHasBeenSet = true; m_optionGroupOptionSettings = value; }
    inline void SetOptionGroupOptionSettings(Aws::Vector<OptionGroupOptionSetting>&& value) { m_optionGroupOptionSettingsHasBeenSet = true; m_optionGroupOptionSettings = std::move(value); }
    inline OptionGroupOption& WithOptionGroupOptionSettings(const Aws::Vector<OptionGroupOptionSetting>& value) { SetOptionGroupOptionSettings(value); return *this;}
    inline OptionGroupOption& WithOptionGroupOptionSettings(Aws::Vector<OptionGroupOptionSetting>&& value) { SetOptionGroupOptionSettings(std::move(value)); return *this;}
    inline OptionGroupOption& AddOptionGroupOptionSettings(const OptionGroupOptionSetting& value) { m_optionGroupOptionSettingsHasBeenSet = true; m_optionGroupOptionSettings.push_back(value); return *this; }
    inline OptionGroupOption& AddOptionGroupOptionSettings(OptionGroupOptionSetting&& value) { m_optionGroupOptionSettingsHasBeenSet = true; m_optionGroupOptionSettings.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The versions that are available for the option.</p>
     */
    inline const Aws::Vector<OptionVersion>& GetOptionGroupOptionVersions() const{ return m_optionGroupOptionVersions; }
    inline bool OptionGroupOptionVersionsHasBeenSet() const { return m_optionGroupOptionVersionsHasBeenSet; }
    inline void SetOptionGroupOptionVersions(const Aws::Vector<OptionVersion>& value) { m_optionGroupOptionVersionsHasBeenSet = true; m_optionGroupOptionVersions = value; }
    inline void SetOptionGroupOptionVersions(Aws::Vector<OptionVersion>&& value) { m_optionGroupOptionVersionsHasBeenSet = true; m_optionGroupOptionVersions = std::move(value); }
    inline OptionGroupOption& WithOptionGroupOptionVersions(const Aws::Vector<OptionVersion>& value) { SetOptionGroupOptionVersions(value); return *this;}
    inline OptionGroupOption& WithOptionGroupOptionVersions(Aws::Vector<OptionVersion>&& value) { SetOptionGroupOptionVersions(std::move(value)); return *this;}
    inline OptionGroupOption& AddOptionGroupOptionVersions(const OptionVersion& value) { m_optionGroupOptionVersionsHasBeenSet = true; m_optionGroupOptionVersions.push_back(value); return *this; }
    inline OptionGroupOption& AddOptionGroupOptionVersions(OptionVersion&& value) { m_optionGroupOptionVersionsHasBeenSet = true; m_optionGroupOptionVersions.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Indicates whether the option can be copied across Amazon Web Services
     * accounts.</p>
     */
    inline bool GetCopyableCrossAccount() const{ return m_copyableCrossAccount; }
    inline bool CopyableCrossAccountHasBeenSet() const { return m_copyableCrossAccountHasBeenSet; }
    inline void SetCopyableCrossAccount(bool value) { m_copyableCrossAccountHasBeenSet = true; m_copyableCrossAccount = value; }
    inline OptionGroupOption& WithCopyableCrossAccount(bool value) { SetCopyableCrossAccount(value); return *this;}
    ///@}
  private:

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    Aws::String m_engineName;
    bool m_engineNameHasBeenSet = false;

    Aws::String m_majorEngineVersion;
    bool m_majorEngineVersionHasBeenSet = false;

    Aws::String m_minimumRequiredMinorEngineVersion;
    bool m_minimumRequiredMinorEngineVersionHasBeenSet = false;

    bool m_portRequired;
    bool m_portRequiredHasBeenSet = false;

    int m_defaultPort;
    bool m_defaultPortHasBeenSet = false;

    Aws::Vector<Aws::String> m_optionsDependedOn;
    bool m_optionsDependedOnHasBeenSet = false;

    Aws::Vector<Aws::String> m_optionsConflictsWith;
    bool m_optionsConflictsWithHasBeenSet = false;

    bool m_persistent;
    bool m_persistentHasBeenSet = false;

    bool m_permanent;
    bool m_permanentHasBeenSet = false;

    bool m_requiresAutoMinorEngineVersionUpgrade;
    bool m_requiresAutoMinorEngineVersionUpgradeHasBeenSet = false;

    bool m_vpcOnly;
    bool m_vpcOnlyHasBeenSet = false;

    bool m_supportsOptionVersionDowngrade;
    bool m_supportsOptionVersionDowngradeHasBeenSet = false;

    Aws::Vector<OptionGroupOptionSetting> m_optionGroupOptionSettings;
    bool m_optionGroupOptionSettingsHasBeenSet = false;

    Aws::Vector<OptionVersion> m_optionGroupOptionVersions;
    bool m_optionGroupOptionVersionsHasBeenSet = false;

    bool m_copyableCrossAccount;
    bool m_copyableCrossAccountHasBeenSet = false;
  };

} // namespace Model
} // namespace RDS
} // namespace Aws
