﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/resiliencehub/model/GroupingRecommendation.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ResilienceHub
{
namespace Model
{
  class ListResourceGroupingRecommendationsResult
  {
  public:
    AWS_RESILIENCEHUB_API ListResourceGroupingRecommendationsResult();
    AWS_RESILIENCEHUB_API ListResourceGroupingRecommendationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_RESILIENCEHUB_API ListResourceGroupingRecommendationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>List of resource grouping recommendations generated by Resilience Hub.</p>
     */
    inline const Aws::Vector<GroupingRecommendation>& GetGroupingRecommendations() const{ return m_groupingRecommendations; }
    inline void SetGroupingRecommendations(const Aws::Vector<GroupingRecommendation>& value) { m_groupingRecommendations = value; }
    inline void SetGroupingRecommendations(Aws::Vector<GroupingRecommendation>&& value) { m_groupingRecommendations = std::move(value); }
    inline ListResourceGroupingRecommendationsResult& WithGroupingRecommendations(const Aws::Vector<GroupingRecommendation>& value) { SetGroupingRecommendations(value); return *this;}
    inline ListResourceGroupingRecommendationsResult& WithGroupingRecommendations(Aws::Vector<GroupingRecommendation>&& value) { SetGroupingRecommendations(std::move(value)); return *this;}
    inline ListResourceGroupingRecommendationsResult& AddGroupingRecommendations(const GroupingRecommendation& value) { m_groupingRecommendations.push_back(value); return *this; }
    inline ListResourceGroupingRecommendationsResult& AddGroupingRecommendations(GroupingRecommendation&& value) { m_groupingRecommendations.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Null, or the token from a previous call to get the next set of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListResourceGroupingRecommendationsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListResourceGroupingRecommendationsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListResourceGroupingRecommendationsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListResourceGroupingRecommendationsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListResourceGroupingRecommendationsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListResourceGroupingRecommendationsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<GroupingRecommendation> m_groupingRecommendations;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace ResilienceHub
} // namespace Aws
