﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once

#include <aws/core/client/AWSError.h>
#include <aws/core/client/CoreErrors.h>
#include <aws/route53/Route53_EXPORTS.h>

namespace Aws
{
namespace Route53
{
enum class Route53Errors
{
  //From Core//
  //////////////////////////////////////////////////////////////////////////////////////////
  INCOMPLETE_SIGNATURE = 0,
  INTERNAL_FAILURE = 1,
  INVALID_ACTION = 2,
  INVALID_CLIENT_TOKEN_ID = 3,
  INVALID_PARAMETER_COMBINATION = 4,
  INVALID_QUERY_PARAMETER = 5,
  INVALID_PARAMETER_VALUE = 6,
  MISSING_ACTION = 7, // SDK should never allow
  MISSING_AUTHENTICATION_TOKEN = 8, // SDK should never allow
  MISSING_PARAMETER = 9, // SDK should never allow
  OPT_IN_REQUIRED = 10,
  REQUEST_EXPIRED = 11,
  SERVICE_UNAVAILABLE = 12,
  THROTTLING = 13,
  VALIDATION = 14,
  ACCESS_DENIED = 15,
  RESOURCE_NOT_FOUND = 16,
  UNRECOGNIZED_CLIENT = 17,
  MALFORMED_QUERY_STRING = 18,
  SLOW_DOWN = 19,
  REQUEST_TIME_TOO_SKEWED = 20,
  INVALID_SIGNATURE = 21,
  SIGNATURE_DOES_NOT_MATCH = 22,
  INVALID_ACCESS_KEY_ID = 23,
  REQUEST_TIMEOUT = 24,
  NETWORK_CONNECTION = 99,

  UNKNOWN = 100,
  ///////////////////////////////////////////////////////////////////////////////////////////

  CIDR_BLOCK_IN_USE= static_cast<int>(Aws::Client::CoreErrors::SERVICE_EXTENSION_START_RANGE) + 1,
  CIDR_COLLECTION_ALREADY_EXISTS,
  CIDR_COLLECTION_IN_USE,
  CIDR_COLLECTION_VERSION_MISMATCH,
  CONCURRENT_MODIFICATION,
  CONFLICTING_DOMAIN_EXISTS,
  CONFLICTING_TYPES,
  DELEGATION_SET_ALREADY_CREATED,
  DELEGATION_SET_ALREADY_REUSABLE,
  DELEGATION_SET_IN_USE,
  DELEGATION_SET_NOT_AVAILABLE,
  DELEGATION_SET_NOT_REUSABLE,
  D_N_S_S_E_C_NOT_FOUND,
  HEALTH_CHECK_ALREADY_EXISTS,
  HEALTH_CHECK_IN_USE,
  HEALTH_CHECK_VERSION_MISMATCH,
  HOSTED_ZONE_ALREADY_EXISTS,
  HOSTED_ZONE_NOT_EMPTY,
  HOSTED_ZONE_NOT_FOUND,
  HOSTED_ZONE_NOT_PRIVATE,
  HOSTED_ZONE_PARTIALLY_DELEGATED,
  INCOMPATIBLE_VERSION,
  INSUFFICIENT_CLOUD_WATCH_LOGS_RESOURCE_POLICY,
  INVALID_ARGUMENT,
  INVALID_CHANGE_BATCH,
  INVALID_DOMAIN_NAME,
  INVALID_INPUT,
  INVALID_KEY_SIGNING_KEY_NAME,
  INVALID_KEY_SIGNING_KEY_STATUS,
  INVALID_K_M_S_ARN,
  INVALID_PAGINATION_TOKEN,
  INVALID_SIGNING_STATUS,
  INVALID_TRAFFIC_POLICY_DOCUMENT,
  INVALID_V_P_C_ID,
  KEY_SIGNING_KEY_ALREADY_EXISTS,
  KEY_SIGNING_KEY_IN_PARENT_D_S_RECORD,
  KEY_SIGNING_KEY_IN_USE,
  KEY_SIGNING_KEY_WITH_ACTIVE_STATUS_NOT_FOUND,
  LAST_V_P_C_ASSOCIATION,
  LIMITS_EXCEEDED,
  NOT_AUTHORIZED,
  NO_SUCH_CHANGE,
  NO_SUCH_CIDR_COLLECTION,
  NO_SUCH_CIDR_LOCATION,
  NO_SUCH_CLOUD_WATCH_LOGS_LOG_GROUP,
  NO_SUCH_DELEGATION_SET,
  NO_SUCH_GEO_LOCATION,
  NO_SUCH_HEALTH_CHECK,
  NO_SUCH_HOSTED_ZONE,
  NO_SUCH_KEY_SIGNING_KEY,
  NO_SUCH_QUERY_LOGGING_CONFIG,
  NO_SUCH_TRAFFIC_POLICY,
  NO_SUCH_TRAFFIC_POLICY_INSTANCE,
  PRIOR_REQUEST_NOT_COMPLETE,
  PUBLIC_ZONE_V_P_C_ASSOCIATION,
  QUERY_LOGGING_CONFIG_ALREADY_EXISTS,
  TOO_MANY_HEALTH_CHECKS,
  TOO_MANY_HOSTED_ZONES,
  TOO_MANY_KEY_SIGNING_KEYS,
  TOO_MANY_TRAFFIC_POLICIES,
  TOO_MANY_TRAFFIC_POLICY_INSTANCES,
  TOO_MANY_TRAFFIC_POLICY_VERSIONS_FOR_CURRENT_POLICY,
  TOO_MANY_V_P_C_ASSOCIATION_AUTHORIZATIONS,
  TRAFFIC_POLICY_ALREADY_EXISTS,
  TRAFFIC_POLICY_INSTANCE_ALREADY_EXISTS,
  TRAFFIC_POLICY_IN_USE,
  V_P_C_ASSOCIATION_AUTHORIZATION_NOT_FOUND,
  V_P_C_ASSOCIATION_NOT_FOUND
};

class AWS_ROUTE53_API Route53Error : public Aws::Client::AWSError<Route53Errors>
{
public:
  Route53Error() {}
  Route53Error(const Aws::Client::AWSError<Aws::Client::CoreErrors>& rhs) : Aws::Client::AWSError<Route53Errors>(rhs) {}
  Route53Error(Aws::Client::AWSError<Aws::Client::CoreErrors>&& rhs) : Aws::Client::AWSError<Route53Errors>(rhs) {}
  Route53Error(const Aws::Client::AWSError<Route53Errors>& rhs) : Aws::Client::AWSError<Route53Errors>(rhs) {}
  Route53Error(Aws::Client::AWSError<Route53Errors>&& rhs) : Aws::Client::AWSError<Route53Errors>(rhs) {}

  template <typename T>
  T GetModeledError();
};

namespace Route53ErrorMapper
{
  AWS_ROUTE53_API Aws::Client::AWSError<Aws::Client::CoreErrors> GetErrorForName(const char* errorName);
}

} // namespace Route53
} // namespace Aws
