﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/model/MalwareType.h>
#include <aws/securityhub/model/MalwareState.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A list of malware related to a finding.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Malware">AWS
   * API Reference</a></p>
   */
  class Malware
  {
  public:
    AWS_SECURITYHUB_API Malware();
    AWS_SECURITYHUB_API Malware(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Malware& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The name of the malware that was observed.</p> <p>Length Constraints: Minimum
     * of 1. Maximum of 64.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline Malware& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline Malware& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline Malware& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline const MalwareType& GetType() const{ return m_type; }
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
    inline void SetType(const MalwareType& value) { m_typeHasBeenSet = true; m_type = value; }
    inline void SetType(MalwareType&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }
    inline Malware& WithType(const MalwareType& value) { SetType(value); return *this;}
    inline Malware& WithType(MalwareType&& value) { SetType(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The file system path of the malware that was observed.</p> <p>Length
     * Constraints: Minimum of 1. Maximum of 512.</p>
     */
    inline const Aws::String& GetPath() const{ return m_path; }
    inline bool PathHasBeenSet() const { return m_pathHasBeenSet; }
    inline void SetPath(const Aws::String& value) { m_pathHasBeenSet = true; m_path = value; }
    inline void SetPath(Aws::String&& value) { m_pathHasBeenSet = true; m_path = std::move(value); }
    inline void SetPath(const char* value) { m_pathHasBeenSet = true; m_path.assign(value); }
    inline Malware& WithPath(const Aws::String& value) { SetPath(value); return *this;}
    inline Malware& WithPath(Aws::String&& value) { SetPath(std::move(value)); return *this;}
    inline Malware& WithPath(const char* value) { SetPath(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline const MalwareState& GetState() const{ return m_state; }
    inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
    inline void SetState(const MalwareState& value) { m_stateHasBeenSet = true; m_state = value; }
    inline void SetState(MalwareState&& value) { m_stateHasBeenSet = true; m_state = std::move(value); }
    inline Malware& WithState(const MalwareState& value) { SetState(value); return *this;}
    inline Malware& WithState(MalwareState&& value) { SetState(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    MalwareType m_type;
    bool m_typeHasBeenSet = false;

    Aws::String m_path;
    bool m_pathHasBeenSet = false;

    MalwareState m_state;
    bool m_stateHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
