﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A vendor that generates a vulnerability report.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/VulnerabilityVendor">AWS
   * API Reference</a></p>
   */
  class VulnerabilityVendor
  {
  public:
    AWS_SECURITYHUB_API VulnerabilityVendor();
    AWS_SECURITYHUB_API VulnerabilityVendor(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API VulnerabilityVendor& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The name of the vendor.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline VulnerabilityVendor& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline VulnerabilityVendor& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline VulnerabilityVendor& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline const Aws::String& GetUrl() const{ return m_url; }
    inline bool UrlHasBeenSet() const { return m_urlHasBeenSet; }
    inline void SetUrl(const Aws::String& value) { m_urlHasBeenSet = true; m_url = value; }
    inline void SetUrl(Aws::String&& value) { m_urlHasBeenSet = true; m_url = std::move(value); }
    inline void SetUrl(const char* value) { m_urlHasBeenSet = true; m_url.assign(value); }
    inline VulnerabilityVendor& WithUrl(const Aws::String& value) { SetUrl(value); return *this;}
    inline VulnerabilityVendor& WithUrl(Aws::String&& value) { SetUrl(std::move(value)); return *this;}
    inline VulnerabilityVendor& WithUrl(const char* value) { SetUrl(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline const Aws::String& GetVendorSeverity() const{ return m_vendorSeverity; }
    inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }
    inline void SetVendorSeverity(const Aws::String& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = value; }
    inline void SetVendorSeverity(Aws::String&& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = std::move(value); }
    inline void SetVendorSeverity(const char* value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity.assign(value); }
    inline VulnerabilityVendor& WithVendorSeverity(const Aws::String& value) { SetVendorSeverity(value); return *this;}
    inline VulnerabilityVendor& WithVendorSeverity(Aws::String&& value) { SetVendorSeverity(std::move(value)); return *this;}
    inline VulnerabilityVendor& WithVendorSeverity(const char* value) { SetVendorSeverity(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>For more
     * information about the validation and formatting of timestamp fields in Security
     * Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
     */
    inline const Aws::String& GetVendorCreatedAt() const{ return m_vendorCreatedAt; }
    inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }
    inline void SetVendorCreatedAt(const Aws::String& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = value; }
    inline void SetVendorCreatedAt(Aws::String&& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = std::move(value); }
    inline void SetVendorCreatedAt(const char* value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt.assign(value); }
    inline VulnerabilityVendor& WithVendorCreatedAt(const Aws::String& value) { SetVendorCreatedAt(value); return *this;}
    inline VulnerabilityVendor& WithVendorCreatedAt(Aws::String&& value) { SetVendorCreatedAt(std::move(value)); return *this;}
    inline VulnerabilityVendor& WithVendorCreatedAt(const char* value) { SetVendorCreatedAt(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>For more
     * information about the validation and formatting of timestamp fields in Security
     * Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
     */
    inline const Aws::String& GetVendorUpdatedAt() const{ return m_vendorUpdatedAt; }
    inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }
    inline void SetVendorUpdatedAt(const Aws::String& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = value; }
    inline void SetVendorUpdatedAt(Aws::String&& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = std::move(value); }
    inline void SetVendorUpdatedAt(const char* value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt.assign(value); }
    inline VulnerabilityVendor& WithVendorUpdatedAt(const Aws::String& value) { SetVendorUpdatedAt(value); return *this;}
    inline VulnerabilityVendor& WithVendorUpdatedAt(Aws::String&& value) { SetVendorUpdatedAt(std::move(value)); return *this;}
    inline VulnerabilityVendor& WithVendorUpdatedAt(const char* value) { SetVendorUpdatedAt(value); return *this;}
    ///@}
  private:

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    Aws::String m_url;
    bool m_urlHasBeenSet = false;

    Aws::String m_vendorSeverity;
    bool m_vendorSeverityHasBeenSet = false;

    Aws::String m_vendorCreatedAt;
    bool m_vendorCreatedAtHasBeenSet = false;

    Aws::String m_vendorUpdatedAt;
    bool m_vendorUpdatedAtHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
