﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/model/WorkflowExecution.h>
#include <aws/swf/model/WorkflowType.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/swf/model/HistoryEvent.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SWF
{
namespace Model
{
  /**
   * <p>A structure that represents a decision task. Decision tasks are sent to
   * deciders in order for them to make decisions.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/DecisionTask">AWS
   * API Reference</a></p>
   */
  class PollForDecisionTaskResult
  {
  public:
    AWS_SWF_API PollForDecisionTaskResult();
    AWS_SWF_API PollForDecisionTaskResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SWF_API PollForDecisionTaskResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The opaque string used as a handle on the task. This token is used by workers
     * to communicate progress and response information back to the system about the
     * task.</p>
     */
    inline const Aws::String& GetTaskToken() const{ return m_taskToken; }
    inline void SetTaskToken(const Aws::String& value) { m_taskToken = value; }
    inline void SetTaskToken(Aws::String&& value) { m_taskToken = std::move(value); }
    inline void SetTaskToken(const char* value) { m_taskToken.assign(value); }
    inline PollForDecisionTaskResult& WithTaskToken(const Aws::String& value) { SetTaskToken(value); return *this;}
    inline PollForDecisionTaskResult& WithTaskToken(Aws::String&& value) { SetTaskToken(std::move(value)); return *this;}
    inline PollForDecisionTaskResult& WithTaskToken(const char* value) { SetTaskToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the <code>DecisionTaskStarted</code> event recorded in the
     * history.</p>
     */
    inline long long GetStartedEventId() const{ return m_startedEventId; }
    inline void SetStartedEventId(long long value) { m_startedEventId = value; }
    inline PollForDecisionTaskResult& WithStartedEventId(long long value) { SetStartedEventId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The workflow execution for which this decision task was created.</p>
     */
    inline const WorkflowExecution& GetWorkflowExecution() const{ return m_workflowExecution; }
    inline void SetWorkflowExecution(const WorkflowExecution& value) { m_workflowExecution = value; }
    inline void SetWorkflowExecution(WorkflowExecution&& value) { m_workflowExecution = std::move(value); }
    inline PollForDecisionTaskResult& WithWorkflowExecution(const WorkflowExecution& value) { SetWorkflowExecution(value); return *this;}
    inline PollForDecisionTaskResult& WithWorkflowExecution(WorkflowExecution&& value) { SetWorkflowExecution(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of the workflow execution for which this decision task was
     * created.</p>
     */
    inline const WorkflowType& GetWorkflowType() const{ return m_workflowType; }
    inline void SetWorkflowType(const WorkflowType& value) { m_workflowType = value; }
    inline void SetWorkflowType(WorkflowType&& value) { m_workflowType = std::move(value); }
    inline PollForDecisionTaskResult& WithWorkflowType(const WorkflowType& value) { SetWorkflowType(value); return *this;}
    inline PollForDecisionTaskResult& WithWorkflowType(WorkflowType&& value) { SetWorkflowType(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A paginated list of history events of the workflow execution. The decider
     * uses this during the processing of the decision task.</p>
     */
    inline const Aws::Vector<HistoryEvent>& GetEvents() const{ return m_events; }
    inline void SetEvents(const Aws::Vector<HistoryEvent>& value) { m_events = value; }
    inline void SetEvents(Aws::Vector<HistoryEvent>&& value) { m_events = std::move(value); }
    inline PollForDecisionTaskResult& WithEvents(const Aws::Vector<HistoryEvent>& value) { SetEvents(value); return *this;}
    inline PollForDecisionTaskResult& WithEvents(Aws::Vector<HistoryEvent>&& value) { SetEvents(std::move(value)); return *this;}
    inline PollForDecisionTaskResult& AddEvents(const HistoryEvent& value) { m_events.push_back(value); return *this; }
    inline PollForDecisionTaskResult& AddEvents(HistoryEvent&& value) { m_events.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>If a <code>NextPageToken</code> was returned by a previous call, there are
     * more results available. To retrieve the next page of results, make the call
     * again using the returned token in <code>nextPageToken</code>. Keep all other
     * arguments unchanged.</p> <p>The configured <code>maximumPageSize</code>
     * determines how many results can be returned in a single call.</p>
     */
    inline const Aws::String& GetNextPageToken() const{ return m_nextPageToken; }
    inline void SetNextPageToken(const Aws::String& value) { m_nextPageToken = value; }
    inline void SetNextPageToken(Aws::String&& value) { m_nextPageToken = std::move(value); }
    inline void SetNextPageToken(const char* value) { m_nextPageToken.assign(value); }
    inline PollForDecisionTaskResult& WithNextPageToken(const Aws::String& value) { SetNextPageToken(value); return *this;}
    inline PollForDecisionTaskResult& WithNextPageToken(Aws::String&& value) { SetNextPageToken(std::move(value)); return *this;}
    inline PollForDecisionTaskResult& WithNextPageToken(const char* value) { SetNextPageToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the DecisionTaskStarted event of the previous decision task of this
     * workflow execution that was processed by the decider. This can be used to
     * determine the events in the history new since the last decision task received by
     * the decider.</p>
     */
    inline long long GetPreviousStartedEventId() const{ return m_previousStartedEventId; }
    inline void SetPreviousStartedEventId(long long value) { m_previousStartedEventId = value; }
    inline PollForDecisionTaskResult& WithPreviousStartedEventId(long long value) { SetPreviousStartedEventId(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline PollForDecisionTaskResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline PollForDecisionTaskResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline PollForDecisionTaskResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_taskToken;

    long long m_startedEventId;

    WorkflowExecution m_workflowExecution;

    WorkflowType m_workflowType;

    Aws::Vector<HistoryEvent> m_events;

    Aws::String m_nextPageToken;

    long long m_previousStartedEventId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SWF
} // namespace Aws
