﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/timestream-query/TimestreamQuery_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/timestream-query/model/ScheduledQuery.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace TimestreamQuery
{
namespace Model
{
  class ListScheduledQueriesResult
  {
  public:
    AWS_TIMESTREAMQUERY_API ListScheduledQueriesResult();
    AWS_TIMESTREAMQUERY_API ListScheduledQueriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_TIMESTREAMQUERY_API ListScheduledQueriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of scheduled queries.</p>
     */
    inline const Aws::Vector<ScheduledQuery>& GetScheduledQueries() const{ return m_scheduledQueries; }
    inline void SetScheduledQueries(const Aws::Vector<ScheduledQuery>& value) { m_scheduledQueries = value; }
    inline void SetScheduledQueries(Aws::Vector<ScheduledQuery>&& value) { m_scheduledQueries = std::move(value); }
    inline ListScheduledQueriesResult& WithScheduledQueries(const Aws::Vector<ScheduledQuery>& value) { SetScheduledQueries(value); return *this;}
    inline ListScheduledQueriesResult& WithScheduledQueries(Aws::Vector<ScheduledQuery>&& value) { SetScheduledQueries(std::move(value)); return *this;}
    inline ListScheduledQueriesResult& AddScheduledQueries(const ScheduledQuery& value) { m_scheduledQueries.push_back(value); return *this; }
    inline ListScheduledQueriesResult& AddScheduledQueries(ScheduledQuery&& value) { m_scheduledQueries.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token to specify where to start paginating. This is the NextToken from a
     * previously truncated response.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListScheduledQueriesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListScheduledQueriesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListScheduledQueriesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListScheduledQueriesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListScheduledQueriesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListScheduledQueriesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<ScheduledQuery> m_scheduledQueries;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace TimestreamQuery
} // namespace Aws
