﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/translate/Translate_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/translate/model/TextTranslationJobProperties.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Translate
{
namespace Model
{
  class ListTextTranslationJobsResult
  {
  public:
    AWS_TRANSLATE_API ListTextTranslationJobsResult();
    AWS_TRANSLATE_API ListTextTranslationJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_TRANSLATE_API ListTextTranslationJobsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list containing the properties of each job that is returned.</p>
     */
    inline const Aws::Vector<TextTranslationJobProperties>& GetTextTranslationJobPropertiesList() const{ return m_textTranslationJobPropertiesList; }
    inline void SetTextTranslationJobPropertiesList(const Aws::Vector<TextTranslationJobProperties>& value) { m_textTranslationJobPropertiesList = value; }
    inline void SetTextTranslationJobPropertiesList(Aws::Vector<TextTranslationJobProperties>&& value) { m_textTranslationJobPropertiesList = std::move(value); }
    inline ListTextTranslationJobsResult& WithTextTranslationJobPropertiesList(const Aws::Vector<TextTranslationJobProperties>& value) { SetTextTranslationJobPropertiesList(value); return *this;}
    inline ListTextTranslationJobsResult& WithTextTranslationJobPropertiesList(Aws::Vector<TextTranslationJobProperties>&& value) { SetTextTranslationJobPropertiesList(std::move(value)); return *this;}
    inline ListTextTranslationJobsResult& AddTextTranslationJobPropertiesList(const TextTranslationJobProperties& value) { m_textTranslationJobPropertiesList.push_back(value); return *this; }
    inline ListTextTranslationJobsResult& AddTextTranslationJobPropertiesList(TextTranslationJobProperties&& value) { m_textTranslationJobPropertiesList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token to use to retrieve the next page of results. This value is
     * <code>null</code> when there are no more results to return.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListTextTranslationJobsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListTextTranslationJobsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListTextTranslationJobsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListTextTranslationJobsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListTextTranslationJobsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListTextTranslationJobsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<TextTranslationJobProperties> m_textTranslationJobPropertiesList;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Translate
} // namespace Aws
