﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/waf-regional/WAFRegional_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/waf-regional/model/GeoMatchSetSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace WAFRegional
{
namespace Model
{
  class ListGeoMatchSetsResult
  {
  public:
    AWS_WAFREGIONAL_API ListGeoMatchSetsResult();
    AWS_WAFREGIONAL_API ListGeoMatchSetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_WAFREGIONAL_API ListGeoMatchSetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>If you have more <code>GeoMatchSet</code> objects than the number that you
     * specified for <code>Limit</code> in the request, the response includes a
     * <code>NextMarker</code> value. To list more <code>GeoMatchSet</code> objects,
     * submit another <code>ListGeoMatchSets</code> request, and specify the
     * <code>NextMarker</code> value from the response in the <code>NextMarker</code>
     * value in the next request.</p>
     */
    inline const Aws::String& GetNextMarker() const{ return m_nextMarker; }
    inline void SetNextMarker(const Aws::String& value) { m_nextMarker = value; }
    inline void SetNextMarker(Aws::String&& value) { m_nextMarker = std::move(value); }
    inline void SetNextMarker(const char* value) { m_nextMarker.assign(value); }
    inline ListGeoMatchSetsResult& WithNextMarker(const Aws::String& value) { SetNextMarker(value); return *this;}
    inline ListGeoMatchSetsResult& WithNextMarker(Aws::String&& value) { SetNextMarker(std::move(value)); return *this;}
    inline ListGeoMatchSetsResult& WithNextMarker(const char* value) { SetNextMarker(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>An array of <a>GeoMatchSetSummary</a> objects.</p>
     */
    inline const Aws::Vector<GeoMatchSetSummary>& GetGeoMatchSets() const{ return m_geoMatchSets; }
    inline void SetGeoMatchSets(const Aws::Vector<GeoMatchSetSummary>& value) { m_geoMatchSets = value; }
    inline void SetGeoMatchSets(Aws::Vector<GeoMatchSetSummary>&& value) { m_geoMatchSets = std::move(value); }
    inline ListGeoMatchSetsResult& WithGeoMatchSets(const Aws::Vector<GeoMatchSetSummary>& value) { SetGeoMatchSets(value); return *this;}
    inline ListGeoMatchSetsResult& WithGeoMatchSets(Aws::Vector<GeoMatchSetSummary>&& value) { SetGeoMatchSets(std::move(value)); return *this;}
    inline ListGeoMatchSetsResult& AddGeoMatchSets(const GeoMatchSetSummary& value) { m_geoMatchSets.push_back(value); return *this; }
    inline ListGeoMatchSetsResult& AddGeoMatchSets(GeoMatchSetSummary&& value) { m_geoMatchSets.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListGeoMatchSetsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListGeoMatchSetsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListGeoMatchSetsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextMarker;

    Aws::Vector<GeoMatchSetSummary> m_geoMatchSets;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace WAFRegional
} // namespace Aws
