#ifndef BASICS_H
#define BASICS_H

#ifndef WIN32
#include <stdint.h>
#endif
#include <string>
#include <vector>
#include <array>
using std::string;

#ifndef BITS

#define BITS

#define BIT1 1
#define BIT2 2
#define BIT3 4
#define BIT4 8
#define BIT5 16
#define BIT6 32
#define BIT7 64
#define BIT8 128
#define BIT9 256
#define BIT10 512
#define BIT11 1024
#define BIT12 2048
#define BIT13 4096
#define BIT14 8192
#define BIT15 16384
#define BIT16 32768
#define BIT17 65536UL
#define BIT18 131072UL
#define BIT19 262144UL
#define BIT20 524288UL
#define BIT21 1048576UL
#define BIT22 2097152UL
#define BIT23 4194304UL
#define BIT24 8388608UL
#define BIT25 16777216UL
#define BIT26 33554432UL
#define BIT27 67108864UL
#define BIT28 134217728UL
#define BIT29 268435456UL
#define BIT30 536870912UL
#define BIT31 1073741824UL
#define BIT32 2147483648UL
#define BIT33 4294967296ULL
#define BIT34 8589934592ULL
#define BIT35 17179869184ULL
#define BIT36 34359738368ULL
#define BIT37 68719476736ULL
#define BIT38 137438953472ULL
#define BIT39 274877906944ULL
#define BIT40 549755813888ULL
#define BIT41 1099511627776ULL
#define BIT42 2199023255552ULL
#define BIT43 4398046511104ULL
#define BIT44 8796093022208ULL
#define BIT45 17592186044416ULL
#define BIT46 35184372088832ULL
#define BIT47 70368744177664ULL
#define BIT48 140737488355328ULL
#define BIT49 281474976710656ULL
#define BIT50 562949953421312ULL
#define BIT51 1125899906842624ULL
#define BIT52 2251799813685248ULL
#define BIT53 4503599627370496ULL
#define BIT54 9007199254740992ULL
#define BIT55 18014398509481984ULL
#define BIT56 36028797018963968ULL
#define BIT57 72057594037927936ULL
#define BIT58 144115188075855872ULL
#define BIT59 288230376151711744ULL
#define BIT60 576460752303423488ULL
#define BIT61 1152921504606846976ULL
#define BIT62 2305843009213693952ULL
#define BIT63 4611686018427387904ULL
#define BIT64 9223372036854775808ULL
#endif

void emit_logs();
void gamelog_string(const string &str);
void errorlog_string(const string &str);
void errorlog_string(const char *ptr);

bool grab_token_string(string &dest,string &source,char compc=':');
bool grab_token_string(string &dest,string &source,int32_t &pos,char compc=':');
bool grab_token_string_pos(string &dest,string &source,int32_t pos,char compc=':');
void replace_token_string(string &token,string &str,int32_t pos,char compc,string &nw,char repc);
bool grab_token_list_as_string(string &dest,string &source,int32_t &pos,char compc=':');
bool grab_token_expression(string &dest,string &source,int32_t &pos,char compc=':');
char grab_variable_token(string &str,string &token,char sec_comp,int32_t &pos,int32_t i_pos);

int32_t convert_string_to_long(const string &str);
uint32_t convert_string_to_ulong(const string &str);
uint64_t convert_string_to_ulong64(const string &str);
void add_long_to_string(int32_t n,string &str);
void add_ulong64_to_string(uint64_t n,string &str);
void convert_long_to_string(int32_t n,string &str);
void convert_ulong_to_string(uint32_t n,string &str);
void convert_ulong64_to_string(uint64_t n,string &str);

void lower_case_string(string &str);
void upper_case_string(string &str);
void simplify_string(string &str);
string simplified_string(string str);
void capitalize_string_words(string &str);
void capitalize_string_first_word(string &str);
void abbreviate_string(string &str,int32_t len);
void separate_string(const string &str,std::vector<string> &separated,int32_t len);
void truncate_string(string &str,int32_t len);

void get_number(int32_t number,string &str);
void get_ordinal(int32_t number,string &str,bool shorten);

enum GameMode
{
	GAMEMODE_DWARF,
	GAMEMODE_ADVENTURE,
	GAMEMODENUM,
	GAMEMODE_NONE
};

enum GameType
{
	GAMETYPE_DWARF_MAIN,
	GAMETYPE_ADVENTURE_MAIN,
	GAMETYPE_VIEW_LEGENDS,
	GAMETYPE_DWARF_RECLAIM,
	GAMETYPE_DWARF_ARENA,
	GAMETYPE_ADVENTURE_ARENA,
	GAMETYPE_ADVENTURE_DUNGEON,
	GAMETYPE_DWARF_TUTORIAL,
	GAMETYPE_DWARF_UNRETIRE,
	GAMETYPE_ADVENTURE_WORLD_DEBUG,
	GAMETYPENUM,
	GAMETYPE_NONE
};

enum AnnouncementType
{
	ANNOUNCEMENT_REACHED_PEAK,
	ANNOUNCEMENT_ERA_CHANGE,
	ANNOUNCEMENT_FEATURE_DISCOVERY,
	ANNOUNCEMENT_STRUCK_DEEP_METAL,
	ANNOUNCEMENT_STRUCK_MINERAL,
	ANNOUNCEMENT_STRUCK_ECONOMIC_MINERAL,
	ANNOUNCEMENT_COMBAT_TWIST_WEAPON,
	ANNOUNCEMENT_COMBAT_LET_ITEM_DROP,
	ANNOUNCEMENT_COMBAT_START_CHARGE,
	ANNOUNCEMENT_COMBAT_SURPRISE_CHARGE,
	ANNOUNCEMENT_COMBAT_JUMP_DODGE_PROJ,
	ANNOUNCEMENT_COMBAT_JUMP_DODGE_STRIKE,
	ANNOUNCEMENT_COMBAT_DODGE,
	ANNOUNCEMENT_COMBAT_COUNTERSTRIKE,
	ANNOUNCEMENT_COMBAT_BLOCK,
	ANNOUNCEMENT_COMBAT_PARRY,
	ANNOUNCEMENT_COMBAT_CHARGE_COLLISION,
	ANNOUNCEMENT_COMBAT_CHARGE_DEFENDER_TUMBLES,
	ANNOUNCEMENT_COMBAT_CHARGE_DEFENDER_KNOCKED_OVER,
	ANNOUNCEMENT_COMBAT_CHARGE_ATTACKER_TUMBLES,
	ANNOUNCEMENT_COMBAT_CHARGE_ATTACKER_BOUNCE_BACK,
	ANNOUNCEMENT_COMBAT_CHARGE_TANGLE_TOGETHER,
	ANNOUNCEMENT_COMBAT_CHARGE_TANGLE_TUMBLE,
	ANNOUNCEMENT_COMBAT_CHARGE_RUSH_BY,
	ANNOUNCEMENT_COMBAT_CHARGE_MANAGE_STOP,
	ANNOUNCEMENT_COMBAT_CHARGE_OBSTACLE_SLAM,
	ANNOUNCEMENT_COMBAT_WRESTLE_LOCK,
	ANNOUNCEMENT_COMBAT_WRESTLE_CHOKEHOLD,
	ANNOUNCEMENT_COMBAT_WRESTLE_TAKEDOWN,
	ANNOUNCEMENT_COMBAT_WRESTLE_THROW,
	ANNOUNCEMENT_COMBAT_WRESTLE_RELEASE_LOCK,
	ANNOUNCEMENT_COMBAT_WRESTLE_RELEASE_CHOKE,
	ANNOUNCEMENT_COMBAT_WRESTLE_RELEASE_GRIP,
	ANNOUNCEMENT_COMBAT_WRESTLE_STRUGGLE,
	ANNOUNCEMENT_COMBAT_WRESTLE_RELEASE_LATCH,
	ANNOUNCEMENT_COMBAT_WRESTLE_STRANGLE_KO,
	ANNOUNCEMENT_COMBAT_WRESTLE_ADJUST_GRIP,
	ANNOUNCEMENT_COMBAT_GRAB_TEAR,
	ANNOUNCEMENT_COMBAT_STRIKE_DETAILS,
	ANNOUNCEMENT_COMBAT_STRIKE_DETAILS_2,
	ANNOUNCEMENT_COMBAT_EVENT_ENRAGED,
	ANNOUNCEMENT_COMBAT_EVENT_STUCKIN,
	ANNOUNCEMENT_COMBAT_EVENT_LATCH_BP,
	ANNOUNCEMENT_COMBAT_EVENT_LATCH_GENERAL,
	ANNOUNCEMENT_COMBAT_EVENT_PROPELLED_AWAY,
	ANNOUNCEMENT_COMBAT_EVENT_KNOCKED_OUT,
	ANNOUNCEMENT_COMBAT_EVENT_STUNNED,
	ANNOUNCEMENT_COMBAT_EVENT_WINDED,
	ANNOUNCEMENT_COMBAT_EVENT_NAUSEATED,
	ANNOUNCEMENT_MIGRANT_ARRIVAL_NAMED,
	ANNOUNCEMENT_MIGRANT_ARRIVAL,
	ANNOUNCEMENT_DIG_CANCEL_WARM,
	ANNOUNCEMENT_DIG_CANCEL_DAMP,
	ANNOUNCEMENT_AMBUSH_DEFENDER,
	ANNOUNCEMENT_AMBUSH_RESIDENT,
	ANNOUNCEMENT_AMBUSH_THIEF,
	ANNOUNCEMENT_AMBUSH_THIEF_SUPPORT_SKULKING,
	ANNOUNCEMENT_AMBUSH_THIEF_SUPPORT_NATURE,
	ANNOUNCEMENT_AMBUSH_THIEF_SUPPORT,
	ANNOUNCEMENT_AMBUSH_MISCHIEVOUS,
	ANNOUNCEMENT_AMBUSH_SNATCHER,
	ANNOUNCEMENT_AMBUSH_SNATCHER_SUPPORT,
	ANNOUNCEMENT_AMBUSH_AMBUSHER_NATURE,
	ANNOUNCEMENT_AMBUSH_AMBUSHER,
	ANNOUNCEMENT_AMBUSH_INJURED,
	ANNOUNCEMENT_AMBUSH_OTHER,
	ANNOUNCEMENT_AMBUSH_INCAPACITATED,
	ANNOUNCEMENT_CARAVAN_ARRIVAL,
	ANNOUNCEMENT_NOBLE_ARRIVAL,
	ANNOUNCEMENT_D_MIGRANTS_ARRIVAL,
	ANNOUNCEMENT_D_MIGRANT_ARRIVAL,
	ANNOUNCEMENT_D_MIGRANT_ARRIVAL_DISCOURAGED,
	ANNOUNCEMENT_D_NO_MIGRANT_ARRIVAL,
	ANNOUNCEMENT_ANIMAL_TRAP_CATCH,
	ANNOUNCEMENT_ANIMAL_TRAP_ROBBED,
	ANNOUNCEMENT_MISCHIEF_LEVER,
	ANNOUNCEMENT_MISCHIEF_PLATE,
	ANNOUNCEMENT_MISCHIEF_CAGE,
	ANNOUNCEMENT_MISCHIEF_CHAIN,
	ANNOUNCEMENT_DIPLOMAT_ARRIVAL,
	ANNOUNCEMENT_LIAISON_ARRIVAL,
	ANNOUNCEMENT_TRADE_DIPLOMAT_ARRIVAL,
	ANNOUNCEMENT_CAVE_COLLAPSE,
	ANNOUNCEMENT_BIRTH_CITIZEN,
	ANNOUNCEMENT_BIRTH_ANIMAL,
	ANNOUNCEMENT_STRANGE_MOOD,
	ANNOUNCEMENT_MADE_ARTIFACT,
	ANNOUNCEMENT_NAMED_ARTIFACT,
	ANNOUNCEMENT_ITEM_ATTACHMENT,
	ANNOUNCEMENT_VERMIN_CAGE_ESCAPE,
	ANNOUNCEMENT_TRIGGER_WEB,
	ANNOUNCEMENT_MOOD_BUILDING_CLAIMED,
	ANNOUNCEMENT_ARTIFACT_BEGUN,
	ANNOUNCEMENT_MEGABEAST_ARRIVAL,
	ANNOUNCEMENT_WEREBEAST_ARRIVAL,
	ANNOUNCEMENT_BEAST_AMBUSH,
	ANNOUNCEMENT_BERSERK_CITIZEN,
	ANNOUNCEMENT_MAGMA_DEFACES_ENGRAVING,
	ANNOUNCEMENT_ENGRAVING_MELTS,
	ANNOUNCEMENT_MASTERPIECE_CONSTRUCTION,
	ANNOUNCEMENT_MASTER_ARCHITECTURE_LOST,
	ANNOUNCEMENT_MASTER_CONSTRUCTION_LOST,
	ANNOUNCEMENT_ADV_AWAKEN,
	ANNOUNCEMENT_ADV_SLEEP_INTERRUPTED,
	ANNOUNCEMENT_CANCEL_JOB,
	ANNOUNCEMENT_ADV_CREATURE_DEATH,
	ANNOUNCEMENT_CITIZEN_DEATH,
	ANNOUNCEMENT_PET_DEATH,
	ANNOUNCEMENT_ENDGAME_EVENT_1,
	ANNOUNCEMENT_ENDGAME_EVENT_1B,
	ANNOUNCEMENT_ENDGAME_EVENT_2,
	ANNOUNCEMENT_FALL_OVER,
	ANNOUNCEMENT_CAUGHT_IN_FLAMES,
	ANNOUNCEMENT_CAUGHT_IN_WEB,
	ANNOUNCEMENT_UNIT_PROJECTILE_SLAM_BLOW_APART,
	ANNOUNCEMENT_UNIT_PROJECTILE_SLAM,
	ANNOUNCEMENT_UNIT_PROJECTILE_SLAM_INTO_UNIT,
	ANNOUNCEMENT_VOMIT,
	ANNOUNCEMENT_LOSE_HOLD_OF_ITEM,
	ANNOUNCEMENT_REGAIN_CONSCIOUSNESS,
	ANNOUNCEMENT_FREE_FROM_WEB,
	ANNOUNCEMENT_PARALYZED,
	ANNOUNCEMENT_OVERCOME_PARALYSIS,
	ANNOUNCEMENT_NOT_STUNNED,
	ANNOUNCEMENT_EXHAUSTION,
	ANNOUNCEMENT_PAIN_KO,
	ANNOUNCEMENT_BREAK_GRIP,
	ANNOUNCEMENT_NO_BREAK_GRIP,
	ANNOUNCEMENT_BLOCK_FIRE,
	ANNOUNCEMENT_BREATHE_FIRE,
	ANNOUNCEMENT_SHOOT_WEB,
	ANNOUNCEMENT_PULL_OUT_DROP,
	ANNOUNCEMENT_STAND_UP,
	ANNOUNCEMENT_MARTIAL_TRANCE,
	ANNOUNCEMENT_MAT_BREATH,
	ANNOUNCEMENT_ADV_REACTION_PRODUCTS,
	ANNOUNCEMENT_NIGHT_ATTACK_STARTS,
	ANNOUNCEMENT_NIGHT_ATTACK_ENDS,
	ANNOUNCEMENT_NIGHT_ATTACK_TRAVEL,
	ANNOUNCEMENT_GHOST_ATTACK,
	ANNOUNCEMENT_FLAME_HIT,
	ANNOUNCEMENT_TRAVEL_SITE_DISCOVERY,
	ANNOUNCEMENT_TRAVEL_SITE_BUMP,
	ANNOUNCEMENT_ADVENTURE_INTRO,
	ANNOUNCEMENT_CREATURE_SOUND,
	ANNOUNCEMENT_CREATURE_STEALS_OBJECT,
	ANNOUNCEMENT_FOUND_TRAP,
	ANNOUNCEMENT_BODY_TRANSFORMATION,
	ANNOUNCEMENT_INTERACTION_ACTOR,
	ANNOUNCEMENT_INTERACTION_TARGET,
	ANNOUNCEMENT_UNDEAD_ATTACK,
	ANNOUNCEMENT_CITIZEN_MISSING,
	ANNOUNCEMENT_PET_MISSING,
	ANNOUNCEMENT_EMBRACE,
	ANNOUNCEMENT_STRANGE_RAIN_SNOW,
	ANNOUNCEMENT_STRANGE_CLOUD,
	ANNOUNCEMENT_SIMPLE_ANIMAL_ACTION,
	ANNOUNCEMENT_FLOUNDER_IN_LIQUID,
	ANNOUNCEMENT_TRAINING_DOWN_TO_SEMI_WILD,
	ANNOUNCEMENT_TRAINING_FULL_REVERSION,
	ANNOUNCEMENT_ANIMAL_TRAINING_KNOWLEDGE,
	ANNOUNCEMENT_SKIP_ON_LIQUID,
	ANNOUNCEMENT_DODGE_FLYING_OBJECT,
	ANNOUNCEMENT_REGULAR_CONVERSATION,
	ANNOUNCEMENT_BANDIT_EMPTY_CONTAINER,
	ANNOUNCEMENT_BANDIT_GRAB_ITEM,
	ANNOUNCEMENT_COMBAT_EVENT_ATTACK_INTERRUPTED,
	ANNOUNCEMENT_COMBAT_WRESTLE_CATCH_ATTACK,
	ANNOUNCEMENT_FAIL_TO_GRAB_SURFACE,
	ANNOUNCEMENT_LOSE_HOLD_OF_SURFACE,
	ANNOUNCEMENT_TRAVEL_COMPLAINT,
	ANNOUNCEMENT_LOSE_EMOTION,
	ANNOUNCEMENT_REORGANIZE_POSSESSIONS,
	ANNOUNCEMENT_PUSH_ITEM,
	ANNOUNCEMENT_DRAW_ITEM,
	ANNOUNCEMENT_STRAP_ITEM,
	ANNOUNCEMENT_GAIN_SITE_CONTROL,
	ANNOUNCEMENT_CONFLICT_CONVERSATION,
	ANNOUNCEMENT_FORT_POSITION_SUCCESSION,
	ANNOUNCEMENT_MECHANISM_SOUND,
	ANNOUNCEMENT_BIRTH_WILD_ANIMAL,
	ANNOUNCEMENT_STRESSED_CITIZEN,
	ANNOUNCEMENT_CITIZEN_LOST_TO_STRESS,
	ANNOUNCEMENT_CITIZEN_TANTRUM,
	ANNOUNCEMENT_MOVED_OUT_OF_RANGE,
	ANNOUNCEMENT_CANNOT_JUMP,
	ANNOUNCEMENT_NO_TRACKS,
	ANNOUNCEMENT_ALREADY_SEARCHED_AREA,
	ANNOUNCEMENT_SEARCH_FOUND_SOMETHING,
	ANNOUNCEMENT_SEARCH_FOUND_NOTHING,
	ANNOUNCEMENT_NOTHING_TO_INTERACT,
	ANNOUNCEMENT_NOTHING_TO_EXAMINE,
	ANNOUNCEMENT_YOU_YIELDED,
	ANNOUNCEMENT_YOU_UNYIELDED,
	ANNOUNCEMENT_YOU_STRAP_ITEM,
	ANNOUNCEMENT_YOU_DRAW_ITEM,
	ANNOUNCEMENT_NO_GRASP_TO_DRAW_ITEM,
	ANNOUNCEMENT_NO_ITEM_TO_STRAP,
	ANNOUNCEMENT_NO_INV_TO_REMOVE,
	ANNOUNCEMENT_NO_INV_TO_WEAR,
	ANNOUNCEMENT_NO_INV_TO_EAT,
	ANNOUNCEMENT_NO_INV_TO_CONTAIN,
	ANNOUNCEMENT_NO_INV_TO_DROP,
	ANNOUNCEMENT_NOTHING_TO_PICK_UP,
	ANNOUNCEMENT_NO_INV_TO_THROW,
	ANNOUNCEMENT_NO_INV_TO_FIRE,
	ANNOUNCEMENT_CURRENT_SMELL,
	ANNOUNCEMENT_CURRENT_WEATHER,
	ANNOUNCEMENT_CURRENT_TEMPERATURE,
	ANNOUNCEMENT_CURRENT_DATE,
	ANNOUNCEMENT_NO_GRASP_FOR_PICKUP,
	ANNOUNCEMENT_CANNOT_CHOP_TREE,
	ANNOUNCEMENT_CANNOT_CLIMB,
	ANNOUNCEMENT_CANNOT_STAND,
	ANNOUNCEMENT_MUST_UNRETRACT_FIRST,
	ANNOUNCEMENT_CANNOT_REST,
	ANNOUNCEMENT_CANNOT_MAKE_CAMPFIRE,
	ANNOUNCEMENT_MADE_CAMPFIRE,
	ANNOUNCEMENT_CANNOT_SET_FIRE,
	ANNOUNCEMENT_SET_FIRE,
	ANNOUNCEMENT_DAWN_BREAKS,
	ANNOUNCEMENT_NOON,
	ANNOUNCEMENT_NIGHTFALL,
	ANNOUNCEMENT_NO_INV_INTERACTION,
	ANNOUNCEMENT_EMPTY_CONTAINER,
	ANNOUNCEMENT_TAKE_OUT_OF_CONTAINER,
	ANNOUNCEMENT_NO_CONTAINER_FOR_ITEM,
	ANNOUNCEMENT_PUT_INTO_CONTAINER,
	ANNOUNCEMENT_EAT_ITEM,
	ANNOUNCEMENT_DRINK_ITEM,
	ANNOUNCEMENT_CONSUME_FAILURE,
	ANNOUNCEMENT_DROP_ITEM,
	ANNOUNCEMENT_PICK_UP_ITEM,
	ANNOUNCEMENT_YOU_BUILDING_INTERACTION,
	ANNOUNCEMENT_YOU_ITEM_INTERACTION,
	ANNOUNCEMENT_YOU_TEMPERATURE_EFFECTS,
	ANNOUNCEMENT_PROFESSION_CHANGES,
	ANNOUNCEMENT_RECRUIT_PROMOTED,
	ANNOUNCEMENT_SOLDIER_BECOMES_MASTER,
	ANNOUNCEMENT_RESOLVE_SHARED_ITEMS,
	ANNOUNCEMENT_COUGH_BLOOD,
	ANNOUNCEMENT_VOMIT_BLOOD,
	ANNOUNCEMENT_MERCHANTS_UNLOADING,
	ANNOUNCEMENT_MERCHANTS_NEED_DEPOT,
	ANNOUNCEMENT_MERCHANT_WAGONS_BYPASSED,
	ANNOUNCEMENT_MERCHANTS_LEAVING_SOON,
	ANNOUNCEMENT_MERCHANTS_EMBARKED,
	ANNOUNCEMENT_PET_LOSES_DEAD_OWNER,
	ANNOUNCEMENT_PET_ADOPTS_OWNER,
	ANNOUNCEMENT_VERMIN_BITE,
	ANNOUNCEMENT_UNABLE_TO_COMPLETE_BUILDING,
	ANNOUNCEMENT_JOBS_REMOVED_FROM_UNPOWERED_BUILDING,
	ANNOUNCEMENT_CITIZEN_SNATCHED,
	ANNOUNCEMENT_VERMIN_DISTURBED,
	ANNOUNCEMENT_LAND_GAINS_STATUS,
	ANNOUNCEMENT_LAND_ELEVATED_STATUS,
	ANNOUNCEMENT_MASTERPIECE_CRAFTED,
	ANNOUNCEMENT_ARTWORK_DEFACED,
	ANNOUNCEMENT_POWER_LEARNED,
	ANNOUNCEMENT_YOU_FEED_ON_SUCKEE,
	ANNOUNCEMENT_ANIMAL_TRAINED,
	ANNOUNCEMENT_DYED_MASTERPIECE,
	ANNOUNCEMENT_COOKED_MASTERPIECE,
	ANNOUNCEMENT_MANDATE_ENDS,
	ANNOUNCEMENT_SLOWDOWN_ENDS,
	ANNOUNCEMENT_FAREWELL_HELPER,
	ANNOUNCEMENT_ELECTION_RESULTS,
	ANNOUNCEMENT_SITE_PRESENT,
	ANNOUNCEMENT_CONSTRUCTION_SUSPENDED,
	ANNOUNCEMENT_LINKAGE_SUSPENDED,
	ANNOUNCEMENT_QUOTA_FILLED,
	ANNOUNCEMENT_JOB_OVERWRITTEN,
	ANNOUNCEMENT_NOTHING_TO_CATCH_IN_WATER,
	ANNOUNCEMENT_DEMAND_FORGOTTEN,
	ANNOUNCEMENT_NEW_DEMAND,
	ANNOUNCEMENT_NEW_MANDATE,
	ANNOUNCEMENT_PRICES_ALTERED,
	ANNOUNCEMENT_NAMED_RESIDENT_CREATURE,
	ANNOUNCEMENT_SOMEBODY_GROWS_UP,
	ANNOUNCEMENT_GUILD_REQUEST_TAKEN,
	ANNOUNCEMENT_GUILD_WAGES_CHANGED,
	ANNOUNCEMENT_NEW_WORK_MANDATE,
	ANNOUNCEMENT_CITIZEN_BECOMES_SOLDIER,
	ANNOUNCEMENT_CITIZEN_BECOMES_NONSOLDIER,
	ANNOUNCEMENT_PARTY_ORGANIZED,
	ANNOUNCEMENT_POSSESSED_TANTRUM,
	ANNOUNCEMENT_BUILDING_TOPPLED_BY_GHOST,
	ANNOUNCEMENT_MASTERFUL_IMPROVEMENT,
	ANNOUNCEMENT_MASTERPIECE_ENGRAVING,
	ANNOUNCEMENT_MARRIAGE,
	ANNOUNCEMENT_NO_MARRIAGE_CELEBRATION,
	ANNOUNCEMENT_CURIOUS_GUZZLER,
	ANNOUNCEMENT_WEATHER_BECOMES_CLEAR,
	ANNOUNCEMENT_WEATHER_BECOMES_SNOW,
	ANNOUNCEMENT_WEATHER_BECOMES_RAIN,
	ANNOUNCEMENT_SEASON_WET,
	ANNOUNCEMENT_SEASON_DRY,
	ANNOUNCEMENT_SEASON_SPRING,
	ANNOUNCEMENT_SEASON_SUMMER,
	ANNOUNCEMENT_SEASON_AUTUMN,
	ANNOUNCEMENT_SEASON_WINTER,
	ANNOUNCEMENT_GUEST_ARRIVAL,
	ANNOUNCEMENT_CANNOT_SPEAK,
	ANNOUNCEMENT_RESEARCH_BREAKTHROUGH,
	ANNOUNCEMENT_SERVICE_ORDER_DELIVERY,
	ANNOUNCEMENT_PERFORMANCE_START_FAILURE,
	ANNOUNCEMENT_BEGIN_ACTIVITY,
	ANNOUNCEMENT_MIDDLE_OF_ACTIVITY,
	ANNOUNCEMENT_ACTIVITY_SECTION_CHANGE,
	ANNOUNCEMENT_CONCLUDE_ACTIVITY,
	ANNOUNCEMENT_LEARNED_WRITTEN_CONTENT,
	ANNOUNCEMENT_LEARNED_ART_FORM,
	ANNOUNCEMENT_PERFORMER_UPDATE,
	ANNOUNCEMENT_BUILDING_DESTROYED_OR_TOPPLED,
	ANNOUNCEMENT_DEITY_CURSE,
	ANNOUNCEMENT_COMPOSITION_COMPLETE,
	ANNOUNCEMENT_COMPOSITION_FAILED,
	ANNOUNCEMENT_NEW_APPRENTICESHIP,
	ANNOUNCEMENT_PETITION_IGNORED,
	ANNOUNCEMENT_CHOP_TREE,
	ANNOUNCEMENT_CANNOT_CONSTRUCT,
	ANNOUNCEMENT_RUMOR_SPREAD,
	ANNOUNCEMENT_AMBUSH_HERO,
	ANNOUNCEMENT_SERVICE_ORDER_RUMOR_RECEIVED,
	ANNOUNCEMENT_RETURNING_RUMOR_RECEIVED,
	ANNOUNCEMENT_NEW_HOLDING,
	ANNOUNCEMENT_NEW_MARKET_LINK,
	ANNOUNCEMENT_EMERGENCY_TACTICAL_CONTROL,
	ANNOUNCEMENT_AGREEMENT_SATISFIED,
	ANNOUNCEMENT_AGREEMENT_WARNING,
	ANNOUNCEMENT_AGREEMENT_ABANDONED,
	ANNOUNCEMENT_NEW_GUILD,
	ANNOUNCEMENT_CRIME_WITNESS_HANDOFF,
	ANNOUNCEMENT_CRIME_WITNESS_STOLEN,
	ANNOUNCEMENT_CRIME_WITNESS_ITEM_MOVED,
	ANNOUNCEMENT_CRIME_WITNESS_ITEM_MISSING,
	ANNOUNCEMENT_MOUNT,
	ANNOUNCEMENT_CANNOT_MOUNT,
	ANNOUNCEMENT_FAILED_MOUNT,
	ANNOUNCEMENT_DISMOUNT,
	ANNOUNCEMENT_FAILED_DISMOUNT,
	ANNOUNCEMENT_DIPLOMAT_LEFT_UNHAPPY,
	ANNOUNCEMENT_EMBARK_MESSAGE,
	ANNOUNCEMENT_FIRST_CARAVAN_ARRIVAL,
	ANNOUNCEMENT_MONARCH_ARRIVAL,
	ANNOUNCEMENT_HASTY_MONARCH,
	ANNOUNCEMENT_SATISFIED_MONARCH,
	ANNOUNCEMENT_MOUNTAINHOME,
	ANNOUNCEMENT_FOOD_WARNING,
	ANNOUNCEMENT_UNUSED_46,
	ANNOUNCEMENT_UNUSED_47,
	ANNOUNCEMENT_UNUSED_48,
	ANNOUNCEMENT_UNUSED_49,
	ANNOUNCEMENT_UNUSED_50,
	ANNOUNCEMENTNUM,//no save compat trouble from changing it
	ANNOUNCEMENT_NONE=-1
};
typedef int16_t Announcement;

enum AnnouncementAlertType
{
	ANNOUNCEMENT_ALERT_GENERAL,
	ANNOUNCEMENT_ALERT_ERA_CHANGE,
	ANNOUNCEMENT_ALERT_UNDERGROUND,
	ANNOUNCEMENT_ALERT_MIGRANT,
	ANNOUNCEMENT_ALERT_MONSTER,
	ANNOUNCEMENT_ALERT_AMBUSH,
	ANNOUNCEMENT_ALERT_TRADE,
	ANNOUNCEMENT_ALERT_NOBLE,
	ANNOUNCEMENT_ALERT_ANIMAL,
	ANNOUNCEMENT_ALERT_BIRTH,
	ANNOUNCEMENT_ALERT_MOOD,
	ANNOUNCEMENT_ALERT_LABOR_CHANGE,
	ANNOUNCEMENT_ALERT_MILITARY,
	ANNOUNCEMENT_ALERT_MARRIAGE,
	ANNOUNCEMENT_ALERT_BERSERK,
	ANNOUNCEMENT_ALERT_MARTIAL_TRANCE,
	ANNOUNCEMENT_ALERT_LOSE_EMOTION,
	ANNOUNCEMENT_ALERT_STRESS,
	ANNOUNCEMENT_ALERT_ART_DEFACEMENT,
	ANNOUNCEMENT_ALERT_MASTERPIECE,
	ANNOUNCEMENT_ALERT_JOB_FAILED,
	ANNOUNCEMENT_ALERT_DEATH,
	ANNOUNCEMENT_ALERT_GHOST,
	ANNOUNCEMENT_ALERT_UNDEAD_ATTACK,
	ANNOUNCEMENT_ALERT_WEATHER,
	ANNOUNCEMENT_ALERT_VERMIN,
	ANNOUNCEMENT_ALERT_CURIOUS_GUZZLER,
	ANNOUNCEMENT_ALERT_RESEARCH_BREAKTHROUGH,
	ANNOUNCEMENT_ALERT_GUEST_ARRIVAL,
	ANNOUNCEMENT_ALERT_HOLDINGS,
	ANNOUNCEMENT_ALERT_RUMOR,
	ANNOUNCEMENT_ALERT_AGREEMENT,
	ANNOUNCEMENT_ALERT_CRIME,
	ANNOUNCEMENT_ALERT_DEITY_CURSE,
	ANNOUNCEMENT_ALERT_COMBAT,
	ANNOUNCEMENT_ALERT_SPARRING,
	ANNOUNCEMENT_ALERT_HUNTING,
	ANNOUNCEMENT_ALERTNUM,
	ANNOUNCEMENT_ALERT_NONE=-1
};
typedef int32_t AnnouncementAlert;

enum justification : unsigned char {
  justify_left, justify_center, justify_right,
    justify_cont,
    not_truetype
};

extern int charmap[256];

template<typename T,size_t a,size_t b>
using array_2d=std::array<std::array<T,b>,a>;

template<typename T, size_t a, size_t b, size_t c>
using array_3d=std::array<std::array<std::array<T,c>,b>,a>;

#endif
