define(["exports","./emby-apiclient/events.js","./emby-apiclient/connectionmanager.js","./common/globalize.js","./common/pluginmanager.js","./common/querystring.js","./browser.js","./layoutmanager.js","./skinmanager.js","./loading/loading.js","./common/servicelocator.js","./common/textencoding.js","./viewmanager/viewmanager.js","./backdrop/backdrop.js","./pagejs/page.js","./emby-apiclient/apiclient.js","./common/baseapprouter.js"],function(_exports,_events,_connectionmanager,_globalize,_pluginmanager,_querystring,_browser,_layoutmanager,_skinmanager,_loading,_servicelocator,_textencoding,_viewmanager,_backdrop,_page,_apiclient,_baseapprouter){function showAlertAndResolve(options){return function(options){return Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}(options).catch(function(){return Promise.resolve()})}function AppRouter(){_baseapprouter.default.apply(this,arguments)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,Object.assign(AppRouter.prototype,_baseapprouter.default.prototype),AppRouter.prototype.showProfilePinPrompt=function(options){return Emby.importModule("./modules/profilepinprompt/profilepinprompt.js").then(function(PinPrompt){return(new PinPrompt).show(options)})};var IsHostedWebApp="standalone"===globalThis.appMode&&!_browser.default.electron,AllowSessionStorageUsage="standalone"===(globalThis.appMode||"standalone")&&!_browser.default.electron;function getServerLoginRouteUrl(options){var params,url;return"manual"===options.loginType||options.username?(params={serverId:options.apiClient.serverId()},url="/startup/manuallogin.html?",options.username&&(params.user=options.username),url+_querystring.default.paramsToString(params)):"visual"===options.loginType?"/startup/login.html?serverId="+options.apiClient.serverId():void 0}function addressFormatToHtml(address){return'<a is="emby-linkbutton" class="button-link" href="'+address+'" target="_blank">'+_textencoding.default.htmlEncode(address)+"</a>"}function addressFormatToText(address){return _textencoding.default.htmlEncode(address)}function showWebAppConnectionError(server,addresses){var addressHtml,supportsLinks,html=[];return html.push('<p style="margin-top:0;">'+_globalize.default.translate("MessageUnableToConnectToServer")+"</p>"),"https:"!==(window.location.protocol||"").toLowerCase()||function(addresses){for(var i=0,length=addresses.length;i<length;i++){var lower=addresses[i].toLowerCase();if(lower.includes("localhost"))return 1;if(lower.includes("127.0.0.1"))return 1;if(lower.startsWith("https:"))return 1}return}(addresses)?null:(addressHtml="<p>"+_globalize.default.translate("IfTryingToConnectToHttp")+"</p>",addressHtml=(addressHtml+="<ul>")+("<li>Use the web app built into your Emby Server at "+((supportsLinks=_servicelocator.appHost.supports("externallinks")&&_servicelocator.appHost.supports("targetblank"))?addresses.map(addressFormatToHtml):addresses.map(addressFormatToText)).join(" or ")+", depending on your current location.</li>"),addressHtml=supportsLinks?addressHtml+("<li>"+_globalize.default.translate("SetupHttpsForYourServer",'<a is="emby-linkbutton" class="button-link" href="https://emby.media/community/index.php?/topic/81404-ssl-made-easy" target="_blank">',"</a>"))+'</li><li>Use the HTTP version of this app at <a is="emby-linkbutton" class="button-link" href="http://app.emby.media" target="_blank">http://app.emby.media</a> instead.</li>':addressHtml+("<li>"+_globalize.default.translate("SetupHttpsForYourServer","",""))+"</li><li>Use the HTTP versionof this app at http://app.emby.media instead.</li>",html.push(addressHtml=addressHtml+"<li>Use an installed Emby app such as Emby for Windows, Android, Apple, Amazon, Samsung, LG, etc.</li>"+"</ul>"),showAlertAndResolve({html:html.join(""),title:server.Name?_globalize.default.translate("TitleUnableToReachName",_textencoding.default.htmlEncode(server.Name)):_globalize.default.translate("TitleUnableToReachServer"),centerText:!1}))}AppRouter.prototype.setPinValidated=function(userId){if(_baseapprouter.default.prototype.setPinValidated.apply(this,arguments),AllowSessionStorageUsage&&"undefined"!=typeof sessionStorage)try{userId?sessionStorage.setItem("pinvalidated",userId):sessionStorage.removeItem("pinvalidated")}catch(err){console.log("error setting sessionStorage")}},AppRouter.prototype.isPinValidated=function(userId){if(AllowSessionStorageUsage&&"undefined"!=typeof sessionStorage)try{return sessionStorage.getItem("pinvalidated")===userId}catch(err){console.log("error accessing sessionStorage")}return _baseapprouter.default.prototype.isPinValidated.apply(this,arguments)},AppRouter.prototype.showServerLogin=function(options){return options.loginType||options.username?show(getServerLoginRouteUrl(options)):_baseapprouter.default.prototype.showServerLogin.apply(this,arguments)},Object.assign(AppRouter.prototype,{showSelectServer:function(){return show(getRouteUrl("selectserver"))},showWelcome:function(){return _servicelocator.appHost.supports("multiserver")?show("/startup/welcome.html"):show("/startup/login.html?serverId="+_connectionmanager.default.currentApiClient().serverId())},showConnectLogin:function(){return show(getRouteUrl("connectlogin"))},showSettings:function(options){return show(getRouteUrl("settings",Object.assign({serverId:_connectionmanager.default.currentApiClient().serverId()},options||{})))},showUserMenu:function(options){return Emby.importModule("./modules/backmenu/backmenu.js").then(function(backMenu){return backMenu(options)})},showSearch:function(){return show(getRouteUrl("search"))},showGuide:function(){return show(this.getRouteUrl("livetv",{serverId:_connectionmanager.default.currentApiClient().serverId(),section:"guide"}))},showLiveTV:function(){return show(this.getRouteUrl("livetv",{serverId:_connectionmanager.default.currentApiClient().serverId()}))},showRecordedTV:function(){return show(this.getRouteUrl("recordedtv",{serverId:_connectionmanager.default.currentApiClient().serverId()}))},showFavorites:function(){return show("/home&tab=favorites")},showNowPlaying:function(){return showVideoOsd()}}),AppRouter.prototype.beginConnectionWizard=function(){_backdrop.default.clear(),_loading.default.show();var instance=this;return _servicelocator.appHost.supports("multiserver")?_connectionmanager.default.connect({}).then(function(result){return instance.handleConnectionResult(result,{useWelcomeForConnectSignIn:!0})}):this.showServerLogin({apiClient:_connectionmanager.default.currentApiClient()})},AppRouter.prototype.logout=function(apiClient){var instance=this;Emby.importModule("./modules/common/playback/playbackmanager.js").then(function(playbackManager){_loading.default.show(),playbackManager.stop(),_connectionmanager.default.logout(apiClient).then(instance.beginConnectionWizard.bind(instance))})},AppRouter.prototype.showConnectionErrorAlert=function(result,options){if(IsHostedWebApp){var addresses=function(result){var list=[];return result.Address?list.push(result.Address):(result=result.Server||{})&&(result.ManualAddress&&!list.includes(result.ManualAddress)&&list.push(result.ManualAddress),result.LocalAddress&&!list.includes(result.LocalAddress)&&list.push(result.LocalAddress),result.RemoteAddress)&&!list.includes(result.RemoteAddress)&&list.push(result.RemoteAddress),list}(result);if(0<addresses.length){addresses=showWebAppConnectionError(result.Server||{},addresses);if(addresses)return addresses}}return _baseapprouter.default.prototype.showConnectionErrorAlert.apply(this,arguments)},AppRouter.prototype.handleSignedInResult=function(result,options){switch(result.State){case"SignedIn":_loading.default.hide(),_viewmanager.default.disableRestoreOnCurrentViews(),!function(options){options=options||{};loadUserSkin({navigate:null==options.route}).then(function(){if(options.route)return handleRoute(options.ctx,options.route)})}(options);break;case"ServerSignIn":this.showServerLogin({apiClient:result.ApiClient})}};var currentViewLoadRequest,connectionType,firstConnectionResult,appRouter=new AppRouter;function loadUserSkin(options){return _skinmanager.default.loadSkin().then(function(){(options=options||{}).start?Emby.Page.invokeShortcut(options.start):!1!==options.navigate&&Emby.Page.goHome()})}function loadContentUrl(ctx,request,signal){var url=request.contentPath&&"function"==typeof request.contentPath?request.contentPath(ctx.rawQueryString):request.contentPath||request.path,url=(url.includes("://")||(url.startsWith("/")||(url="/"+url),url=baseRoute+url),ctx.rawQueryString&&request.enableContentQueryString&&(url+="?"+ctx.rawQueryString),[require(["text!"+url])]);return request.isPluginPage=request.url.toLowerCase().includes("/configurationpage"),request.isPluginPage&&url.push(_pluginmanager.default.loadServerPluginPageTranslations(_connectionmanager.default.currentApiClient(),request.params.name)),Promise.all(url).then(function(responses){responses=responses[0][0];return function(ctx,html,request,signal){return request.view=_globalize.default.translateDocument(html),ctx.handled=!0,_viewmanager.default.loadView(request,signal)}(ctx,responses,request,signal)})}function getControllerFactory(route){return route.controller?function(route){var url;return"module"===route.controllerType?((url=route.controller).includes("://")||(url="./"+url),Emby.importModule(url)):require([route.controller]).then(function(deps){return deps[0]})}(route):Promise.resolve()}function initRoute(ctx,route){var currentRequest=Object.assign({},route),isBackNav=ctx.isBack;return _events.default.trigger(appRouter,"initrouterequest",[currentRequest]),getControllerFactory(currentRequest).then(function(controllerFactory){currentViewLoadRequest&&currentViewLoadRequest.abortController.abort(),console.log("appRouter.sendRouteToViewManager - processing path: isBack: "+ctx.isBack),currentRequest.url=baseRoute+ctx.path,currentRequest.controllerFactory=controllerFactory,currentRequest.state=ctx.state,currentRequest.isBack=isBackNav,currentRequest.abortController=new AbortController,currentRequest.contextPath=ctx.path,currentRequest.params=ctx.params;controllerFactory=(currentViewLoadRequest=currentRequest).abortController.signal;return(isBackNav?function(ctx,currentRequest,signal){return _viewmanager.default.tryRestoreView(currentRequest,signal).catch(function(result){if(!signal.aborted)return loadContentUrl(ctx,currentRequest,signal)})}:loadContentUrl)(ctx,currentRequest,controllerFactory)})}function onBeforeExit(e){"webos"===globalThis.appMode&&_page.default.restorePreviousState()}function onAppResume(){_connectionmanager.default.onAppResume()}function handleRoute(ctx,route){var firstResult=firstConnectionResult;if(firstResult&&(firstConnectionResult=null,!route.anonymous))return appRouter.handleConnectionResult(firstResult,{useWelcomeForConnectSignIn:!0,route:route,ctx:ctx,enableProfilePin:!0}),Promise.resolve();var apiClient=_connectionmanager.default.currentApiClient(),firstResult=ctx.pathname.toLowerCase(),currentRouteInfo=(console.log("appRouter - processing path: "+firstResult+", isBack: "+ctx.isBack),getCurrentRouteInfo()),currentRouteInfo=!currentRouteInfo||currentRouteInfo.startup;if(ctx.isBack&&route.isDefaultRoute&&currentRouteInfo)return _servicelocator.appHost.supports("exit")&&_servicelocator.appHost.exit(),Promise.resolve();var isLoggedIn=apiClient&&apiClient.isLoggedIn();if(!(isLoggedIn||route.anonymous||"downloads"===ctx.params.parentId||(ctx.params.parentId||"").startsWith("local")||(ctx.params.id||"").startsWith("local")))return console.log("appRouter - route does not allow anonymous access, redirecting to login"),appRouter.beginConnectionWizard(),Promise.resolve();if(isLoggedIn){if(console.log("appRouter - user is authenticated"),ctx.isBack&&(route.isDefaultRoute||route.startup)&&!currentRouteInfo)return function(){if(_servicelocator.appHost.supports("exit")&&!_servicelocator.appHost.supports("exitmenu"))return _servicelocator.appHost.exit();_layoutmanager.default.tv?showBackMenuInternal():_servicelocator.appHost.supports("exit")?_servicelocator.appHost.exit():loadUserSkin()}(),Promise.resolve();if(route.isDefaultRoute)return console.log("appRouter - loading skin home page"),loadUserSkin({start:ctx.params.start}),Promise.resolve();if(!(route.isDefaultRoute||route.startup||route.anonymous))return function(apiClient,route){return route.roles?apiClient.getCurrentUser().then(function(user){return validateUserAccessToRoute(route,user)}):Promise.resolve()}(apiClient,route).then(function(){return function(ctx,route,apiClient){return appRouter.promptForProfilePin(apiClient,apiClient.getCurrentUserId()).then(function(){return initRoute(ctx,route)},function(err){switch(_viewmanager.default.disableRestoreOnCurrentViews(),((null==err?void 0:err.name)||"").toLowerCase()){case"forgotpin":return appRouter.forgotPin({apiClient:apiClient,userId:apiClient.getCurrentUserId()});case"changeuser":return appRouter.showServerLogin({apiClient:apiClient});default:return appRouter.showServerLogin({apiClient:apiClient,userId:apiClient.getCurrentUserId()})}})}(ctx,route,apiClient)},appRouter.beginConnectionWizard.bind(appRouter))}return console.log("appRouter - proceeding to "+firstResult),initRoute(ctx,route)}function validateUserAccessToRoute(route,user,loggedInUser){route=(route.roles||"").split(",");return!(route.includes("admin")&&!user.Policy.IsAdministrator||!(!route.includes("EnableUserPreferenceAccess")||user.Policy.EnableUserPreferenceAccess||loggedInUser&&loggedInUser.Policy.IsAdministrator))}function showBackMenuInternal(options){var currentThemeController=_skinmanager.default.getCurrentThemeController();return null!=currentThemeController&&currentThemeController.showBackMenu?currentThemeController.showBackMenu():Emby.importModule("./modules/navdrawer/navdrawer.js").then(function(navdrawer){return navdrawer.openIfClosed(!0)})}function getRequestFile(){console.log("router globalThis.location.pathname: "+globalThis.location.pathname);var path=globalThis.location.pathname||"",index=path.lastIndexOf("/");return(path=-1!==index?path.substring(index):"/"+path)&&"/"!==path||(path="/index.html"),console.log("router getRequestFile() result: "+path),path}navigator.connection&&(connectionType=navigator.connection.type,_servicelocator.appHost.supports("multiserver"))&&navigator.connection.addEventListener&&navigator.connection.addEventListener("change",function(){var newConnectionType=navigator.connection.type;newConnectionType!==connectionType&&(connectionType=newConnectionType,_connectionmanager.default.onNetworkChanged())}),console.log("router href: "+globalThis.location.href);var backdropContainer,backgroundContainer,docElem,baseRoute=globalThis.location.href.split("?")[0].replace(getRequestFile(),"");function baseUrl(){return baseRoute}function show(path,options){path.startsWith("/")||path.includes("://")||(path="/"+path);var baseRoute=baseUrl();return(path=path.replace(baseRoute,"")).includes("asDialog=true")?(baseRoute=_page.default.createContext(path),_page.default.dispatch(baseRoute),Promise.resolve()):(baseRoute=getCurrentRouteInfo())&&baseRoute.contextPath===path&&_viewmanager.default.canRestoreCurrentView()?(_loading.default.hide(),Promise.resolve()):_page.default.show(path,options)}function getCurrentRouteInfo(){return _viewmanager.default.currentViewInfo()}function getItemUrl(options,originalOptions){null!=originalOptions&&originalOptions.asDialog&&(options.asDialog=!0);originalOptions=new URLSearchParams(options),options.context||originalOptions.delete("context"),options=originalOptions.toString(),originalOptions="/item";return options&&(originalOptions+="?"+options),originalOptions}function getRouteUrl(item,options){if(item.url)return item.url;var context=null==(_options=options=options||{})?void 0:_options.context,_options=item.Id||item.ItemId,serverId=item.ServerId||options.serverId;if("home"===item)return"/home";if("search"===item)return _layoutmanager.default.tv?"/search":"/list/list.html?type=search";if("connectlogin"===item)return"/startup/connectlogin.html";if("selectserver"===item)return"/startup/selectserver.html";if("settings"===item){var url="/settings";if(serverId)if(url+="?serverId="+serverId,null!=(_options2=options)&&_options2.start)return url+("&start="+options.start);return url}if("wizard"===item)return"/wizardstart.html";if("downloads"===item)return"/list/list.html?parentId=downloads";if("downloadsettings"===item)return"/settings/download";if("premiere"===item)return"/embypremiere";if("managedownloads"===item)return"/settings/download?tab=managedownloads";if("manageserver"===item)return"/dashboard";if("recordedtv"===item)return"/livetv?tab=recordings&serverId="+serverId;if("nextup"===item)return"/list/list.html?type=nextup&serverId="+serverId;if("PluginCatalog"===item)return"/plugins?tab=catalog";if("LiveTVSetup"===item)return"/livetvsetup";if("livetv"===item||"livetv"===item.CollectionType)return"programs"===options.section?"/livetv?tab=suggestions&serverId="+serverId:"guide"===options.section?"/livetv?tab=guide&serverId="+serverId:"movies"===options.section?"/list/list.html?type=Program&IsMovie=true&serverId="+serverId:"shows"===options.section?"/list/list.html?type=Program&IsSeries=true&IsMovie=false&IsNews=false&serverId="+serverId:"newepisodes"===options.section?"/list/list.html?type=Program&IsSeries=true&IsMovie=false&IsNews=false&IsNewOrPremiere=true&serverId="+serverId:"sports"===options.section?"/list/list.html?type=Program&IsSports=true&serverId="+serverId:"kids"===options.section?"/list/list.html?type=Program&IsKids=true&serverId="+serverId:"news"===options.section?"/list/list.html?type=Program&IsNews=true&serverId="+serverId:"onnow"===options.section?"/list/list.html?type=OnNow&serverId="+serverId:"dvrschedule"===options.section?"/livetv?tab=schedule&serverId="+serverId:"/livetv?serverId="+serverId;if("list"===item)return _options2="/list/list.html?serverId="+serverId+"&type="+options.itemTypes,options.isFavorite&&(_options2+="&IsFavorite=true"),options.artistId&&(_options2+="&artistId="+options.artistId),options.albumArtistId&&(_options2+="&albumArtistId="+options.albumArtistId),_options2;url=item.Type||(options?options.itemType:null);if("ActiveSession"===url&&item.NowPlayingItem&&(url=(item=item.NowPlayingItem).Type,_options=item.Id),"EmbyConnect"===url)return getRouteUrl("connectlogin");if("Downloads"===url)return getRouteUrl("downloads");if("SelectServer"===url)return getRouteUrl("selectserver");if("ForgotPassword"===url)return"/startup/forgotpassword.html?serverId="+serverId;if("ManualLogin"===url)return getServerLoginRouteUrl({loginType:"manual",apiClient:_connectionmanager.default.getApiClient(serverId),username:item.Username});if("SeriesTimer"===url)return getItemUrl({seriesTimerId:_options,serverId:serverId},options);if("Timer"===url)return item.ProgramId?getItemUrl({id:item.ProgramId,serverId:serverId},options):getItemUrl({timerId:_options,serverId:serverId},options);if("Device"===url)return"/devices/device.html?id="+_options;if("Log"===url)return item.ServerId?"/log?name="+item.Name+"&serverId="+item.ServerId:"/applog?name="+item.Name;if("AddServer"===url)return"/startup/manualserver.html";if("Plugin"===url)return _pluginmanager.default.allowPluginPages(item.Id)?"/"+item.ConfigPageUrl:null;if("User"===url)return"/users/user?userId="+_options;if("LiveTVTunerDevice"===url){if(item.SetupUrl){var _options2=item.SetupUrl;if(_options2)return _options2.includes("?")?_options2+="&":_options2+="?",_options2+"id="+_options}return"/livetvsetup/livetvtuner.html?id="+_options}if("LiveTVGuideSource"===url)return function(url,name,value){return-1===url.indexOf("?")?url+"?"+name+"="+value:url+"&"+name+"="+value}(item.SetupUrl,"id",_options);if("GameGenre"===url)return _options2="/list/list.html?gameGenreId="+_options+"&serverId="+serverId,options.parentId&&(_options2+="&parentId="+options.parentId),_options2;if("MusicGenre"===url)return _options2="/item?id="+_options+"&serverId="+serverId,options.parentId&&(_options2+="&parentId="+options.parentId),_options2;if("Tag"===url||"Studio"===url||"Genre"===url)return _options2="/list/list.html?"+item.Type.toLowerCase()+"Id="+_options+"&serverId="+serverId,"livetv"===context?_options2+="Tag"===url?"&type=TvChannel":"&type=Program":"tvshows"===context&&(_options2+="&type=Series"),options.parentId&&(_options2+="&parentId="+options.parentId),options.itemTypes&&(_options2+="&type="+options.itemTypes),_options2;if("folders"!==context&&"GameSystem"===item.Type)return"/list/list.html?type=Game&serverId="+serverId+"&parentId="+_options;if("folders"!==context&&!_apiclient.default.isLocalItem(item)){if("games"===item.CollectionType)return"/games?serverId="+serverId+"&parentId="+_options;if("musicvideos"===item.CollectionType||"homevideos"===item.CollectionType||"movies"===item.CollectionType||("CollectionFolder"===item.Type||"VirtualFolder"===item.Type)&&!item.CollectionType)return _options2="/videos?serverId="+serverId+"&parentId="+_options,"latest"===options.section&&"movies"===item.CollectionType&&(_options2+="&tab=suggestions"),_options2;if("tvshows"===item.CollectionType)return _options2="/tv?serverId="+serverId+"&parentId="+_options,"latest"===options.section&&(_options2+="&tab=suggestions"),_options2;if("music"===item.CollectionType||"audiobooks"===item.CollectionType)return"/music?serverId="+serverId+"&parentId="+_options}if("PluginCatalogItem"===url)return"plugins/install?name="+encodeURIComponent(item.Name)+"&guid="+item.Id;if("Playlist"===url||"TvChannel"===url||"BoxSet"===url||"MusicAlbum"===url||"MusicGenre"===url||"Person"===url||"Recording"===url||"MusicArtist"===url)return getItemUrl({id:_options,serverId:serverId},options);if("Program"===url)return item.AsSeries?getItemUrl({id:_options,serverId:serverId,asSeries:!0},options):getItemUrl({id:_options,serverId:serverId},options);if("Series"===url||"Season"===url||"Episode"===url)return getItemUrl({id:_options,serverId:serverId,context:context},options);if(item.IsFolder){if(_options){_options2="/list/list.html?parentId="+_options+"&serverId="+serverId;switch(item.CollectionType){case"playlists":case"boxsets":context=item.CollectionType}return context&&(_options2+="&context="+context),_options2}return"#"}return item.RouteUrl||getItemUrl({id:_options,serverId:serverId},options)}function showItem(item,serverId,options){var apiClient;if("string"==typeof item)return(apiClient=serverId?_connectionmanager.default.getApiClient(serverId):_connectionmanager.default.currentApiClient()).getItem(apiClient.getCurrentUserId(),item).then(function(item){return appRouter.showItem(item,options)});if("Plugin"===item.Type){if(!item.ConfigPageUrl)return showAlertAndResolve(_globalize.default.translate("NoPluginConfigurationMessage"));if(!_pluginmanager.default.allowPluginPages(item.Id))return showAlertAndResolve(_globalize.default.translate("MessagePluginConfigurationRequiresLocalAccess"))}else{if("ActiveSession"===item.Type)return Promise.reject();if("Server"===item.Type)return Promise.reject()}return 2===arguments.length&&(options=serverId),show(appRouter.getRouteUrl(item,options))}function showVideoOsd(options){var currentRouteInfo=getCurrentRouteInfo();return currentRouteInfo&&"true"===currentRouteInfo.params.asDialog&&window.location.href.includes("videoosd.html")?Emby.importModule("./modules/dialoghelper/dialoghelper.js").then(function(dialogHelper){dialogHelper.close(currentRouteInfo.view)}):show("/videoosd/videoosd.html")}function addRoute(path,newRoute){path&&newRoute?(0,_page.default)(path,newRoute):function(newRoute){var baseRoute=baseUrl(),path=(path=newRoute.path).replace(baseRoute,"");console.log("Defining route: "+path),addRoute(path,newRoute)}(path)}(baseRoute=baseRoute.split("#")[0]).endsWith("/")&&!baseRoute.endsWith("://")&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.log("router baseUrl: "+baseRoute),document.addEventListener("viewbeforehide",function(e){var e=null==(e=e.detail)?void 0:e.newViewInfo;"true"!==(null==e||null==(e=e.params)?void 0:e.asDialog)&&_events.default.trigger(appRouter,"navigate")}),function(){var baseRoute=globalThis.location.pathname.replace(getRequestFile(),"");baseRoute.lastIndexOf("/")===baseRoute.length-1&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.log("Setting page base to "+baseRoute),_page.default.base(baseRoute)}(),appRouter.showBackMenu=showBackMenuInternal,appRouter.addRoute=addRoute,appRouter.back=function(){_page.default.back()},appRouter.forward=function(){_page.default.forward()},appRouter.show=show,appRouter.start=function(options){_loading.default.show(),_events.default.on(_servicelocator.appHost,"beforeexit",onBeforeExit),_events.default.on(_servicelocator.appHost,"resume",onAppResume);var promises=[];return promises.push(_connectionmanager.default.connect({})),promises.push(_skinmanager.default.loadSkin()),Promise.all(promises).then(function(responses){firstConnectionResult=responses[0],_loading.default.hide(),options=options||{},_page.default.handleRoute=handleRoute,(0,_page.default)({click:!1!==options.click,hashbang:!1!==options.hashbang})})},appRouter.baseUrl=baseUrl,appRouter.canGoBack=function(){var curr=getCurrentRouteInfo();return!!curr&&"home"!==curr.type&&_page.default.canGoBack()},appRouter.currentViewPath=function(){var _viewManager$currentV;return null==(_viewManager$currentV=_viewmanager.default.currentViewInfo())?void 0:_viewManager$currentV.path},appRouter.goHome=function(){return show("/home")},appRouter.showItem=showItem,appRouter.setTitle=function(title){Emby.importModule("./modules/appheader/appheader.js").then(function(appHeader){appHeader.setTitle(title)})},appRouter.setTransparency=function(level){backdropContainer=backdropContainer||document.querySelector(".backdropContainer"),backgroundContainer=backgroundContainer||document.querySelector(".backgroundContainer"),docElem=docElem||document.documentElement,"full"===level||2===level?(_backdrop.default.externalBackdrop(!0),docElem.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):"backdrop"===level||1===level?(_backdrop.default.externalBackdrop(!0),docElem.classList.add("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):(_backdrop.default.externalBackdrop(!1),docElem.classList.remove("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.remove("hide"))},appRouter.getRoutes=function(){return _page.default.getRoutes()},appRouter.getRouteUrl=getRouteUrl,appRouter.getRouteInfo=function(url){return _page.default.getRoute(url)},appRouter.pushState=function(state,title,url){state.navigate=!1,_page.default.pushState(state,title,url)},appRouter.replaceState=function(path,dispatch){_page.default.replace(path,{},dispatch),_viewmanager.default.replaceCurrentUrl(baseRoute+path)},appRouter.showVideoOsd=showVideoOsd,appRouter.handleAnchorClick=_page.default.handleAnchorClick,appRouter.TransparencyLevel={None:0,Backdrop:1,Full:2},appRouter.invokeShortcut=function(id){return id.startsWith("library-")?showItem((id=(id=id.replace("library-","")).split("_"))[0],id[1]):id.startsWith("item-")?showItem((id=(id=id.replace("item-","")).split("_"))[0],id[1]):(id=id.split("_"),show(appRouter.getRouteUrl(id[0],{serverId:id[1]})))},appRouter.validateUserAccessToRoute=validateUserAccessToRoute,appRouter.getHandleRouteFn=function(){return handleRoute},globalThis.Emby.Page=appRouter,globalThis.Emby.TransparencyLevel=appRouter.TransparencyLevel;_exports.default=appRouter});