define(["exports","./dom.js","./common/globalize.js","./loading/loading.js","./approuter.js","./common/playback/playbackmanager.js","./common/playback/playbackactions.js","./emby-apiclient/connectionmanager.js","./common/itemmanager/itemmanager.js","./common/responsehelper.js","./common/servicelocator.js"],function(_exports,_dom,_globalize,_loading,_approuter,_playbackmanager,_playbackactions,_connectionmanager,_itemmanager,_responsehelper,_servicelocator){function showPrompt(options){return Emby.importModule("./modules/prompt/prompt.js").then(function(prompt){return prompt(options)})}function showAlertAndResolve(options){return function(options){return Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}(options).catch(function(){return Promise.resolve()})}function downloadItems(items,options){var apiClient=_connectionmanager.default.getApiClient(items[0]);if(options=options||{},"RemoteSubtitle"===items[0].Type)return function(item,apiClient){return _loading.default.show(),apiClient.downloadSubtitles(item.ItemId,item.MediaSourceId,item.Id).then(function(result){return _loading.default.hide(),showToast(_globalize.default.translate("SubtitlesDownloaded")),result})}(items[0],apiClient);for(var urls,downloadUrls=[],i=0,length=items.length;i<length;i++){var url,item=items[i];"Log"===item.Type?item.ServerId?downloadUrls.push(apiClient.getLogDownloadUrl({Name:item.Name,Sanitize:!1!==options.Sanitize,SetFilename:!0})):function(item){_servicelocator.appLogger.downloadLog(item.Name)}(item):"MediaStream"===item.Type&&"Subtitle"===item.StreamType?(url="Videos/"+item.ItemId+"/"+item.MediaSourceId+"/Subtitles/"+item.Index+"/Stream."+item.Codec,downloadUrls.push(apiClient.getUrl(url,{SetFilename:!0}))):(url=options.mediaSourceId,item=apiClient.getItemDownloadUrl(item.Id,url),downloadUrls.push(item))}return urls=downloadUrls,Emby.importModule("./modules/multidownload.js").then(function(multiDownload){multiDownload(urls)})}function removeFromResume(items){var item=items[0],confirmHeader="Audio"===item.MediaType?_globalize.default.translate("HeaderRemoveFromContinueListening"):_globalize.default.translate("HeaderRemoveFromContinueWatching"),apiClient=_connectionmanager.default.getApiClient(item);return function(options){return Emby.importModule("./modules/common/dialogs/confirm.js").then(function(confirm){return confirm(options)})}({title:confirmHeader,text:"Audio"===item.MediaType?_globalize.default.translate("RemoveThisTitleFromContinueListening"):_globalize.default.translate("RemoveThisTitleFromContinueWatching"),confirmText:_globalize.default.translate("Remove"),primary:"cancel"}).then(function(){return apiClient.updateHideFromResume(items.map(mapToId),!0)})}function mapToId(i){return i.Id}function markFavorite(items,isFavorite){var apiClient=_connectionmanager.default.getApiClient(items[0]);return apiClient.updateFavoriteStatus(apiClient.getCurrentUserId(),items.map(mapToId),isFavorite).then(function(){showToast(isFavorite?{text:_globalize.default.translate("Favorited"),icon:"&#xe87D;"}:{text:_globalize.default.translate("Unfavorited"),icon:"&#xe87D;",iconStrikeThrough:!0})})}function afterWakeAttempt(){var timeMs,apiClient=this;return timeMs=12e3,new Promise(function(resolve,reject){setTimeout(resolve,timeMs)}).then(function(){return apiClient.getPublicSystemInfo()})}function wakeServer(apiClient){return require(["loadingDialog"]).then(function(responses){var responses=new responses[0]({title:_globalize.default.translate("HeaderWakeServer"),text:_globalize.default.translate("AttemptingWakeServer")}),showDialogPromise=responses.show(),responses={dlg:responses,showDialogPromise:showDialogPromise},showDialogPromise=afterWakeAttempt.bind(apiClient);return apiClient.wakeOnLan().then(showDialogPromise,showDialogPromise).then(function(){var promise=this.showDialogPromise.then(function(){return showAlertAndResolve({text:_globalize.default.translate("WakeServerSuccess"),title:_globalize.default.translate("HeaderWakeServer")})}),dlg=this.dlg;return dlg.hide(),dlg.destroy(),promise}.bind(responses),function(){var promise=this.showDialogPromise.then(function(){return showAlertAndResolve({text:_globalize.default.translate("WakeServerError"),title:_globalize.default.translate("HeaderWakeServer")})}),dlg=this.dlg;return dlg.hide(),dlg.destroy(),promise}.bind(responses))})}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var QueueQueryLimit=5e3;function playAllFromHere(itemElement,serverId,queue,autoAdvancePhotos){var itemsContainer=itemElement.closest(".itemsContainer"),startIndex=itemsContainer.indexOfElement(itemElement);if(itemsContainer&&itemsContainer.fetchData){if("folders"===(null==(_itemsContainer$curre=itemsContainer.currentListOptions)?void 0:_itemsContainer$curre.options.context)){var _itemsContainer$curre=itemsContainer.getItemFromElement(itemElement);if(_itemsContainer$curre&&null!=(_connectionManager$ge=_connectionmanager.default.getApiClient(_itemsContainer$curre))&&_connectionManager$ge.isMinServerVersion("4.8.0.59"))return function(item,queue,itemsContainer){var queryOptions={};return queryOptions.StartItemId=item.Id,queryOptions.Recursive=!0,queryOptions.IsFolder=!1,queryOptions.Limit=0,itemsContainer.fetchData(queryOptions).then(function(result){var itemStartIndex=result.TotalRecordCount;return queryOptions.StartIndex=0,queryOptions.Limit=QueueQueryLimit+itemStartIndex,queryOptions.StartItemId=null,itemsContainer.fetchData(queryOptions).then(function(result){var startIndex=itemStartIndex?Math.max(result.TotalRecordCount-itemStartIndex,0):0;return queue?_playbackmanager.default.queue({items:(result.Items||result).slice(startIndex)}):_playbackactions.default.play({items:result.Items||result,startIndex:startIndex})})})}(_itemsContainer$curre,queue,itemsContainer)}var _connectionManager$ge=QueueQueryLimit,fetchAll=(queue||(_connectionManager$ge+=startIndex||0),!queue&&startIndex<_connectionManager$ge),_itemsContainer$curre=fetchAll?{Limit:_connectionManager$ge}:{StartIndex:startIndex,Limit:_connectionManager$ge};return itemsContainer.fetchData(_itemsContainer$curre).then(function(result){return queue?_playbackmanager.default.queue({items:result.Items||result}):_playbackactions.default.play({items:result.Items||result,startIndex:fetchAll?startIndex:null,autoplay:autoAdvancePhotos})})}for(var _connectionManager$ge=itemElement.parentNode,itemsContainer=itemElement.classList.length?"."+itemElement.classList[0]:"",cards=_connectionManager$ge.querySelectorAll(itemsContainer+"[data-id]"),ids=[],foundCard=!1,i=0,length=cards.length;i<length;i++)cards[i]===itemElement&&(foundCard=!0,startIndex=i),!foundCard&&queue||ids.push(cards[i].getAttribute("data-id"));if(ids.length)return queue?_playbackmanager.default.queue({ids:ids,serverId:serverId}):_playbackactions.default.play({ids:ids,serverId:serverId,startIndex:startIndex})}function showToast(options){Emby.importModule("./modules/toast/toast.js").then(function(toast){return toast(options)})}function notifyAddedToPlayQueue(){return showToast({text:_globalize.default.translate("HeaderAddedToPlayQueue"),icon:"&#xe03b;"}),Promise.resolve()}function notifyPlayingNext(){return showToast({text:_globalize.default.translate("HeaderPlayingNext"),icon:"&#xe03b;"}),Promise.resolve()}function play(items,resume,queue,queueNext,shuffle,parentId){var method=queue?queueNext?"queueNext":"queue":"play",item=items[0],resume={startPositionTicks:!1===resume?0:item.StartPositionTicks,parentId:parentId};return resume.items=items,resume.autoplay=1<items.length,shuffle&&(resume.shuffle=!0),item=("play"==method?_playbackactions:_playbackmanager).default[method](resume),queueNext?item=item.then(notifyPlayingNext):queue&&(item=item.then(notifyAddedToPlayQueue)),item}function showItem(item,options){var itemsContainer;return options&&!options.parentId&&(options.itemElement||options.positionTo)&&(itemsContainer=options.itemsContainer||(options.itemElement||options.positionTo).closest(".itemsContainer"))&&(options.parentId=itemsContainer.getAttribute("data-parentid")||null),_approuter.default.showItem(item,options)}function moveInOrder(items,options,newIndex){var currentIndex,item=items[0];switch(null==item?void 0:item.Type){case"ChannelManagementInfo":return function(items,newIndex){return items=items[0],_connectionmanager.default.getApiClient(items).setChannelSortIndex(items,newIndex)}(items,newIndex);case"ItemImage":return function(items,newIndex){return items=items[0],_connectionmanager.default.getApiClient(items).updateItemImageIndex(items.ItemId,items.ImageType,items.ImageIndex,newIndex)}(items,newIndex);default:return item.PlaylistId?function(items,newIndex,playlistId){var item=items[0];return _connectionmanager.default.getApiClient(item).moveItemsInPlaylist(playlistId,items,newIndex)}(items,newIndex,item.PlaylistId):(currentIndex=options.itemsContainer.indexOfItem(item),function(items,options,moveOptions){var _options$itemsContain2;return null!=(_options$itemsContain2=options.itemsContainer)&&null!=(_options$itemsContain2=_options$itemsContain2.currentListOptions)&&null!=(_options$itemsContain2=_options$itemsContain2.options.commandActions)&&_options$itemsContain2.moveInOrder?options.itemsContainer.currentListOptions.options.commandActions.moveInOrder(items,moveOptions).then(function(result){!1!==(null==result?void 0:result.refreshItems)&&options.itemsContainer.notifyRefreshNeeded(!0)}):_itemmanager.default.moveInOrder(items,moveOptions)}(items,options,{currentIndex:currentIndex,newIndex:newIndex,itemsContainer:options.itemsContainer}))}}function moveByOffsetInOrder(items,options,moveOffset){var item=items[0];return"ChannelManagementInfo"===(null==item?void 0:item.Type)?moveInOrder(items,options,item.SortIndexNumber+moveOffset):(item=options.itemsContainer.indexOfItem(item),moveInOrder(items,options,item+moveOffset))}function record(item,options){return"TvChannel"===item.Type?function(item,options){return require(["channelRecordingCreator"]).then(function(responses){return responses[0].createRecordingForChannel(item,options)})}(item,options):function(item){var type=item.Type,id=item.Id,serverId=item.ServerId,timerId="Timer"===type?item.Id:item.TimerId,seriesTimerId=item.SeriesTimerId,programId="Program"===type?id:item.ProgramId,status=item.Status;return programId||timerId||seriesTimerId?require(["recordingHelper"]).then(function(responses){return responses[0].toggleRecording(serverId,"Program"===type?id:null,timerId,status,seriesTimerId)}):Promise.resolve()}(item)}function editSubtitles(item,options){return require(["subtitleEditor"]).then(function(responses){return responses[0].show({item:item,mediaSource:function(mediaSources,mediaSourceId){for(var i=0,length=mediaSources.length;i<length;i++)if(mediaSources[i].Id===mediaSourceId)return mediaSources[i];return mediaSources[0]}(item.MediaSources,options.mediaSourceId)})})}function shareFileViaWeb(item,options,title,text,url,filename,mimeType){return fetch(url,{credentials:"same-origin"}).then(function(r){return r.blob()}).then(function(blob){blob=new File([blob],filename,{type:mimeType});return navigator.share({files:[blob],title:title})})}function getSyncAllowedPromise(items){if("embyclient"===globalThis.appMode){items=items[0];if(items)if(!_connectionmanager.default.getApiClient(items).isMinServerVersion("4.8.4"))return showAlertAndResolve("To use the download feature, please update Emby Server to at least 4.8.4 or greater.")}}function getLyricsTrackEventHtml(item,index){var html='<div style="margin:.5em 0;">';return html+item.Text+"</div>"}function showLyrics(item){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.getItem(apiClient.getCurrentUserId(),item.Id,{ExcludeFields:"Chapters,People,Overview,MediaStreams"}).then(function(item){var mediaSource=item.MediaSources[0],stream=function(item,mediaSource){return mediaSource.MediaStreams.filter(function(s){return"Subtitle"===s.Type&&s.Index===item.DefaultSubtitleStreamIndex})[0]||mediaSource.MediaStreams.filter(function(s){return"Subtitle"===s.Type})[0]}(item,mediaSource);return apiClient.getJSON(apiClient.getUrl("Items/"+item.Id+"/"+mediaSource.Id+"/Subtitles/"+stream.Index+"/Stream.js")).then(function(result){return showAlertAndResolve({html:result.TrackEvents.map(getLyricsTrackEventHtml).join(""),confirmButton:!1,title:_itemmanager.default.getDisplayName(item),centerText:!1,confirmText:_globalize.default.translate("Close"),item:item})})})}function getItemsContainerParentId(itemsContainer){return(null==itemsContainer?void 0:itemsContainer.getAttribute("data-parentid"))||null}function executeCommandInternal(command,items,options){var apiClient,virtualFolder,button,item=items[0];if("open"===command||"link"===command||"linkdialog"===command){if("Photo"!==item.MediaType)return"linkdialog"===command&&((options=options||{}).asDialog=!0),showItem(item,options);command="play"}if("download"===command)return downloadItems(items,options);if("identify"===command)return function(item){return require(["itemIdentifier"]).then(function(responses){return responses[0].show(item)})}(item);if("resetmetadata"===command)return function(items){return require(["itemIdentifier"]).then(function(responses){return responses[0].resetMetadata(items)})}(items);if("preview"===command)return function(item){var apiClient=_connectionmanager.default.getApiClient(item),url="RemoteSubtitle"===item.Type?apiClient.getUrl("Providers/Subtitles/Subtitles/"+item.Id):apiClient.getUrl("Videos/"+item.ItemId+"/"+item.MediaSourceId+"/Subtitles/"+item.Index+"/Stream."+item.Codec);return apiClient.getText(url).then(function(result){return showAlertAndResolve({preFormattedText:_dom.default.stripScripts(result),confirmButton:!1,title:_globalize.default.translate("Subtitles"),item:item})})}(item);if("removefromresume"===command)return removeFromResume(items);if("removefromnextup"===command)return removeFromResume(items);if("playtrailer"===command)return function(item){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.getLocalTrailers(apiClient.getCurrentUserId(),item.Id).then(function(trailers){_playbackmanager.default.play({items:trailers})})}(item);if("connecttoserver"===command)return function(item){return"AddServer"===item.Type||"Downloads"===item.Type?_approuter.default.showItem(item):"EmbyConnect"===item.Type?_approuter.default.showConnectLogin():(_loading.default.show(),item=_connectionmanager.default.getServerInfo(item.Id)||item,_connectionmanager.default.connectToServer(item,{}).then(function(result){return _approuter.default.handleConnectionResult(result)}))}(item);if("setplaylistindex"===command)return _playbackmanager.default.setCurrentPlaylistItem(item.PlaylistItemId);if("multiselect"===command)return function(options){return options.positionTo.closest(".itemsContainer").showMultiSelect(options.positionTo,!0),Promise.resolve()}(options);if("wakeserver"===command)return wakeServer(_connectionmanager.default.getApiClient(item));switch(command){case"leaveshareditems":case"delete":case"canceltimer":case"cancelseriestimer":return function(items,options,command){return items={items:items,navigate:options.navigateOnDelete||!1,positionTo:options.positionTo,deleteType:command},null!=(command=options.itemsContainer)&&null!=(command=command.currentListOptions)&&null!=(command=command.options.commandActions)&&command.deleteItems?options.itemsContainer.currentListOptions.options.commandActions.deleteItems(items).then(function(result){!1!==(null==result?void 0:result.refreshItems)&&options.itemsContainer.notifyRefreshNeeded(!0)}):_itemmanager.default.deleteItems(items)}(items,options,command);case"edit":return function(items,options){var item=items[0];return"Device"===item.Type||"User"===item.Type||"ActiveSession"===item.Type||"SeriesTimer"===item.Type||"Timer"===item.Type||"LiveTVTunerDevice"===item.Type||"LiveTVGuideSource"===item.Type?showItem(item,options):null!=(item=options.itemsContainer)&&null!=(item=item.currentListOptions)&&null!=(item=item.options.commandActions)&&item.edit?options.itemsContainer.currentListOptions.options.commandActions.edit(items,options).then(function(result){!1!==(null==result?void 0:result.refreshItems)&&options.itemsContainer.notifyRefreshNeeded(!0)}):_itemmanager.default.editItems(items,options)}(items,options);case"editimages":return function(item){return require(["imageEditor"]).then(function(responses){return responses[0].show({itemId:item.Id,serverId:item.ServerId})})}(item);case"instantmix":return _playbackmanager.default.instantMix(item);case"shuffle":return play(items,!1,null,null,!0,getItemsContainerParentId(options.itemsContainer));case"playallfromhereautoplay":return playAllFromHere(options.itemElement,item.ServerId,null,!0);case"playallfromhere":return playAllFromHere(options.itemElement,item.ServerId);case"queueallfromhere":return playAllFromHere(options.itemElement,item.ServerId,!0);case"play":return play(items,!0,null,null,null,getItemsContainerParentId(options.itemsContainer));case"playfrombeginning":return play(items,!1,null,null,null,getItemsContainerParentId(options.itemsContainer));case"resume":case"playpause":return play(items,!0,null,null,null,getItemsContainerParentId(options.itemsContainer));case"queue":return play(items,!1,!0,null,null,getItemsContainerParentId(options.itemsContainer));case"queuenext":return play(items,!1,!0,!0,null,getItemsContainerParentId(options.itemsContainer));case"artist":return _approuter.default.showItem(item.ArtistItems[0].Id,item.ServerId),Promise.resolve();case"album":return _approuter.default.showItem(item.AlbumId,item.ServerId),Promise.resolve();case"series":return _approuter.default.showItem(item.SeriesId,item.ServerId),Promise.resolve();case"season":return _approuter.default.showItem(item.SeasonId,item.ServerId),Promise.resolve();case"overview":return showAlertAndResolve({html:_dom.default.stripScripts(item.Overview||""),confirmButton:!1,title:_itemmanager.default.getDisplayName(item)||item.Name,centerText:!1,item:item});case"programlink":var program=item.CurrentProgram||item;return program.ServerId||(program.ServerId=item.ServerId),showItem(program,options);case"addtoplaylist":return _itemmanager.default.addToPlaylist(items,options);case"addtocollection":return _itemmanager.default.addToCollection(items,options);case"markplayed":return function(items){var apiClient=_connectionmanager.default.getApiClient(items[0]);return apiClient.markPlayed(apiClient.getCurrentUserId(),items.map(mapToId))}(items);case"markunplayed":return function(items){var apiClient=_connectionmanager.default.getApiClient(items[0]);return apiClient.markUnplayed(apiClient.getCurrentUserId(),items.map(mapToId))}(items);case"favorite":return markFavorite(items,!0);case"unfavorite":return markFavorite(items,!1);case"searchimageproviders":return function(item){return Emby.importModule("./modules/imagedownloader/imagedownloader.js").then(function(ImageDownloader){return(new ImageDownloader).show({item:item.OwnerItem,imageType:item.ImageType,imageIndex:item.ImageIndex})})}(item);case"addimage":return function(item){return Emby.importModule("./modules/imageuploader/imageuploader.js").then(function(imageUploader){return imageUploader.show({imageType:item.ImageType,imageIndex:item.ImageIndex,item:item.OwnerItem})})}(item);case"moveinorder":return moveInOrder(items,options,options.newIndex);case"moveupinorder":return moveByOffsetInOrder(items,options,-1);case"movedowninorder":return moveByOffsetInOrder(items,options,1);case"addimagefromurl":return function(item){return showPrompt({title:_globalize.default.translate(item.ImageTag?"HeaderSetImageFromUrl":"HeaderAddImageFromUrl"),label:_globalize.default.translate("LabelUrl")}).then(function(url){return _connectionmanager.default.getApiClient(item).updateItemImageFromUrl(item.ItemId,item.ImageType,item.ImageIndex,url)})}(item);case"toggleitemchecked":return function(items,options){var checked,itemsContainer,promise;return"change"===options.eventType&&(checked=options.eventTarget.checked,promise=(itemsContainer=options.itemsContainer)?null==(options=itemsContainer.currentListOptions)?void 0:options.options.checkboxAction({items:items,checked:checked}).then(function(){for(var i=0,length=items.length;i<length;i++){var item=items[i],index=itemsContainer.indexOfItemId(item.Id);-1!==index&&itemsContainer.onItemUpdated(index,item)}}):promise)||Promise.resolve()}(items,options);case"togglecheckbox":return function(options){return(options=options.itemElement.querySelector(".chkItemCheckbox")).checked=!options.checked,options.dispatchEvent(new CustomEvent("change",{cancelable:!0,bubbles:!0})),Promise.resolve()}(options);case"copytoclipboard":return function(item){return navigator.clipboard.writeText(item.AccessToken)}(item);case"share":return function(items,options){var items=items[0],shareTitle=_itemmanager.default.getDisplayName(items),shareText=shareTitle,apiClient=(items.Overview&&(shareText+=" - "+items.Overview),_connectionmanager.default.getApiClient(items));if("Photo"===items.Type){var _item$ImageTags=apiClient.getImageUrl(items.Id,{type:"Primary",tag:null==(_item$ImageTags=items.ImageTags)?void 0:_item$ImageTags.Primary,format:"png"});if("android"!==globalThis.appMode&&"ios"!==globalThis.appMode)return shareFileViaWeb(0,0,shareTitle,0,_item$ImageTags,"image.png","image/png")}else if("Log"===items.Type){if(!items.ServerId)return _servicelocator.appLogger.shareLog(items);if("android"!==globalThis.appMode&&"ios"!==globalThis.appMode)return shareFileViaWeb(0,0,shareTitle,0,_item$ImageTags=apiClient.getLogDownloadUrl({Name:items.Name,Sanitize:options.Sanitize,SetFilename:!0}),items.Name,"text/plain")}else{items=null==(options=apiClient.serverInfo())?void 0:options.RemoteAddress;_item$ImageTags=apiClient.getUrl("share",{},items).replace("/share","")}return navigator.share({title:shareTitle,text:shareText,url:_item$ImageTags})}(items,options);case"seektoposition":return function(item){return"LyricsLine"===item.Type&&null==item.StartPositionTicks?Promise.resolve():_playbackmanager.default.seek(item.StartPositionTicks||0)}(item);case"sync":return function(items){var promise=getSyncAllowedPromise(items);return promise||Emby.importModule("./modules/sync/sync.js").then(function(syncDialog){return syncDialog.showMenu({items:items,mode:"sync"})})}(items);case"synclocal":return function(items){var promise=getSyncAllowedPromise(items);return promise||Emby.importModule("./modules/sync/sync.js").then(function(syncDialog){return syncDialog.showMenu({items:items,mode:"download"})})}(items);case"convert":return function(items){return Emby.importModule("./modules/sync/sync.js").then(function(syncDialog){return syncDialog.showMenu({items:items,mode:"convert"})})}(items);case"editsubtitles":return editSubtitles(item,options);case"changelibrarycontenttype":return _connectionmanager.default.getApiClient(item),options.positionTo,showAlertAndResolve({title:_globalize.default.translate("HeaderChangeFolderType"),text:_globalize.default.translate("HeaderChangeFolderTypeHelp")});case"renamelibrary":return apiClient=_connectionmanager.default.getApiClient(item),virtualFolder=item,button=options.positionTo,showPrompt({label:_globalize.default.translate("LabelNewName"),confirmText:_globalize.default.translate("ButtonRename"),value:virtualFolder.Name}).then(function(newName){var refreshAfterChange;if(newName&&newName!==virtualFolder.Name)return refreshAfterChange="true"===button.closest(".page").getAttribute("data-refreshlibrary"),apiClient.renameVirtualFolder(virtualFolder,newName,refreshAfterChange)});case"refresh":return _itemmanager.default.refreshMetadata(items,options);case"scan":return _itemmanager.default.scanLibraryFiles(items,options);case"removefromplayqueue":return _itemmanager.default.removeFromPlayQueue(items,options);case"removefromplaylist":return _connectionmanager.default.getApiClient(item).removeItemsFromPlaylist(item.PlaylistId,items);case"removefromcollection":return _connectionmanager.default.getApiClient(item).removeItemsFromCollection(item.CollectionId,items);case"session_stop":return _connectionmanager.default.getApiClient(item).sendPlayStateCommand(item.Id,"Stop");case"session_playpause":return _connectionmanager.default.getApiClient(item).sendPlayStateCommand(item.Id,"PlayPause");case"session_sendmessage":return function(item){return showPrompt({title:_globalize.default.translate("HeaderSendMessage"),label:_globalize.default.translate("LabelMessageText"),confirmText:_globalize.default.translate("ButtonSend")}).then(function(text){return text?_connectionmanager.default.getApiClient(item).sendMessageCommand(item.Id,{Text:text,TimeoutMs:5e3}):Promise.reject()})}(item);case"session_shownowplayingitem":return item.NowPlayingItem?showItem(item.NowPlayingItem,options):Promise.reject();case"serverinfo":return function(item){var apiClient=_connectionmanager.default.getApiClient(item),html="";return html+='<div style="overflow-x:hidden;">',apiClient.serverVersion()&&(html=(html+='<h4 style="margin:0;" class="secondaryText">'+_globalize.default.translate("Version")+"</h4>")+"<div>"+apiClient.serverVersion()+"</div>"),item.LastConnectionMode?html+='<h4 style="margin-bottom:0;" class="secondaryText">'+_globalize.default.translate("HeaderLastConnectedTo")+"</h4>":html+='<h4 style="margin-bottom:0;" class="secondaryText">'+_globalize.default.translate("HeaderServerAddress")+"</h4>",html+="<div>"+apiClient.serverAddress()+"</div>",item.RemoteAddress&&(html=(html+='<h4 style="margin-bottom:0;" class="secondaryText">'+_globalize.default.translate("RemoteWAN")+"</h4>")+"<div>"+item.RemoteAddress+"</div>"),showAlertAndResolve({title:item.Name,html:html+="</div>",centerText:!1})}(item);case"record":return record(item,options);case"lyrics":return showLyrics(item);case"manageaccess":return function(item){return require(["ItemAccessDialog"]).then(function(responses){return(new responses[0]).show({item:item})})}(item);case"mergeversions":return _itemmanager.default.groupVersions(items,options);case"showmissingepisodes":return function(items){return Emby.importModule("./modules/missingepisodesdialog/missingepisodesdialog.js").then(function(MissingEpisodesDialog){return(new MissingEpisodesDialog).show({items:items})})}(items);case"none":case"toggletreenode":return Promise.resolve();default:return _itemmanager.default.executeCommand(command,items,options)}}_exports.default={executeCommand:function(command,items,options){var promise;try{promise=executeCommandInternal(command,items,options)}catch(err){promise=Promise.reject(err)}return!1===(null==options?void 0:options.showErrorMessage)?promise:promise.catch(function(err){return err?_responsehelper.default.handleErrorResponse(err):Promise.reject(err)})}}});