#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 bin
version:              0.1.3
visibility:           public
id:                   bin-0.1.3-2Z3SDFUkaRA6MdMV9PTyfB
key:                  bin-0.1.3-2Z3SDFUkaRA6MdMV9PTyfB
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  f2710e23d1e2a16eccaa2e391e280214
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.2.8/site-local/bin-0.1.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/bin-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.3-2Z3SDFUkaRA6MdMV9PTyfB
depends:
    QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2 base-4.16.4.0
    boring-0.2.1-Icfsg6aSH6SpFFKOquZU dec-0.0.5-AiPCixVZqIRKIMMKnR0Fi3
    deepseq-1.4.6.1 fin-0.3-9oQOjzcNh5Y3MdD5lRdENL
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    some-1.0.5-L5glA67mR8RJufLDsA2lRz

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

