#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-BMnuJEdLLJ07rrRnDZXEQS
key:                  jose-0.10-BMnuJEdLLJ07rrRnDZXEQS
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  069de719ef9d88c39182d5f9c9235458
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.2.8/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.2.8/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-BMnuJEdLLJ07rrRnDZXEQS
depends:
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9 base-4.16.4.0
    base64-bytestring-1.2.1.0-IROdBrGh8de3SyeGv4rKYj
    bytestring-0.11.4.0 concise-0.1.0.1-C5egC0fPRmHE50FRkxOehD
    containers-0.6.5.1 cryptonite-0.30-HEkNV1IKVtLAPqzqnhGNTC
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    monad-time-0.4.0.0-G0cg84G7v7e4LIba2RkEEW mtl-2.2.2
    network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    x509-1.7.7-JalouZUvUN14vI8I0XYQIJ

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

