#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-9pglmc96fJ6Jh9x4jWIzD4
key:                  lsp-1.4.0.0-9pglmc96fJ6Jh9x4jWIzD4
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  93b8ef0e02fe075ff3e190f1c142008f
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-9pglmc96fJ6Jh9x4jWIzD4
depends:
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS exceptions-0.10.4
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    hslogger-1.3.1.1-AaFqNA3CZ3wF1V1MzkMbBe
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7
    lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh mtl-2.2.2
    network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR
    random-1.2.1.2-LilJ2o1ueBgJ3oDFJkkk0o
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    sorted-list-0.2.2.0-5gvI3TxvI1l28SUYOFwV6c stm-2.5.0.2 text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2
    unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    uuid-1.3.15-GJAgkIPzZsG6ahfadLQUcv

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

