#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mueval
version:              0.9.3
visibility:           public
id:                   mueval-0.9.3-KPB6EMVYSO8EM95XasFrG0
key:                  mueval-0.9.3-KPB6EMVYSO8EM95XasFrG0
license:              BSD-3-Clause
maintainer:           Gwern <gwern@gwern.net>
author:               Gwern
homepage:             https://github.com/gwern/mueval
synopsis:             Safely evaluate pure Haskell expressions
description:
    Mueval is a Haskell interpreter. It
    uses the GHC API to evaluate arbitrary Haskell expressions.
    Importantly, mueval takes many precautions to defang and avoid \"evil\"
    code.  It uses resource limits, whitelisted modules and Safe Haskell,
    special Show instances for IO, threads, processes, and changes of directory
    to sandbox the Haskell code.

    It is, in short, intended to be a standalone version of Lambdabot'\''s famous
    evaluation functionality. For examples and explanations, please see the README file.

    Mueval is POSIX-only.

category:             Development, Language
abi:                  ac4e1705ad2c03439b97a9b17f29c139
exposed:              True
exposed-modules:
    Mueval.ArgsParse Mueval.Context Mueval.Interpreter Mueval.Parallel
    Mueval.Resources

import-dirs:          /usr/lib/ghc-9.2.8/site-local/mueval-0.9.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/mueval-0.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mueval
hs-libraries:         HSmueval-0.9.3-KPB6EMVYSO8EM95XasFrG0
depends:
    Cabal-3.6.3.0 QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2
    base-4.16.4.0 containers-0.6.5.1 directory-1.3.6.2
    extensible-exceptions-0.1.1.4-D8VRIfPBfkhEPmMrxbU9lA
    filepath-1.4.2.2 hint-0.9.0.6-3cpIeNDt5rNIiy5nVqVNCS mtl-2.2.2
    process-1.6.16.0 show-0.6-G925yJ5M92E2Zn0nY7SUNz
    simple-reflect-0.3.3-6bzc2HjUkxQ8Qu7G3Z5hdc unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-mueval/html/mueval.haddock
haddock-html:         /usr/share/doc/haskell-mueval/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

