#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wreq
version:              0.5.4.3
visibility:           public
id:                   wreq-0.5.4.3-GpcTyWQmaoi8DCA0zi5YVK
key:                  wreq-0.5.4.3-GpcTyWQmaoi8DCA0zi5YVK
license:              BSD-3-Clause
copyright:            2014 Bryan O'\''Sullivan
maintainer:           bos@serpentine.com
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             http://www.serpentine.com/wreq
synopsis:             An easy-to-use HTTP client library.
description:
    .
    A web client library that is designed for ease of use.
    .
    Tutorial: <http://www.serpentine.com/wreq/tutorial.html>
    .
    Features include:
    .
    * Simple but powerful `lens`-based API
    .
    * A solid test suite, and built on reliable libraries like
      http-client and lens
    .
    * Session handling includes connection keep-alive and pooling, and
      cookie persistence
    .
    * Automatic response body decompression
    .
    * Powerful multipart form and file upload handling
    .
    * Support for JSON requests and responses, including navigation of
      schema-less responses
    .
    * Basic and OAuth2 bearer authentication
    .
    * Early TLS support via the tls package

category:             Web
abi:                  e7d8ab06848e89007e2166a550863c77
exposed:              True
exposed-modules:
    Network.Wreq Network.Wreq.Cache Network.Wreq.Cache.Store
    Network.Wreq.Lens Network.Wreq.Session Network.Wreq.Types

hidden-modules:
    Network.Wreq.Internal Network.Wreq.Internal.AWS
    Network.Wreq.Internal.Lens Network.Wreq.Internal.Link
    Network.Wreq.Internal.OAuth1 Network.Wreq.Internal.Types
    Network.Wreq.Lens.Machinery Network.Wreq.Lens.TH Paths_wreq

import-dirs:          /usr/lib/ghc-9.2.8/site-local/wreq-0.5.4.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/wreq-0.5.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wreq
hs-libraries:         HSwreq-0.5.4.3-GpcTyWQmaoi8DCA0zi5YVK
depends:
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI
    authenticate-oauth-1.7-8PuBR2zco8b6TFslr3qN75 base-4.16.4.0
    base16-bytestring-1.0.2.0-BfU7bG0tjnC37zYxX4slQA
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-3YsL0BQanAbLHEhUwcLo8j
    containers-0.6.5.1 crypton-0.34-1VPpUG8ba8hJMOLvG5BIhn
    exceptions-0.10.4 ghc-prim-0.8.0
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    http-client-0.7.17-2Oi6aYWRkvSIlsipbaKPwU
    http-client-tls-0.3.6.3-JOUTFtJTcAY3U5MOJvGMFy
    http-types-0.12.4-6kOruwBLItLEcotK7uAwKL
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7
    lens-aeson-1.2.3-Ch6mEKsVkOD3BIKGZvysVv
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    mime-types-0.1.2.0-4X5b6Sz1aAM6TugVqfWYtQ
    psqueues-0.2.8.0-857AP9ODns1DOEKz6NGYnM template-haskell-2.18.0.0
    text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF

haddock-interfaces:   /usr/share/doc/haskell-wreq/html/wreq.haddock
haddock-html:         /usr/share/doc/haskell-wreq/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

