/**
 * @typedef Options
 * @property {string} cwd
 * @property {string} [packageField]
 * @property {string} [pluginPrefix]
 * @property {string} [rcName]
 * @property {string} [rcPath]
 * @property {boolean} [detectConfig]
 * @property {ConfigTransform} [configTransform]
 * @property {Preset} [defaultConfig]
 * @property {Preset['settings']} [settings]
 * @property {Preset['plugins']} [plugins]
 */
export class Configuration {
  /**
   * @param {Options} options
   */
  constructor(options: Options)
  /** @type {string} */
  cwd: string
  /** @type {string|undefined} */
  packageField: string | undefined
  /** @type {string|undefined} */
  pluginPrefix: string | undefined
  /** @type {ConfigTransform|undefined} */
  configTransform: ConfigTransform | undefined
  /** @type {Preset|undefined} */
  defaultConfig: Preset | undefined
  /** @type {Preset} */
  given: Preset
  /**
   * @param {Buffer|undefined} buf
   * @param {string|undefined} filePath
   * @returns {Promise<Config|undefined>}
   */
  create(
    buf: Buffer | undefined,
    filePath: string | undefined
  ): Promise<Config | undefined>
  /** @type {FindUp<Config>} */
  findUp: FindUp<Config>
  /**
   * @param {string} filePath
   * @param {Callback} callback
   * @returns {void}
   */
  load(filePath: string, callback: Callback): void
}
export type FileSet = import('./file-set.js').FileSet
export type Plugin = import('unified').Plugin<[unknown, FileSet]>
export type PluginTuple = import('unified').PluginTuple<Array<unknown>>
export type PluggableList = import('unified').PluggableList
export type Settings = Record<string, unknown>
export type PluginIdObject = Record<string, Settings | null | undefined>
export type PluginIdList = Array<string | [string, ...Array<unknown>]>
export type Preset = {
  settings?: Settings | undefined
  plugins?:
    | Array<
        | Plugin
        | [
            import('unified').Plugin<
              unknown[],
              import('unist').Node<import('unist').Data>,
              import('unist').Node<import('unist').Data>
            >,
            ...unknown[]
          ]
        | Preset
        | string
        | [string, ...Array<unknown>]
      >
    | PluginIdObject
    | undefined
}
export type Config = {
  filePath: string | undefined
  settings: Settings
  plugins: Array<
    [
      import('unified').Plugin<
        unknown[],
        import('unist').Node<import('unist').Data>,
        import('unist').Node<import('unist').Data>
      >,
      ...unknown[]
    ]
  >
}
export type ConfigTransform = (config: any, filePath: string) => Preset
export type Loader = (
  buf: Buffer,
  filePath: string
) => Promise<Preset | undefined>
export type Callback = (
  error: Error | null,
  result?: Config | undefined
) => void
export type Options = {
  cwd: string
  packageField?: string | undefined
  pluginPrefix?: string | undefined
  rcName?: string | undefined
  rcPath?: string | undefined
  detectConfig?: boolean | undefined
  configTransform?: ConfigTransform | undefined
  defaultConfig?: Preset | undefined
  settings?: Preset['settings']
  plugins?: Preset['plugins']
}
import {FindUp} from './find-up.js'
