/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config.laf;

import com.ejt.internal.i18n.XHTMLFragment;
import com.ejt.internal.util.ToolTipHelpTextProvider;
import com.ejt.internal.util.XMLEnum;

public enum LookAndFeelType implements XMLEnum<LookAndFeelType>,
ToolTipHelpTextProvider
{
    CROSS_PLATFORM("crossPlatform", "FlatLaf cross platform Look and Feel", "The <a href=\"https://www.formdev.com/flatlaf/\">FlatLaf</a> cross platform Look and Feel is a modern Look and Feel that works well on all supported platforms and includes a dark mode.<p>Please consider starring it on <a href=\"https://github.com/JFormDesigner/FlatLaf\">GitHub</a> as a token of appreciation for the author.</p>"),
    NATIVE("native", "Java native Look and Feel", "Java includes a native look and feel that resembles native UI for a specific version of the operating system."),
    CUSTOM("custom", "Look and feel from custom code", null);

    private final String xmlValue;
    private final String verbose;
    @XHTMLFragment
    private final String helpText;

    public static LookAndFeelType getByName(String name, LookAndFeelType defaultValue) {
        if (name != null) {
            for (LookAndFeelType lookAndFeelType : LookAndFeelType.values()) {
                if (!lookAndFeelType.xmlValue.equals(name)) continue;
                return lookAndFeelType;
            }
        }
        return defaultValue;
    }

    private LookAndFeelType(@XHTMLFragment String xmlValue, String verbose, String helpText) {
        this.xmlValue = xmlValue;
        this.verbose = verbose;
        this.helpText = helpText;
    }

    @Override
    public String getToolTipHelpText() {
        return this.helpText;
    }

    @Override
    public String getXMLValue() {
        return this.xmlValue;
    }

    public LookAndFeelType[] getXMLEnums() {
        return LookAndFeelType.values();
    }

    public String toString() {
        return this.verbose;
    }
}

