/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.TabColorProvider;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class VsnetJideTabbedPaneUI
extends BasicJideTabbedPaneUI {
    protected Color _backgroundSelectedColorStart;
    protected Color _backgroundSelectedColorEnd;
    protected Color _backgroundUnselectedColorStart;
    protected Color _backgroundUnselectedColorEnd;

    public static ComponentUI createUI(JComponent c) {
        return new VsnetJideTabbedPaneUI();
    }

    @Override
    public void installColorTheme() {
        super.installColorTheme();
        int tabStyle = this.getTabShape();
        int colorTheme = this.getColorTheme();
        switch (tabStyle) {
            case 3: {
                if (colorTheme == 3) {
                    this._selectColor2 = this._selectColor1 = this._shadow;
                } else if (colorTheme == 4) {
                    this._selectColor2 = this._selectColor1 = UIDefaultsLookup.getColor("TextArea.selectionBackground");
                }
                this._unselectColor1 = this.getPainter().getControlShadow();
                this._unselectColor2 = this._lightHighlight;
                break;
            }
            case 8: {
                if (this._tabPane.getColorTheme() != 3) break;
                this._selectColor2 = null;
                this._selectColor3 = null;
                this._unselectColor2 = this._lightHighlight;
                this._unselectColor3 = this._shadow;
                break;
            }
            case 1: 
            case 11: {
                if (this._tabPane.getColorTheme() == 3) {
                    this._selectColor1 = this.getPainter().getTabbedPaneSelectDk();
                    this._selectColor2 = this.getPainter().getTabbedPaneSelectLt();
                    this._selectColor3 = this.getPainter().getControlDk();
                    this._unselectColor1 = this.getPainter().getControlDk();
                    this._unselectColor2 = null;
                    this._unselectColor3 = null;
                }
                if (this._tabPane.getColorTheme() != 4) break;
                this._selectColor1 = this.getPainter().getTabbedPaneSelectDk();
                this._selectColor2 = this.getPainter().getTabbedPaneSelectLt();
                this._selectColor3 = this.getPainter().getControlDk();
                this._unselectColor1 = this.getPainter().getControlDk();
                this._unselectColor2 = null;
                this._unselectColor3 = null;
            }
        }
        this.installBackgroundColor();
    }

    protected void installBackgroundColor() {
        int colorTheme = this.getColorTheme();
        switch (this.getTabShape()) {
            case 2: {
                this._backgroundSelectedColorStart = this._highlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = null;
                this._backgroundUnselectedColorEnd = null;
                break;
            }
            case 9: {
                if (colorTheme == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = null;
                    this._backgroundUnselectedColorEnd = null;
                    break;
                }
                this._backgroundSelectedColorStart = this._background;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = null;
                this._backgroundUnselectedColorEnd = null;
                break;
            }
            case 5: 
            case 10: {
                this._backgroundSelectedColorStart = this._highlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = this._highlight;
                this._backgroundUnselectedColorEnd = this._highlight;
                break;
            }
            case 3: {
                if (colorTheme == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = null;
                    this._backgroundUnselectedColorEnd = null;
                    break;
                }
                if (this._tabPane.getColorTheme() == 3) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = null;
                    this._backgroundUnselectedColorEnd = null;
                    break;
                }
                if (this._tabPane.getColorTheme() != 4) break;
                this._backgroundSelectedColorStart = this._lightHighlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = null;
                this._backgroundUnselectedColorEnd = null;
                break;
            }
            case 8: {
                if (this._tabPane.getColorTheme() == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = this._lightHighlight;
                    this._backgroundUnselectedColorEnd = this._lightHighlight;
                    break;
                }
                if (this._tabPane.getColorTheme() == 3) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = this._highlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                this._backgroundSelectedColorStart = this._lightHighlight;
                this._backgroundSelectedColorEnd = this._lightHighlight;
                this._backgroundUnselectedColorStart = this._lightHighlight;
                this._backgroundUnselectedColorEnd = this._highlight;
                break;
            }
            case 1: 
            case 11: {
                if (colorTheme == 3 || colorTheme == 4) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = this._lightHighlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                this._backgroundSelectedColorStart = this._highlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = this._highlight;
                this._backgroundUnselectedColorEnd = this._highlight;
                break;
            }
            case 4: {
                if (colorTheme == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = this._highlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                if (colorTheme == 4) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = this._lightHighlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                this._backgroundSelectedColorStart = this._lightHighlight;
                this._backgroundSelectedColorEnd = this._lightHighlight;
                this._backgroundUnselectedColorStart = this._lightHighlight;
                this._backgroundUnselectedColorEnd = this._highlight;
            }
        }
    }

    @Override
    public void uninstallColorTheme() {
        super.uninstallColorTheme();
        this._backgroundSelectedColorStart = null;
        this._backgroundSelectedColorEnd = null;
        this._backgroundUnselectedColorStart = null;
        this._backgroundUnselectedColorEnd = null;
    }

    @Override
    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        Color[] colors;
        super.paintTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
        if (this.tabRegion != null && (colors = this.getGradientColors(tabIndex, isSelected)) != null) {
            this.getPainter().paintTabBackground(this._tabPane, g2, this.tabRegion, colors, 0, 0);
        }
        if (this.getTabShape() == 11 && this._mouseEnter && tabIndex == this._indexMouseOver && !isSelected && this._tabPane.isEnabledAt(this._indexMouseOver)) {
            this.paintTabBackgroundMouseOver(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected, this._backgroundUnselectedColorStart, this._backgroundUnselectedColorEnd);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        if (selectedIndex < 0 || selectedIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(this._shadow);
            } else {
                g2.setColor(this._selectColor1);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y, x + w - 1, y);
            } else {
                g2.drawLine(x, y, selRect.x - selRect.height + 2, y);
                g2.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(this.getPainter().getControlShadow());
            }
            g2.drawLine(x, y, selRect.x - selRect.height / 2 + 4, y);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y, x + w - 1, y);
            } else if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                g2.drawLine(selRect.x + selRect.width + selRect.height / 2 - 4, y, x + w - 1, y);
            } else {
                g2.drawLine(selRect.x + selRect.width + selRect.height / 2 - 6, y, x + w - 1, y);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                g2.setColor(this.getPainter().getControlDk());
            } else {
                g2.setColor(this.getBorderEdgeColor());
            }
            if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                g2.drawLine(x, y, selRect.x - 1, y);
            } else {
                g2.drawLine(x, y, selRect.x - 1, y);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                    g2.setColor(this.getPainter().getControlDk());
                } else {
                    g2.setColor(this._lightHighlight);
                }
                g2.drawLine(x, y, x + w - 1, y);
            } else if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                g2.setColor(this.getPainter().getControlDk());
                g2.drawLine(selRect.x + selRect.width + 2, y, x + w - 1, y);
            } else {
                g2.setColor(this._lightHighlight);
                g2.drawLine(selRect.x + selRect.width + 2, y, x + w - 1, y);
            }
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(new Color(115, 109, 99));
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else {
                g2.setColor(this.getPainter().getControlDk());
                if (contentInsets.left > 0) {
                    g2.drawLine(x, y, x, y + h2 - 1);
                }
                if (contentInsets.right > 0) {
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
                }
                if (contentInsets.bottom > 0) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                }
            }
        } else if (tabShape == 2) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x, y, selRect.x, y);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.setColor(this._selectColor1);
                g2.drawLine(x, y, x + w - 1, y);
            } else {
                g2.setColor(this._selectColor2);
                g2.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                g2.setColor(this._selectColor1);
                g2.drawLine(selRect.x, y, selRect.x, y);
                g2.setColor(this._selectColor1);
                g2.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
            g2.setColor(this._selectColor2);
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 9) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x, y, selRect.x, y);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y, x + w - 1, y);
            } else {
                g2.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                g2.drawLine(selRect.x, y, selRect.x, y);
                g2.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
            g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h2 - 1);
            g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
        } else if (tabShape == 5 || tabShape == 10) {
            g2.setColor(this._shadow);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            g2.drawLine(x, y, selRect.x, y);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y, x + w - 1, y);
            } else {
                g2.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
        } else {
            super.paintContentBorderTopEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        if (selectedIndex < 0 || selectedIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(this._shadow);
            } else {
                g2.setColor(this._selectColor1);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else if (!this._tabPane.isTabShown()) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(x, y + h2 - 1, selRect.x - selRect.height + 2, y + h2 - 1);
                g2.drawLine(selRect.x + selRect.width, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(this.getPainter().getControlShadow());
            }
            g2.drawLine(x, y + h2 - 1, selRect.x - selRect.height / 2 + 4, y + h2 - 1);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                g2.drawLine(selRect.x + selRect.width + selRect.height / 2 - 4, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(selRect.x + selRect.width + selRect.height / 2 - 6, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(new Color(113, 111, 100));
                g2.drawLine(x, y + h2 - 1, selRect.x - 2, y + h2 - 1);
                if (contentInsets.right > 0) {
                    g2.drawLine(x + w - 1, y + h2 - 1, x + w - 1, y);
                }
                if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                } else {
                    g2.drawLine(selRect.x + selRect.width, y + h2 - 1, x + w - 1, y + h2 - 1);
                    g2.setColor(UIDefaultsLookup.getColor("control"));
                    g2.drawLine(selRect.x, y + h2 - 1, selRect.x + selRect.width - 2, y + h2 - 1);
                    g2.drawLine(selRect.x, y + h2 - 2, selRect.x + selRect.width, y + h2 - 2);
                }
                g2.setColor(new Color(255, 255, 255));
                if (contentInsets.left > 0) {
                    g2.drawLine(x, y, x, y + h2 - 2);
                }
                if (contentInsets.top > 0) {
                    g2.drawLine(x, y, x + w - 2, y);
                }
            } else {
                g2.setColor(this.getPainter().getControlDk());
                g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
                if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                } else {
                    g2.drawLine(selRect.x + selRect.width + 2, y + h2 - 1, x + w - 1, y + h2 - 1);
                }
                g2.drawLine(selRect.x - 1, y + h2 - 1, selRect.x - 1, y + h2 - 1);
                g2.drawLine(selRect.x + selRect.width + 2, y + h2 - 1, selRect.x + selRect.width + 2, y + h2 - 1);
                if (contentInsets.left > 0) {
                    g2.drawLine(x, y, x, y + h2 - 2);
                }
                if (contentInsets.top > 0) {
                    g2.drawLine(x, y, x + w - 2, y);
                }
                if (contentInsets.left > 0) {
                    g2.drawLine(x + w - 1, y + h2 - 1, x + w - 1, y);
                }
            }
        } else if (tabShape == 2) {
            g2.setColor(this._selectColor2);
            g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            g2.setColor(this._selectColor1);
            g2.drawLine(selRect.x, y + h2 - 1, selRect.x, y + h2 - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.setColor(this._selectColor2);
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else {
                g2.setColor(this._selectColor2);
                g2.drawLine(selRect.x + selRect.width - 1, y + h2 - 1, x + w - 2, y + h2 - 1);
            }
            g2.setColor(this._selectColor2);
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            g2.setColor(this._selectColor1);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 2);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 2, y);
            }
        } else if (tabShape == 9) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            g2.drawLine(selRect.x, y + h2 - 1, selRect.x, y + h2 - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(selRect.x + selRect.width - 1, y + h2 - 1, x + w - 2, y + h2 - 1);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 2);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 2, y);
            }
        } else if (tabShape == 5 || tabShape == 10) {
            g2.setColor(this._shadow);
            g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            g2.drawLine(selRect.x, y + h2 - 1, selRect.x, y + h2 - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y + h2 - 1, x + w - 2, y + h2 - 1);
            } else {
                g2.drawLine(selRect.x + selRect.width, y + h2 - 1, x + w - 2, y + h2 - 1);
            }
        } else {
            super.paintContentBorderBottomEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        if (selectedIndex < 0 || selectedIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(this._shadow);
            } else {
                g2.setColor(this._selectColor1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g2.drawLine(x, y, x, y + h2 - 1);
            } else {
                g2.drawLine(x, y, x, selRect.y - selRect.width + 2);
                g2.drawLine(x, selRect.y + selRect.height, x, y + h2 - 1);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(this.getPainter().getControlShadow());
            }
            g2.drawLine(x, y, x, selRect.y - selRect.width / 2 + 4);
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g2.drawLine(x, y, x, y + h2 - 1);
            } else {
                g2.drawLine(x, selRect.y + selRect.height + selRect.width / 2 - 4, x, y + h2 - 1);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(new Color(115, 109, 99));
                if (contentInsets.right > 0) {
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
                }
                if (contentInsets.bottom > 0) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                }
                g2.setColor(new Color(255, 255, 255));
                if (contentInsets.top > 0) {
                    g2.drawLine(x, y, x + w - 2, y);
                }
                g2.drawLine(x, y, x, selRect.y - 1);
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g2.drawLine(x, y, x, y + h2 - 2);
                } else {
                    g2.drawLine(x, selRect.y + selRect.height + 1, x, y + h2 - 2);
                }
            } else {
                g2.setColor(this.getPainter().getControlDk());
                if (contentInsets.top > 0) {
                    g2.drawLine(x, y, x + w - 1, y);
                }
                if (contentInsets.right > 0) {
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
                }
                if (contentInsets.bottom > 0) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                }
                g2.drawLine(x, y, x, selRect.y - 2);
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g2.drawLine(x, y, x, y + h2 - 2);
                } else {
                    g2.drawLine(x, selRect.y + selRect.height + 2, x, y + h2 - 2);
                }
            }
        } else if (tabShape == 2) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x, y, x, selRect.y);
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.setColor(this._selectColor1);
                g2.drawLine(x, y, x, y + h2 - 1);
            } else {
                g2.setColor(this._selectColor1);
                g2.drawLine(x, selRect.y, x, selRect.y);
                g2.setColor(this._selectColor2);
                g2.drawLine(x, selRect.y + selRect.height - 1, x, selRect.y + selRect.height - 1);
                g2.setColor(this._selectColor1);
                g2.drawLine(x, selRect.y + selRect.height, x, y + h2 - 1);
            }
            g2.setColor(this._selectColor2);
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 9) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x, y, x, selRect.y);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x, y, x, y + h2 - 1);
            } else {
                g2.drawLine(x, selRect.y, x, selRect.y);
                g2.drawLine(x, selRect.y + selRect.height - 1, x, selRect.y + selRect.height - 1);
                g2.drawLine(x, selRect.y + selRect.height, x, y + h2 - 1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 5 || tabShape == 10) {
            g2.setColor(this._shadow);
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            g2.drawLine(x, y, x, selRect.y);
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g2.drawLine(x, y, x, y + h2 - 1);
            } else {
                g2.drawLine(x, selRect.y + selRect.height, x, y + h2 - 1);
            }
        } else {
            super.paintContentBorderLeftEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        if (selectedIndex < 0 || selectedIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(this._shadow);
            } else {
                g2.setColor(this._selectColor1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(x + w - 1, y, x + w - 1, selRect.y - selRect.width + 2);
                g2.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(this.getPainter().getControlShadow());
            }
            g2.drawLine(x + w - 1, y, x + w - 1, selRect.y - selRect.width / 2 + 4);
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(x + w - 1, selRect.y + selRect.height + selRect.width / 2 - 4, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 1) {
                g2.setColor(new Color(115, 109, 99));
                g2.drawLine(x + w - 1, y, x + w - 1, selRect.y - 2);
                if (contentInsets.bottom > 0) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                }
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
                    g2.setColor(new Color(173, 170, 156));
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + h2 - 2);
                } else {
                    g2.drawLine(x + w - 1, selRect.y + selRect.height + 1, x + w - 1, y + h2 - 1);
                    g2.setColor(UIDefaultsLookup.getColor("control"));
                    g2.drawLine(x + w - 1, selRect.y, x + w - 1, selRect.y + selRect.height - 1);
                    g2.drawLine(x + w - 2, selRect.y, x + w - 2, selRect.y + selRect.height + 1);
                }
                g2.setColor(new Color(255, 255, 255));
                if (contentInsets.top > 0) {
                    g2.drawLine(x, y, x + w - 2, y);
                }
                if (contentInsets.left > 0) {
                    g2.drawLine(x, y, x, y + h2 - 2);
                }
            } else {
                g2.setColor(this.getPainter().getControlDk());
                if (contentInsets.top > 0) {
                    g2.drawLine(x, y, x + w - 1, y);
                }
                if (contentInsets.left > 0) {
                    g2.drawLine(x, y, x, y + h2 - 1);
                }
                if (contentInsets.bottom > 0) {
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                }
                g2.drawLine(x + w - 1, y, x + w - 1, selRect.y - 2);
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 2);
                } else {
                    g2.drawLine(x + w - 1, selRect.y + selRect.height + 2, x + w - 1, y + h2 - 2);
                }
            }
        } else if (tabShape == 2) {
            g2.setColor(this.getBorderEdgeColor());
            g2.setColor(this._selectColor2);
            g2.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            } else {
                g2.setColor(this._selectColor2);
                g2.drawLine(x + w - 1, selRect.y + selRect.height - 1, x + w - 1, selRect.y + selRect.height - 1);
                g2.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h2 - 1);
            }
            g2.setColor(this._selectColor1);
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 2, y);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 2);
            }
        } else if (tabShape == 9) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(x + w - 1, selRect.y, x + w - 1, selRect.y);
                g2.drawLine(x + w - 1, selRect.y + selRect.height - 1, x + w - 1, selRect.y + selRect.height - 1);
                g2.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h2 - 1);
            }
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 2);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        } else if (tabShape == 5 || tabShape == 10) {
            g2.setColor(this._shadow);
            if (contentInsets.top > 0) {
                g2.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g2.drawLine(x, y, x, y + h2 - 1);
            }
            if (contentInsets.bottom > 0) {
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
            g2.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            } else {
                g2.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h2 - 1);
            }
        } else {
            super.paintContentBorderRightEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g2, int x, int y, int w, int h2) {
        Color[] colors;
        Component comp;
        Insets insets = this.getContentBorderInsets(this._tabPane.getTabPlacement());
        Color backgroundAt = null;
        int selectedIndex = this._tabPane.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Component component = comp = selectedIndex == -1 ? null : this._tabPane.getComponentAt(selectedIndex);
        if (comp instanceof TabColorProvider) {
            backgroundAt = ((TabColorProvider)((Object)comp)).getTabBackground();
        }
        JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
        boolean useDefault = true;
        if (colorProvider != null || backgroundAt != null) {
            if (backgroundAt == null) {
                backgroundAt = this._tabPane.getBackground();
                if (selectedIndex != -1) {
                    backgroundAt = colorProvider.getBackgroundAt(selectedIndex);
                }
            }
            if (backgroundAt != null) {
                g2.setColor(backgroundAt);
                g2.fillRect(x, y, w, h2);
                useDefault = false;
            }
        }
        if (useDefault && (colors = this.getGradientColors(selectedIndex, true)) != null) {
            g2.setColor(colors[1]);
            g2.fillRect(x, y, w, insets.top);
            g2.fillRect(x, y, insets.left, h2);
            g2.fillRect(x, y + h2 - insets.bottom, w, insets.bottom);
            g2.fillRect(x + w - insets.right, y, insets.right, h2);
        }
    }

    protected Color[] getGradientColors(int tabIndex, boolean isSelected) {
        Color backgroundEnd = null;
        Color backgroundStart = null;
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            backgroundEnd = backgroundStart = isSelected ? UIDefaultsLookup.getColor("JideButton.selectedBackground") : UIDefaultsLookup.getColor("JideButton.background");
        } else {
            Color color = null;
            Component comp = null;
            if (tabIndex >= 0 && tabIndex < this._tabPane.getTabCount()) {
                comp = this._tabPane.getComponentAt(tabIndex);
            }
            if (comp instanceof TabColorProvider) {
                color = ((TabColorProvider)((Object)comp)).getTabBackground();
            }
            JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
            if (color == null && colorProvider != null) {
                backgroundEnd = colorProvider.getBackgroundAt(tabIndex);
                backgroundStart = colorProvider instanceof JideTabbedPane.GradientColorProvider ? ((JideTabbedPane.GradientColorProvider)colorProvider).getTopBackgroundAt(tabIndex) : (backgroundEnd != null ? ColorUtils.getDerivedColor(backgroundEnd, colorProvider.getGradientRatio(tabIndex)) : null);
            } else {
                if (color == null) {
                    color = this._tabPane.getBackground();
                    if (tabIndex != -1) {
                        color = this._tabPane.getBackgroundAt(tabIndex);
                    }
                }
                if (!(color instanceof UIResource) && color != this._tabPane.getBackground()) {
                    backgroundEnd = color;
                    backgroundStart = this.getColorTheme() == 2 ? ColorUtils.getDerivedColor(color, 0.8f) : color;
                }
            }
            if (isSelected) {
                if (this.showFocusIndicator()) {
                    if (backgroundEnd == null) {
                        backgroundEnd = this._backgroundSelectedColorEnd;
                    }
                    if (backgroundStart == null) {
                        backgroundStart = this._backgroundSelectedColorStart;
                    }
                } else if (this.getColorTheme() == 3) {
                    if (backgroundEnd == null) {
                        backgroundEnd = this._backgroundSelectedColorEnd;
                    }
                    if (backgroundStart == null) {
                        backgroundStart = this._backgroundSelectedColorStart;
                    }
                } else {
                    if (backgroundEnd == null) {
                        backgroundEnd = ColorUtils.getDerivedColor(this._backgroundUnselectedColorEnd, 0.7f);
                    }
                    if (backgroundStart == null) {
                        backgroundStart = ColorUtils.getDerivedColor(this._backgroundUnselectedColorStart, 0.8f);
                    }
                }
            } else if (this.getTabShape() != 11) {
                if (backgroundEnd == null) {
                    backgroundEnd = this._backgroundUnselectedColorEnd;
                }
                if (backgroundStart == null) {
                    backgroundStart = this._backgroundUnselectedColorStart;
                }
            }
        }
        return new Color[]{backgroundStart, backgroundEnd};
    }
}

