/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.filmInformation;

import com.formdev.flatlaf.util.ScaledImageIcon;
import com.jidesoft.swing.MultilineLabel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mediathek.daten.DatenFilm;
import mediathek.daten.abo.DatenAbo;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 (2\u00020\u0001:\u0003()*B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u001fH\u0002J\u0006\u0010$\u001a\u00020\u001fJ\u0010\u0010%\u001a\u00020\u001f2\b\u0010&\u001a\u0004\u0018\u00010\fJ\b\u0010'\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lmediathek/gui/filmInformation/InfoDialog;", "Ljavax/swing/JDialog;", "parent", "Ljava/awt/Window;", "(Ljava/awt/Window;)V", "cbHq", "Lmediathek/gui/filmInformation/InfoDialog$SwingDisabledCheckBox;", "cbSubtitle", "config", "Lorg/apache/commons/configuration2/Configuration;", "kotlin.jvm.PlatformType", "currentFilm", "Lmediathek/daten/DatenFilm;", "descScrollPane", "Ljavax/swing/JScrollPane;", "hyperlink", "Lmediathek/gui/filmInformation/InfoDialog$SwingHyperlink;", "lblAbo", "Ljavax/swing/JLabel;", "lblDate", "lblDescription", "Ljavax/swing/JTextArea;", "lblDuration", "lblGeo", "lblSender", "lblSize", "lblThema", "Lcom/jidesoft/swing/MultilineLabel;", "lblTitel", "lblUhrzeit", "buildLayout", "", "checkedPack", "clearControls", "restoreLocation", "saveLocation", "showInfo", "updateCurrentFilm", "film", "updateTextFields", "Companion", "SwingDisabledCheckBox", "SwingHyperlink", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nInfoDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfoDialog.kt\nmediathek/gui/filmInformation/InfoDialog\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,332:1\n107#2:333\n79#2,22:334\n*S KotlinDebug\n*F\n+ 1 InfoDialog.kt\nmediathek/gui/filmInformation/InfoDialog\n*L\n161#1:333\n161#1:334,22\n*E\n"})
public final class InfoDialog
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    @Nullable
    private DatenFilm currentFilm;
    @NotNull
    private final JLabel lblSender = new JLabel();
    @NotNull
    private final MultilineLabel lblThema = new MultilineLabel();
    @NotNull
    private final MultilineLabel lblTitel = new MultilineLabel();
    @NotNull
    private final JLabel lblDate = new JLabel();
    @NotNull
    private final JLabel lblUhrzeit = new JLabel();
    @NotNull
    private final JLabel lblDuration = new JLabel();
    @NotNull
    private final JLabel lblSize = new JLabel();
    @NotNull
    private final JLabel lblGeo = new JLabel();
    @NotNull
    private final SwingDisabledCheckBox cbHq = new SwingDisabledCheckBox();
    @NotNull
    private final SwingDisabledCheckBox cbSubtitle = new SwingDisabledCheckBox();
    @NotNull
    private final JLabel lblAbo = new JLabel();
    @NotNull
    private final SwingHyperlink hyperlink = new SwingHyperlink();
    @NotNull
    private final JScrollPane descScrollPane = new JScrollPane();
    @NotNull
    private final JTextArea lblDescription = new JTextArea();
    @NotNull
    private static final Dimension DEFAULT_SENDER_DIMENSION = new Dimension(64, 64);

    public InfoDialog(@Nullable Window parent) {
        super(parent);
        this.setType(Window.Type.UTILITY);
        this.setTitle("Filminformation");
        if (!SystemUtils.IS_OS_LINUX) {
            this.setResizable(false);
        }
        this.setDefaultCloseOperation(2);
        this.buildLayout();
        this.checkedPack();
        if (SystemUtils.IS_OS_LINUX) {
            Dimension linuxSize = new Dimension(350, 450);
            this.setSize(linuxSize.width, linuxSize.height);
            this.setMinimumSize(linuxSize);
            this.setPreferredSize(linuxSize);
            this.setMaximumSize(linuxSize);
        }
        this.updateTextFields();
        this.restoreLocation();
        this.setVisible(this.config.getBoolean("film.information.visible", false));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                config.setProperty("film.information.visible", true);
            }

            @Override
            public void windowClosed(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                config.setProperty("film.information.visible", false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.saveLocation();
            }

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (this.isVisible()) {
                    this.saveLocation();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restoreLocation() {
        this.config.lock(LockMode.READ);
        try {
            Point newLocation = new Point();
            newLocation.x = this.config.getInt("film.information.location.x");
            newLocation.y = this.config.getInt("film.information.location.y");
            this.setLocation(newLocation);
            if (SystemUtils.IS_OS_LINUX) {
                int w = this.config.getInt("film.information.location.width");
                int h2 = this.config.getInt("film.information.location.height");
                if (w > 50 && h2 > 50) {
                    this.setSize(new Dimension(w, h2));
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        this.config.lock(LockMode.WRITE);
        try {
            Point location = this.getLocationOnScreen();
            this.config.setProperty("film.information.location.x", location.x);
            this.config.setProperty("film.information.location.y", location.y);
            if (SystemUtils.IS_OS_LINUX) {
                this.config.setProperty("film.information.location.width", this.getWidth());
                this.config.setProperty("film.information.location.height", this.getHeight());
            }
        }
        finally {
            this.config.unlock(LockMode.WRITE);
        }
    }

    public final void showInfo() {
        this.updateTextFields();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private final void clearControls() {
        this.lblThema.setText("");
        this.lblSender.setText("");
        this.lblSender.setIcon(null);
        this.lblTitel.setText("");
        this.lblDate.setText("");
        this.lblUhrzeit.setText("");
        this.lblDuration.setText("");
        this.lblSender.setText("");
        this.lblGeo.setText("");
        this.cbHq.setSelected(false);
        this.cbSubtitle.setSelected(false);
        this.lblAbo.setText("");
        this.hyperlink.setToolTipText("");
        this.hyperlink.setEnabled(false);
        this.lblDescription.setText("");
        SwingUtilities.invokeLater(() -> InfoDialog.clearControls$lambda$0(this));
    }

    private final void updateTextFields() {
        if (this.currentFilm == null) {
            this.clearControls();
        } else {
            DatenFilm datenFilm = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm);
            String string = datenFilm.getSender();
            Intrinsics.checkNotNullExpressionValue(string, "currentFilm!!.sender");
            MVSenderIconCache.get(string).ifPresent(arg_0 -> InfoDialog.updateTextFields$lambda$1(new Function1<ImageIcon, Unit>(this){
                final /* synthetic */ InfoDialog this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable ImageIcon icon) {
                    InfoDialog.access$getLblSender$p(this.this$0).setText("");
                    ImageIcon imageIcon = icon;
                    Intrinsics.checkNotNull(imageIcon);
                    Dimension imageDim = new Dimension(imageIcon.getIconWidth(), icon.getIconHeight());
                    Dimension destDim = GuiFunktionen.calculateFittedDimension(imageDim, InfoDialog.access$getDEFAULT_SENDER_DIMENSION$cp());
                    InfoDialog.access$getLblSender$p(this.this$0).setIcon(new ScaledImageIcon(icon, destDim.width, destDim.height));
                }
            }, arg_0));
            DatenFilm datenFilm2 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm2);
            this.lblThema.setText(datenFilm2.getThema());
            DatenFilm datenFilm3 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm3);
            this.lblTitel.setText(datenFilm3.getTitle());
            DatenFilm datenFilm4 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm4);
            this.lblDate.setText(datenFilm4.getSendeDatum());
            DatenFilm datenFilm5 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm5);
            this.lblUhrzeit.setText(datenFilm5.getSendeZeit());
            DatenFilm datenFilm6 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm6);
            this.lblDuration.setText(datenFilm6.getFilmLengthAsString());
            DatenFilm datenFilm7 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm7);
            this.lblSize.setText(datenFilm7.getFileSize().toString());
            DatenFilm datenFilm8 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm8);
            if (datenFilm8.countrySet.isEmpty()) {
                this.lblGeo.setText("");
            } else {
                DatenFilm datenFilm9 = this.currentFilm;
                Intrinsics.checkNotNull(datenFilm9);
                this.lblGeo.setText(datenFilm9.countrySet.stream().map(arg_0 -> InfoDialog.updateTextFields$lambda$2(updateTextFields.2.INSTANCE, arg_0)).collect(Collectors.joining("-")));
            }
            DatenFilm datenFilm10 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm10);
            this.cbHq.setSelected(datenFilm10.isHighQuality());
            DatenFilm datenFilm11 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm11);
            this.cbSubtitle.setSelected(datenFilm11.hasSubtitle());
            DatenFilm datenFilm12 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm12);
            DatenAbo datenAbo = datenFilm12.getAbo();
            this.lblAbo.setText(datenAbo != null ? datenAbo.getName() : null);
            this.hyperlink.setEnabled(true);
            DatenFilm datenFilm13 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm13);
            this.hyperlink.setToolTipText(datenFilm13.getWebsiteUrl());
            this.hyperlink.setClicked(false);
            DatenFilm datenFilm14 = this.currentFilm;
            Intrinsics.checkNotNull(datenFilm14);
            String string2 = datenFilm14.getDescription();
            Intrinsics.checkNotNullExpressionValue(string2, "currentFilm!!.description");
            String $this$trim$iv = string2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String desc = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            this.lblDescription.setText(desc);
            SwingUtilities.invokeLater(() -> InfoDialog.updateTextFields$lambda$4(this));
        }
    }

    public final void updateCurrentFilm(@Nullable DatenFilm film) {
        this.currentFilm = film;
        if (this.isVisible()) {
            this.updateTextFields();
        }
    }

    private final void buildLayout() {
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3), new AC().fill().gap().size("250!").fill(), new AC().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap()));
        int[] nArray = new int[]{0, 0};
        this.add((Component)new JLabel("Sender:"), new CC().cell(nArray));
        nArray = new int[]{1, 0};
        this.add((Component)this.lblSender, new CC().cell(nArray));
        nArray = new int[]{0, 1};
        this.add((Component)new JLabel("Thema:"), new CC().cell(nArray));
        this.lblThema.setLineWrap(true);
        nArray = new int[]{1, 1};
        this.add((Component)this.lblThema, new CC().cell(nArray).growY());
        nArray = new int[]{0, 2};
        this.add((Component)new JLabel("Titel:"), new CC().cell(nArray));
        this.lblTitel.setLineWrap(true);
        nArray = new int[]{1, 2};
        this.add((Component)this.lblTitel, new CC().cell(nArray).growY());
        nArray = new int[]{0, 3};
        this.add((Component)new JLabel("Datum:"), new CC().cell(nArray));
        nArray = new int[]{1, 3};
        this.add((Component)this.lblDate, new CC().cell(nArray));
        nArray = new int[]{0, 4};
        this.add((Component)new JLabel("Uhrzeit:"), new CC().cell(nArray));
        nArray = new int[]{1, 4};
        this.add((Component)this.lblUhrzeit, new CC().cell(nArray));
        nArray = new int[]{0, 5};
        this.add((Component)new JLabel("Dauer:"), new CC().cell(nArray));
        nArray = new int[]{1, 5};
        this.add((Component)this.lblDuration, new CC().cell(nArray));
        nArray = new int[]{0, 6};
        this.add((Component)new JLabel("Gr\u00f6\u00dfe (MB):"), new CC().cell(nArray));
        nArray = new int[]{1, 6};
        this.add((Component)this.lblSize, new CC().cell(nArray));
        nArray = new int[]{0, 7};
        this.add((Component)new JLabel("HQ:"), new CC().cell(nArray));
        nArray = new int[]{1, 7};
        this.add((Component)this.cbHq, new CC().cell(nArray));
        nArray = new int[]{0, 8};
        this.add((Component)new JLabel("Untertitel:"), new CC().cell(nArray));
        nArray = new int[]{1, 8};
        this.add((Component)this.cbSubtitle, new CC().cell(nArray));
        nArray = new int[]{0, 9};
        this.add((Component)new JLabel("Geo:"), new CC().cell(nArray));
        nArray = new int[]{1, 9};
        this.add((Component)this.lblGeo, new CC().cell(nArray));
        nArray = new int[]{0, 10};
        this.add((Component)new JLabel("Abo:"), new CC().cell(nArray));
        nArray = new int[]{1, 10};
        this.add((Component)this.lblAbo, new CC().cell(nArray));
        nArray = new int[]{0, 11};
        this.add((Component)this.hyperlink, new CC().cell(nArray).spanX(2));
        nArray = new int[]{0, 12};
        this.add((Component)new JLabel("Beschreibung:"), new CC().cell(nArray));
        this.lblDescription.setEditable(false);
        this.lblDescription.setLineWrap(true);
        this.lblDescription.setWrapStyleWord(true);
        this.descScrollPane.setViewportView(this.lblDescription);
        nArray = new int[]{0, 13};
        this.add((Component)this.descScrollPane, new CC().cell(nArray).spanX(2).growY().growX().height("90!"));
    }

    private final void checkedPack() {
        if (!SystemUtils.IS_OS_LINUX) {
            this.pack();
        }
    }

    private static final void clearControls$lambda$0(InfoDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.checkedPack();
    }

    private static final void updateTextFields$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String updateTextFields$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void updateTextFields$lambda$4(InfoDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.descScrollPane.getVerticalScrollBar().setValue(0);
        this$0.checkedPack();
    }

    public static final /* synthetic */ JLabel access$getLblSender$p(InfoDialog $this) {
        return $this.lblSender;
    }

    public static final /* synthetic */ Dimension access$getDEFAULT_SENDER_DIMENSION$cp() {
        return DEFAULT_SENDER_DIMENSION;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$Companion;", "", "()V", "DEFAULT_SENDER_DIMENSION", "Ljava/awt/Dimension;", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$SwingDisabledCheckBox;", "Ljavax/swing/JCheckBox;", "()V", "MediathekView"})
    public static final class SwingDisabledCheckBox
    extends JCheckBox {
        public SwingDisabledCheckBox() {
            this.setEnabled(false);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$SwingHyperlink;", "Lorg/jdesktop/swingx/JXHyperlink;", "()V", "openUrl", "", "url", "", "MediathekView"})
    public static final class SwingHyperlink
    extends JXHyperlink {
        public SwingHyperlink() {
            this.setText("Link zur Webseite");
            this.addActionListener(arg_0 -> SwingHyperlink._init_$lambda$0(this, arg_0));
        }

        private final void openUrl(String url) {
            try {
                UrlHyperlinkAction.openURL(null, url);
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }

        private static final void _init_$lambda$0(SwingHyperlink this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            String string = this$0.getToolTipText();
            Intrinsics.checkNotNullExpressionValue(string, "toolTipText");
            if (((CharSequence)string).length() > 0) {
                if (Desktop.isDesktopSupported()) {
                    Desktop d = Desktop.getDesktop();
                    if (d.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            d.browse(new URI(this$0.getToolTipText()));
                        }
                        catch (Exception ex) {
                            SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Es trat ein Fehler beim \u00d6ffnen des Links auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                        }
                    } else {
                        String string2 = this$0.getToolTipText();
                        Intrinsics.checkNotNullExpressionValue(string2, "toolTipText");
                        this$0.openUrl(string2);
                    }
                } else {
                    String string3 = this$0.getToolTipText();
                    Intrinsics.checkNotNullExpressionValue(string3, "toolTipText");
                    this$0.openUrl(string3);
                }
            }
        }
    }
}

