/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import java.util.Comparator;

public final class Sorting {
    private static final int SMALLSORT = 16;

    public static void insertionSort(Object[] a, Comparator<Object> cmp) {
        Sorting.insertionSort(a, 0, a.length - 1, cmp);
    }

    public static void insertionSort(Object[] a, int start, int end, Comparator<Object> cmp) {
        for (int i = start; i <= end; ++i) {
            Object x = a[i];
            for (int j = i - 1; j >= start && cmp.compare(a[j], x) > 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = x;
        }
    }

    public static void hybridSort(Object[] a, Comparator<Object> cmp) {
        Sorting.hybridSort(a, 0, a.length - 1, cmp, Sorting.log2(a.length) * 2);
    }

    private static void hybridSort(Object[] a, int start, int end, Comparator<Object> cmp, int maxdepth) {
        if (start < end) {
            if (maxdepth == 0 || end - start <= 16) {
                Sorting.insertionSort(a, start, end, cmp);
            } else {
                int p = Sorting.partition(a, start, end, cmp);
                Sorting.hybridSort(a, start, p, cmp, maxdepth - 1);
                Sorting.hybridSort(a, p + 1, end, cmp, maxdepth - 1);
            }
        }
    }

    private static int partition(Object[] a, int start, int end, Comparator<Object> cmp) {
        Object pivot = a[Sorting.median(start, end, start + (end - start) / 2)];
        int i = start - 1;
        int j = end + 1;
        while (true) {
            if (cmp.compare(a[++i], pivot) < 0) {
                continue;
            }
            while (cmp.compare(a[--j], pivot) > 0) {
            }
            if (i >= j) {
                return j;
            }
            Sorting.swap(a, i, j);
        }
    }

    private static void swap(Object[] a, int l, int h) {
        Object tmp = a[l];
        a[l] = a[h];
        a[h] = tmp;
    }

    private static int log2(int n) {
        return (int)(Math.log10(n) / Math.log10(2.0));
    }

    private static int median(int n1, int n2, int n3) {
        int[] a = new int[]{n1, n2, n3};
        Arrays.sort(a);
        return a[1];
    }
}

