/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

import com.github.jgonian.ipmath.AbstractRange;
import com.github.jgonian.ipmath.Ipv6;
import com.github.jgonian.ipmath.Ipv6Range;
import com.github.jgonian.ipmath.Optional;
import com.github.jgonian.ipmath.PrefixFinder;
import com.github.jgonian.ipmath.PrefixUtils;
import java.math.BigInteger;
import java.util.Collection;

public class ConservativePrefixFinder
extends PrefixFinder {
    public static ConservativePrefixFinder newInstance() {
        return new ConservativePrefixFinder();
    }

    private ConservativePrefixFinder() {
        super(new ConservativeStrategy());
    }

    private static class ConservativeStrategy
    implements PrefixFinder.Strategy {
        private ConservativeStrategy() {
        }

        @Override
        public Ipv6Range findPrefixOrNull(int prefixLength, Collection<Ipv6Range> ranges) {
            BigInteger desiredPrefixSize = BigInteger.valueOf(2L).pow(128 - prefixLength);
            AbstractRange foundPrefix = null;
            BigInteger currentSize = null;
            for (Ipv6Range freeBlock : ranges) {
                Optional<Ipv6Range> smallestPrefix;
                if (freeBlock.size().compareTo(desiredPrefixSize) < 0 || !(smallestPrefix = PrefixUtils.findMinimumPrefixForPrefixLength(freeBlock, prefixLength)).isPresent()) continue;
                Ipv6Range candidatePrefix = smallestPrefix.get();
                BigInteger candidateSize = candidatePrefix.size();
                if (foundPrefix != null && candidateSize.compareTo(currentSize) >= 0) continue;
                foundPrefix = candidatePrefix;
                currentSize = candidateSize;
            }
            return foundPrefix == null ? null : Ipv6Range.from((Ipv6)foundPrefix.start()).andPrefixLength(prefixLength);
        }
    }
}

