/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.optimizer.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.pattern.CapturePattern;
import com.facebook.presto.matching.pattern.WithPattern;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;

public class EvalPushDown<T extends LogicalPlan>
implements Rule<T> {
    public static final Rule<LogicalLimit> PUSH_DOWN_LIMIT = EvalPushDownBuilder.match(Patterns.limit(Patterns.evalCapture())).apply((limit, logicalEval) -> {
        List<LogicalPlan> child = logicalEval.getChild();
        limit.replaceChildPlans(child);
        logicalEval.replaceChildPlans(List.of(limit));
        return logicalEval;
    });
    private final Capture<LogicalEval> capture;
    private final Pattern<T> pattern;
    private final BiFunction<T, LogicalEval, LogicalPlan> pushDownFunction;

    public EvalPushDown(WithPattern<T> pattern, BiFunction<T, LogicalEval, LogicalPlan> pushDownFunction) {
        this.pattern = pattern;
        this.capture = ((CapturePattern)pattern.getPattern()).capture();
        this.pushDownFunction = pushDownFunction;
    }

    @Override
    public LogicalPlan apply(T plan, Captures captures) {
        LogicalEval logicalEval = (LogicalEval)captures.get(this.capture);
        return this.pushDownFunction.apply(plan, logicalEval);
    }

    @Override
    @Generated
    public Pattern<T> pattern() {
        return this.pattern;
    }

    static class EvalPushDownBuilder<T extends LogicalPlan> {
        private WithPattern<T> pattern;

        EvalPushDownBuilder() {
        }

        public static <T extends LogicalPlan> EvalPushDownBuilder<T> match(Pattern<T> pattern) {
            EvalPushDownBuilder<T> builder = new EvalPushDownBuilder<T>();
            builder.pattern = (WithPattern)pattern;
            return builder;
        }

        public EvalPushDown<T> apply(BiFunction<T, LogicalEval, LogicalPlan> pushDownFunction) {
            return new EvalPushDown<T>(this.pattern, pushDownFunction);
        }
    }
}

