/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.grok;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrokUtils {
    public static final Pattern GROK_PATTERN = Pattern.compile("%\\{(?<name>(?<pattern>[a-zA-Z0-9_]+)(?::(?<subname>[a-zA-Z0-9_:;,\\-\\/\\s\\.']+))?)(?:=(?<definition>(?:(?:[^{}]+|\\.+)+)+))?\\}");
    public static final Pattern NAMED_REGEX = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");

    public static Set<String> getNameGroups(String regex) {
        LinkedHashSet<String> namedGroups = new LinkedHashSet<String>();
        Matcher matcher = NAMED_REGEX.matcher(regex);
        while (matcher.find()) {
            namedGroups.add(matcher.group(1));
        }
        return namedGroups;
    }

    public static Map<String, String> namedGroups(Matcher matcher, Set<String> groupNames) {
        LinkedHashMap<String, String> namedGroups = new LinkedHashMap<String, String>();
        for (String groupName : groupNames) {
            String groupValue = matcher.group(groupName);
            namedGroups.put(groupName, groupValue);
        }
        return namedGroups;
    }
}

