/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.sourceforge.plantuml.chronology.ChronologyDiagram;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementHour
implements Something<ChronologyDiagram> {
    private static final SimpleDateFormat inputFormat;
    private static final SimpleDateFormat inputFormat2;

    @Override
    public IRegex toRegex(String suffix) {
        return new RegexConcat(new RegexLeaf("TIME", "(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+)"), new RegexOptional((IRegex)new RegexLeaf("MS", "\\.(\\d+)")));
    }

    @Override
    public Failable<Day> getMe(ChronologyDiagram system, RegexResult arg, String suffix) {
        String value = arg.get("TIME", 0);
        System.err.println("value=" + value);
        try {
            Date date = inputFormat.parse(value);
            return Failable.ok(Day.create(date.getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    static {
        inputFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        inputFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

