/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.List;
import net.sourceforge.plantuml.cucadiagram.SquareLinker;

class SquareMaker<O> {
    SquareMaker() {
    }

    public void putInSquare(List<O> data, SquareLinker<O> linker) {
        int branch = SquareMaker.computeBranch(data.size());
        int headBranch = 0;
        for (int i = 1; i < data.size(); ++i) {
            O ent1;
            int dist = i - headBranch;
            O ent2 = data.get(i);
            if (dist == branch) {
                ent1 = data.get(headBranch);
                linker.topDown(ent1, ent2);
                headBranch = i;
                continue;
            }
            ent1 = data.get(i - 1);
            linker.leftRight(ent1, ent2);
        }
    }

    static int computeBranch(int size) {
        double sqrt = Math.sqrt(size);
        int r = (int)sqrt;
        if (r * r == size) {
            return r;
        }
        return r + 1;
    }

    static int getBottomLeft(int size) {
        int s2 = SquareMaker.computeBranch(size);
        int line = (size - 1) / s2;
        return line * s2;
    }
}

