/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Neutron;
import net.sourceforge.plantuml.klimt.creole.NeutronType;
import net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomTextUtils;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.text.BackSlash;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.CharHidder;
import net.sourceforge.plantuml.utils.Log;

public final class AtomText
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final String text;
    private final DelayedDouble marginLeft;
    private final DelayedDouble marginRight;
    private final Url url;
    private final boolean manageSpecialChars;

    protected AtomText(String text, FontConfiguration style, Url url, DelayedDouble marginLeft, DelayedDouble marginRight, boolean manageSpecialChars) {
        if (text.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(text);
        }
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        String s2 = CharHidder.unhide(text);
        if (manageSpecialChars) {
            s2 = StringUtils.showComparatorCharacters(s2);
            s2 = StringUtils.manageAmpDiese(s2);
            s2 = StringUtils.manageUnicodeNotationUplus(s2);
            s2 = StringUtils.manageTildeArobaseStart(s2);
            s2 = StringUtils.manageEscapedTabs(s2);
        }
        this.manageSpecialChars = manageSpecialChars;
        this.text = s2;
        this.fontConfiguration = style;
        this.url = url;
    }

    private AtomText withText(String text) {
        return new AtomText(text, this.fontConfiguration, this.url, this.marginLeft, this.marginRight, this.manageSpecialChars);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h2 = rect.getHeight();
        if (h2 < 10.0) {
            h2 = 10.0;
        }
        double width = this.text.indexOf("\t") == -1 || stringBounder.matchesProperty("TIKZ") ? rect.getWidth() : this.getWidth(stringBounder, this.text);
        double left = this.marginLeft.getDouble(stringBounder);
        double right = this.marginRight.getDouble(stringBounder);
        return new XDimension2D(width + left + right, h2);
    }

    public double getFontHeight(StringBounder stringBounder) {
        XDimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        double descent = stringBounder.getDescent(this.fontConfiguration.getFont(), this.text);
        return rect.getHeight() - descent;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (ug.matchesProperty("SPECIALTXT")) {
            ug.draw(this);
        } else {
            HColor textColor = this.fontConfiguration.getColor();
            FontConfiguration useFontConfiguration = this.fontConfiguration;
            HColor backcolor = ug.getParam().getBackcolor();
            if (backcolor.isTransparent()) {
                backcolor = ug.getDefaultBackground();
            }
            textColor = textColor.getAppropriateColor(backcolor);
            useFontConfiguration = this.fontConfiguration.changeColor(textColor);
            if (this.marginLeft != AtomTextUtils.ZERO) {
                ug = ug.apply(UTranslate.dx(this.marginLeft.getDouble(ug.getStringBounder())));
            }
            StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
            XDimension2D rect = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), this.text);
            double descent = this.getDescent(ug.getStringBounder());
            double ypos = rect.getHeight() - descent;
            double x = 0.0;
            if (tokenizer.hasMoreTokens()) {
                double tabSize = this.getTabSize(ug.getStringBounder());
                while (tokenizer.hasMoreTokens()) {
                    String s2 = tokenizer.nextToken();
                    if (s2.equals("\t")) {
                        double remainder = x % tabSize;
                        x += tabSize - remainder;
                        continue;
                    }
                    XDimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s2);
                    UText utext = UText.build(s2, useFontConfiguration);
                    ug.apply(new UTranslate(x, ypos)).draw(utext);
                    x += dim.getWidth();
                }
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getWidth(StringBounder stringBounder, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s2 = tokenizer.nextToken();
            if (s2.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            XDimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s2);
            x += dim.getWidth();
        }
        return x;
    }

    private String tabString() {
        int nb = this.fontConfiguration.getTabSize();
        if (nb >= 1 && nb < 7) {
            return "        ".substring(0, nb);
        }
        return "        ";
    }

    private double getDescent(StringBounder stringBounder) {
        return stringBounder.getDescent(this.fontConfiguration.getFont(), this.text);
    }

    private double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.tabString()).getWidth();
    }

    @Override
    public final List<Neutron> getNeutrons() {
        ArrayList<Neutron> result = new ArrayList<Neutron>();
        StringBuilder pending = new StringBuilder();
        for (int i = 0; i < this.text.length(); ++i) {
            NeutronType currentType;
            char ch = this.text.charAt(i);
            if (pending.length() == 0) {
                pending.append(ch);
                continue;
            }
            NeutronType pendingType = Neutron.getNeutronTypeFromChar(pending.charAt(0));
            if (pendingType != (currentType = Neutron.getNeutronTypeFromChar(ch))) {
                this.addPending(result, pending.toString());
                pending.setLength(0);
            }
            pending.append(ch);
            if (!Neutron.isChineseSentenceBoundary(ch)) continue;
            this.addPending(result, pending.toString());
            pending.setLength(0);
            result.add(Neutron.zwspSeparator());
        }
        if (pending.length() > 0) {
            this.addPending(result, pending.toString());
        }
        return result;
    }

    private void addPending(List<Neutron> result, String pending) {
        Neutron tmp = Neutron.create(this.withText(pending));
        if (tmp.getType() == NeutronType.SPACE) {
            result.add(Neutron.zwspSeparator());
        }
        result.add(tmp);
        if (tmp.getType() == NeutronType.SPACE) {
            result.add(Neutron.zwspSeparator());
        }
    }

    public final String getText() {
        return this.text;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.fontConfiguration.getSpace();
    }

    public String toString() {
        return this.text + " " + this.fontConfiguration;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    protected static interface DelayedDouble {
        public double getDouble(StringBounder var1);
    }
}

