/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.webp.Globals;

public class BoolDecoder {
    int bit_count;
    ImageInputStream data;
    private long offset;
    private int range;
    private int value;

    BoolDecoder(ImageInputStream frame, long offset) throws IOException {
        this.data = frame;
        this.offset = offset;
        this.initBoolDecoder();
    }

    private void initBoolDecoder() throws IOException {
        this.value = 0;
        this.data.seek(this.offset);
        this.value = this.data.readUnsignedByte() << 8;
        ++this.offset;
        this.range = 255;
        this.bit_count = 0;
    }

    public int readBit() throws IOException {
        return this.readBool(128);
    }

    public int readBool(int probability) throws IOException {
        int bit = 0;
        int range = this.range;
        int value = this.value;
        int split = 1 + ((range - 1) * probability >> 8);
        int bigsplit = split << 8;
        range = split;
        if (value >= bigsplit) {
            range = this.range - split;
            value -= bigsplit;
            bit = 1;
        }
        int count = this.bit_count;
        int shift = Globals.vp8dxBitreaderNorm[range];
        range <<= shift;
        value <<= shift;
        if ((count -= shift) <= 0) {
            value |= this.data.readUnsignedByte() << -count;
            ++this.offset;
            count += 8;
        }
        this.bit_count = count;
        this.value = value;
        this.range = range;
        return bit;
    }

    public int readLiteral(int num_bits) throws IOException {
        int v = 0;
        while (num_bits-- > 0) {
            v = (v << 1) + this.readBool(128);
        }
        return v;
    }

    int readTree(int[] t2, int[] p) throws IOException {
        int i = 0;
        while ((i = t2[i + this.readBool(p[i >> 1])]) > 0) {
        }
        return -i;
    }

    int readTreeSkip(int[] t2, int[] p, int skip_branches) throws IOException {
        int i = skip_branches * 2;
        while ((i = t2[i + this.readBool(p[i >> 1])]) > 0) {
        }
        return -i;
    }

    public void seek() throws IOException {
        this.data.seek(this.offset);
    }

    public String toString() {
        return "bc: " + this.value;
    }
}

