# Ini package

The Ini package provides support for parsing
[INI file](https://en.wikipedia.org/wiki/INI_file) formatted text.

* Currently _does not_ support multi-line entries.
* Any keys not in a section will be placed in the section ""

# Example code
```pony
// Parses the file 'example.ini' in the current working directory
// Output all the content
use "ini"
use "files"

actor Main
  new create(env:Env) =>
    try
      let ini_file = File(FilePath(env.root as AmbientAuth, "example.ini")?)
      let sections = IniParse(ini_file.lines())?
      for section in sections.keys() do
        env.out.print("Section name is: " + section)
        for key in sections(section)?.keys() do
          env.out.print(key + " = " + sections(section)?(key)?)
        end
      end
    end
```


## Public Types

* [type IniMap](ini-IniMap.md)
* [primitive IniParse](ini-IniParse.md)
* [primitive IniIncompleteSection](ini-IniIncompleteSection.md)
* [primitive IniNoDelimiter](ini-IniNoDelimiter.md)
* [type IniError](ini-IniError.md)
* [interface IniNotify](ini-IniNotify.md)
* [primitive Ini](ini-Ini.md)
