# _Aggregator
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L2)</span>
```pony
class ref _Aggregator
```

## Constructors

### create
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L11)</span>


```pony
new ref create(
  ponybench: PonyBench tag,
  runner: _Runner tag,
  config: BenchConfig val,
  overhead: Bool val)
: _Aggregator ref^
```
#### Parameters

*   ponybench: [PonyBench](ponybench-PonyBench.md) tag
*   runner: [_Runner](ponybench-_Runner.md) tag
*   config: [BenchConfig](ponybench-BenchConfig.md) val
*   overhead: [Bool](builtin-Bool.md) val

#### Returns

* [_Aggregator](ponybench-_Aggregator.md) ref^

---

## Public fields

### var iterations: [U64](builtin-U64.md) val
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L9)</span>



---

## Public Functions

### complete
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L23)</span>


```pony
fun ref complete(
  name: String val,
  t: U64 val)
: None val
```
#### Parameters

*   name: [String](builtin-String.md) val
*   t: [U64](builtin-U64.md) val

#### Returns

* [None](builtin-None.md) val

---

## Private Functions

### _calc_iterations
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L43)</span>


```pony
fun ref _calc_iterations(
  runtime: U64 val)
: (U64 val | None val)
```
#### Parameters

*   runtime: [U64](builtin-U64.md) val

#### Returns

* ([U64](builtin-U64.md) val | [None](builtin-None.md) val)

---

### _round_up
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L59)</span>


Round x up to a number of the form [1^x, 2^x, 3^x, 5^x].


```pony
fun box _round_up(
  x: U64 val)
: U64 val
```
#### Parameters

*   x: [U64](builtin-U64.md) val

#### Returns

* [U64](builtin-U64.md) val

---

### _round_down_10
<span class="source-link">[[Source]](src/ponybench/_aggregator.md#L76)</span>


Round down to the nearest power of 10.


```pony
fun box _round_down_10(
  x: U64 val)
: U64 val
```
#### Parameters

*   x: [U64](builtin-U64.md) val

#### Returns

* [U64](builtin-U64.md) val

---

