# ProcessNotify
<span class="source-link">[[Source]](src/process/process_notify.md#L1)</span>

Notifications for Process connections.


```pony
interface ref ProcessNotify
```

## Public Functions

### created
<span class="source-link">[[Source]](src/process/process_notify.md#L6)</span>


ProcessMonitor calls this when it is created.


```pony
fun ref created(
  process: ProcessMonitor ref)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref

#### Returns

* [None](builtin-None.md) val

---

### stdout
<span class="source-link">[[Source]](src/process/process_notify.md#L11)</span>


ProcessMonitor calls this when new data is received on STDOUT of the
forked process


```pony
fun ref stdout(
  process: ProcessMonitor ref,
  data: Array[U8 val] iso)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   data: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso

#### Returns

* [None](builtin-None.md) val

---

### stderr
<span class="source-link">[[Source]](src/process/process_notify.md#L17)</span>


ProcessMonitor calls this when new data is received on STDERR of the
forked process


```pony
fun ref stderr(
  process: ProcessMonitor ref,
  data: Array[U8 val] iso)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   data: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso

#### Returns

* [None](builtin-None.md) val

---

### failed
<span class="source-link">[[Source]](src/process/process_notify.md#L23)</span>


ProcessMonitor calls this if we run into errors communicating with the
forked process.


```pony
fun ref failed(
  process: ProcessMonitor ref,
  err: ProcessError val)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   err: [ProcessError](process-ProcessError.md) val

#### Returns

* [None](builtin-None.md) val

---

### expect
<span class="source-link">[[Source]](src/process/process_notify.md#L29)</span>


Called when the process monitor has been told to expect a certain quantity
of bytes. This allows nested notifiers to change the expected quantity,
which allows a lower level protocol to handle any framing.


```pony
fun ref expect(
  process: ProcessMonitor ref,
  qty: USize val)
: USize val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   qty: [USize](builtin-USize.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### dispose
<span class="source-link">[[Source]](src/process/process_notify.md#L37)</span>


Call when ProcessMonitor terminates to cleanup ProcessNotify.
We return the exit status of the child process, it can be either an instance of
[Exited](process-Exited.md) if the process finished. The childs exit code can be retrieved
using [Exited.exit_code()](process-Exited.md#exit_code).

On Posix systems, if the process has been killed by a signal (e.g. through the `kill` command),
`child_exit_status` will be an instance of [Signaled](process-Signaled.md) with the signal number
that terminated the process available via [Signaled.signal()](process-Signaled.md#signal).


```pony
fun ref dispose(
  process: ProcessMonitor ref,
  child_exit_status: (Exited val | Signaled val))
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   child_exit_status: ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)

#### Returns

* [None](builtin-None.md) val

---

