/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SmallSet<T>
extends AbstractSet<T> {
    T element1;
    T element2;
    T element3;

    public SmallSet() {
    }

    public SmallSet(Collection<T> collection) {
        if (collection.size() > 3) {
            throw new IllegalArgumentException("Trying to create a small set with too many elements - max 3, requested: " + collection.size());
        }
        for (T t : collection) {
            this.add(t);
        }
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new NullPointerException("SmallSet cannot store null values");
        }
        if (this.contains(t)) {
            return false;
        }
        if (this.element1 == null) {
            this.element1 = t;
            return true;
        }
        if (this.element2 == null) {
            this.element2 = t;
            return true;
        }
        if (this.element3 == null) {
            this.element3 = t;
            return true;
        }
        throw new IllegalStateException("cannot store more than 3 elements in a small set");
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        int oHash = o.hashCode();
        if (this.element1 != null && oHash == this.element1.hashCode() && o.equals(this.element1)) {
            this.element1 = null;
            return true;
        }
        if (this.element2 != null && oHash == this.element2.hashCode() && o.equals(this.element2)) {
            this.element2 = null;
            return true;
        }
        if (this.element3 != null && oHash == this.element3.hashCode() && o.equals(this.element3)) {
            this.element3 = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        int oHash = o.hashCode();
        if (this.element1 != null && oHash == this.element1.hashCode() && o.equals(this.element1)) {
            return true;
        }
        if (this.element2 != null && oHash == this.element2.hashCode() && o.equals(this.element2)) {
            return true;
        }
        return this.element3 != null && oHash == this.element3.hashCode() && o.equals(this.element3);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int cp = 1;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public boolean hasNext() {
                switch (this.cp) {
                    case 1: {
                        if (SmallSet.this.element1 != null) {
                            return true;
                        }
                        ++this.cp;
                    }
                    case 2: {
                        if (SmallSet.this.element2 != null) {
                            return true;
                        }
                        ++this.cp;
                    }
                    case 3: {
                        if (SmallSet.this.element3 != null) {
                            return true;
                        }
                        ++this.cp;
                    }
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No Next Element");
                }
                switch (this.cp++) {
                    case 1: {
                        return SmallSet.this.element1;
                    }
                    case 2: {
                        return SmallSet.this.element2;
                    }
                    case 3: {
                        return SmallSet.this.element3;
                    }
                }
                throw new IllegalStateException("Iterator pointing past end of virtual array");
            }
        };
    }

    @Override
    public int size() {
        int count = 0;
        if (this.element1 != null) {
            ++count;
        }
        if (this.element2 != null) {
            ++count;
        }
        if (this.element3 != null) {
            ++count;
        }
        return count;
    }

    @Override
    public String toString() {
        return String.format("#<SmallSet: %s,%s,%s>", this.element1, this.element2, this.element3);
    }
}

