/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.prefix.PrefixList;
import org.protege.editor.owl.ui.prefix.PrefixMapping;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.protege.editor.owl.ui.view.AbstractActiveOntologyViewComponent;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;

public class PrefixMapperView
extends AbstractActiveOntologyViewComponent {
    private final PrefixList prefixList = new PrefixList();
    private OWLModelManagerListener entitiesChangedListener = event -> {
        if (event.getType() == EventType.ENTITY_RENDERER_CHANGED) {
            this.updateView(this.getOWLModelManager().getActiveOntology());
        }
    };

    @Override
    protected void initialiseOntologyView() {
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane((Component)((Object)this.prefixList)), "Center");
        this.updateView(this.getOWLModelManager().getActiveOntology());
        this.getOWLModelManager().addListener(this.entitiesChangedListener);
        this.prefixList.setPrefixMappingsChangedHandler(this::commitPrefixes);
    }

    @Override
    protected void disposeOntologyView() {
        this.getOWLModelManager().removeListener(this.entitiesChangedListener);
    }

    @Override
    protected void updateView(OWLOntology activeOntology) {
        PrefixDocumentFormat prefixDocumentFormat = PrefixUtilities.getPrefixOWLOntologyFormat(activeOntology);
        List<PrefixMapping> list = prefixDocumentFormat.getPrefixNames().stream().sorted().map(pn -> {
            String p = prefixDocumentFormat.getPrefix(pn);
            return PrefixMapping.get(pn, p);
        }).collect(Collectors.toList());
        this.prefixList.setPrefixMappings(list);
    }

    public void commitPrefixes() {
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        PrefixDocumentFormat prefixDocumentFormat = PrefixUtilities.getPrefixOWLOntologyFormat(activeOntology);
        prefixDocumentFormat.clear();
        this.prefixList.getPrefixMappings().forEach(pm -> prefixDocumentFormat.setPrefix(pm.getPrefixName(), pm.getPrefix()));
        this.getOWLModelManager().setDirty(this.getOWLModelManager().getActiveOntology());
        OWLModelManagerEntityRenderer renderer = this.getOWLModelManager().getOWLEntityRenderer();
        if (renderer instanceof PrefixBasedRenderer) {
            this.getOWLModelManager().refreshRenderer();
        }
    }
}

