# This file has been autogenerated by the pywayland scanner

# Copyright © 2020 Aleix Pol Gonzalez <aleixpol@kde.org>
# Copyright © 2020 Carlos Garnacho <carlosg@gnome.org>
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSeat
from ..wayland import WlSurface


class XdgActivationTokenV1(Interface):
    """An exported activation handle

    An object for setting up a token and receiving a token handle that can be
    passed as an activation token to another client.

    The object is created using the
    :func:`XdgActivationV1.get_activation_token()
    <pywayland.protocol.xdg_activation_v1.XdgActivationV1.get_activation_token>`
    request. This object should then be populated with the app_id, surface and
    serial information and committed. The compositor shall then issue a done
    event with the token. In case the request's parameters are invalid, the
    compositor will provide an invalid token.
    """

    name = "xdg_activation_token_v1"
    version = 1

    class error(enum.IntEnum):
        already_used = 0


class XdgActivationTokenV1Proxy(Proxy[XdgActivationTokenV1]):
    interface = XdgActivationTokenV1

    @XdgActivationTokenV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def set_serial(self, serial: int, seat: WlSeat) -> None:
        """Specifies the seat and serial of the activating event

        Provides information about the seat and serial event that requested the
        token.

        The serial can come from an input or focus event. For instance, if a
        click triggers the launch of a third-party client, the launcher client
        should send a set_serial request with the serial and seat from the
        :func:`WlPointer.button()
        <pywayland.protocol.wayland.WlPointer.button>` event.

        Some compositors might refuse to activate toplevels when the token
        doesn't have a valid and recent enough event serial.

        Must be sent before commit. This information is optional.

        :param serial:
            the serial of the event that triggered the activation
        :type serial:
            `ArgumentType.Uint`
        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        """
        self._marshal(0, serial, seat)

    @XdgActivationTokenV1.request(
        Argument(ArgumentType.String),
    )
    def set_app_id(self, app_id: str) -> None:
        """Specifies the application being activated

        The requesting client can specify an app_id to associate the token
        being created with it.

        Must be sent before commit. This information is optional.

        :param app_id:
            the application id of the client being activated.
        :type app_id:
            `ArgumentType.String`
        """
        self._marshal(1, app_id)

    @XdgActivationTokenV1.request(
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def set_surface(self, surface: WlSurface) -> None:
        """Specifies the surface requesting activation

        This request sets the surface requesting the activation. Note, this is
        different from the surface that will be activated.

        Some compositors might refuse to activate toplevels when the token
        doesn't have a requesting surface.

        Must be sent before commit. This information is optional.

        :param surface:
            the requesting surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        """
        self._marshal(2, surface)

    @XdgActivationTokenV1.request()
    def commit(self) -> None:
        """Issues the token request

        Requests an activation token based on the different parameters that
        have been offered through set_serial, set_surface and set_app_id.
        """
        self._marshal(3)

    @XdgActivationTokenV1.request()
    def destroy(self) -> None:
        """Destroy the :class:`XdgActivationTokenV1` object

        Notify the compositor that the :class:`XdgActivationTokenV1` object
        will no longer be used. The received token stays valid.
        """
        self._marshal(4)
        self._destroy()


class XdgActivationTokenV1Resource(Resource):
    interface = XdgActivationTokenV1

    @XdgActivationTokenV1.event(
        Argument(ArgumentType.String),
    )
    def done(self, token: str) -> None:
        """The exported activation token

        The 'done' event contains the unique token of this activation request
        and notifies that the provider is done.

        :param token:
            the exported activation token
        :type token:
            `ArgumentType.String`
        """
        self._post_event(0, token)


class XdgActivationTokenV1Global(Global):
    interface = XdgActivationTokenV1


XdgActivationTokenV1._gen_c()
XdgActivationTokenV1.proxy_class = XdgActivationTokenV1Proxy
XdgActivationTokenV1.resource_class = XdgActivationTokenV1Resource
XdgActivationTokenV1.global_class = XdgActivationTokenV1Global
